// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary object describing a participant that has joined a stage.
 */
public class ParticipantSummary private constructor(builder: Builder) {
    /**
     * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
     */
    public val firstJoinTime: aws.smithy.kotlin.runtime.time.Instant? = builder.firstJoinTime
    /**
     * Unique identifier for this participant, assigned by IVS.
     */
    public val participantId: kotlin.String? = builder.participantId
    /**
     * Whether the participant ever published to the stage session.
     */
    public val published: kotlin.Boolean = builder.published
    /**
     * Whether the participant is connected to or disconnected from the stage.
     */
    public val state: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantState? = builder.state
    /**
     * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information*.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParticipantSummary(")
        append("firstJoinTime=$firstJoinTime,")
        append("participantId=$participantId,")
        append("published=$published,")
        append("state=$state,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = firstJoinTime?.hashCode() ?: 0
        result = 31 * result + (participantId?.hashCode() ?: 0)
        result = 31 * result + (published.hashCode())
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParticipantSummary

        if (firstJoinTime != other.firstJoinTime) return false
        if (participantId != other.participantId) return false
        if (published != other.published) return false
        if (state != other.state) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
         */
        public var firstJoinTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique identifier for this participant, assigned by IVS.
         */
        public var participantId: kotlin.String? = null
        /**
         * Whether the participant ever published to the stage session.
         */
        public var published: kotlin.Boolean = false
        /**
         * Whether the participant is connected to or disconnected from the stage.
         */
        public var state: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantState? = null
        /**
         * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information*.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantSummary) : this() {
            this.firstJoinTime = x.firstJoinTime
            this.participantId = x.participantId
            this.published = x.published
            this.state = x.state
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantSummary = ParticipantSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
