// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model



public class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The ARN of the resource to be tagged. The ARN must be URL-encoded.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * Array of tags to be added or updated. Array of maps, each of the form `string:string (key:value)`. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints beyond what is documented there.
     */
    public val tags: Map<String, String> = requireNotNull(builder.tags) { "A non-null value must be provided for tags" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn.hashCode()
        result = 31 * result + (tags.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.TagResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the resource to be tagged. The ARN must be URL-encoded.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * Array of tags to be added or updated. Array of maps, each of the form `string:string (key:value)`. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints beyond what is documented there.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.TagResourceRequest = TagResourceRequest(this)

        internal fun correctErrors(): Builder {
            if (resourceArn == null) resourceArn = ""
            if (tags == null) tags = emptyMap()
            return this
        }
    }
}
