// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivschat.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateChatTokenRequest private constructor(builder: Builder) {
    /**
     * Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).
     */
    public val capabilities: List<ChatTokenCapability>? = builder.capabilities
    /**
     * Identifier of the room that the client is trying to access. Currently this must be an ARN.
     */
    public val roomIdentifier: kotlin.String = requireNotNull(builder.roomIdentifier) { "A non-null value must be provided for roomIdentifier" }
    /**
     * Session duration (in minutes), after which the session expires. Default: 60 (1 hour).
     */
    public val sessionDurationInMinutes: kotlin.Int? = builder.sessionDurationInMinutes
    /**
     * Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.
     */
    public val userId: kotlin.String = requireNotNull(builder.userId) { "A non-null value must be provided for userId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivschat.model.CreateChatTokenRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChatTokenRequest(")
        append("attributes=*** Sensitive Data Redacted ***,")
        append("capabilities=$capabilities,")
        append("roomIdentifier=$roomIdentifier,")
        append("sessionDurationInMinutes=$sessionDurationInMinutes,")
        append("userId=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (roomIdentifier.hashCode())
        result = 31 * result + (sessionDurationInMinutes ?: 0)
        result = 31 * result + (userId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChatTokenRequest

        if (attributes != other.attributes) return false
        if (capabilities != other.capabilities) return false
        if (roomIdentifier != other.roomIdentifier) return false
        if (sessionDurationInMinutes != other.sessionDurationInMinutes) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivschat.model.CreateChatTokenRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Application-provided attributes to encode into the token and attach to a chat session. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.
         */
        public var attributes: Map<String, String>? = null
        /**
         * Set of capabilities that the user is allowed to perform in the room. Default: None (the capability to view messages is implicitly included in all requests).
         */
        public var capabilities: List<ChatTokenCapability>? = null
        /**
         * Identifier of the room that the client is trying to access. Currently this must be an ARN.
         */
        public var roomIdentifier: kotlin.String? = null
        /**
         * Session duration (in minutes), after which the session expires. Default: 60 (1 hour).
         */
        public var sessionDurationInMinutes: kotlin.Int? = null
        /**
         * Application-provided ID that uniquely identifies the user associated with this token. This can be any UTF-8 encoded text.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivschat.model.CreateChatTokenRequest) : this() {
            this.attributes = x.attributes
            this.capabilities = x.capabilities
            this.roomIdentifier = x.roomIdentifier
            this.sessionDurationInMinutes = x.sessionDurationInMinutes
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivschat.model.CreateChatTokenRequest = CreateChatTokenRequest(this)

        internal fun correctErrors(): Builder {
            if (roomIdentifier == null) roomIdentifier = ""
            if (userId == null) userId = ""
            return this
        }
    }
}
