// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivschat

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.ivschat.auth.DefaultIvschatAuthSchemeProvider
import aws.sdk.kotlin.services.ivschat.auth.IvschatAuthSchemeProvider
import aws.sdk.kotlin.services.ivschat.endpoints.DefaultIvschatEndpointProvider
import aws.sdk.kotlin.services.ivschat.endpoints.IvschatEndpointParameters
import aws.sdk.kotlin.services.ivschat.endpoints.IvschatEndpointProvider
import aws.sdk.kotlin.services.ivschat.model.CreateChatTokenRequest
import aws.sdk.kotlin.services.ivschat.model.CreateChatTokenResponse
import aws.sdk.kotlin.services.ivschat.model.CreateLoggingConfigurationRequest
import aws.sdk.kotlin.services.ivschat.model.CreateLoggingConfigurationResponse
import aws.sdk.kotlin.services.ivschat.model.CreateRoomRequest
import aws.sdk.kotlin.services.ivschat.model.CreateRoomResponse
import aws.sdk.kotlin.services.ivschat.model.DeleteLoggingConfigurationRequest
import aws.sdk.kotlin.services.ivschat.model.DeleteLoggingConfigurationResponse
import aws.sdk.kotlin.services.ivschat.model.DeleteMessageRequest
import aws.sdk.kotlin.services.ivschat.model.DeleteMessageResponse
import aws.sdk.kotlin.services.ivschat.model.DeleteRoomRequest
import aws.sdk.kotlin.services.ivschat.model.DeleteRoomResponse
import aws.sdk.kotlin.services.ivschat.model.DisconnectUserRequest
import aws.sdk.kotlin.services.ivschat.model.DisconnectUserResponse
import aws.sdk.kotlin.services.ivschat.model.GetLoggingConfigurationRequest
import aws.sdk.kotlin.services.ivschat.model.GetLoggingConfigurationResponse
import aws.sdk.kotlin.services.ivschat.model.GetRoomRequest
import aws.sdk.kotlin.services.ivschat.model.GetRoomResponse
import aws.sdk.kotlin.services.ivschat.model.ListLoggingConfigurationsRequest
import aws.sdk.kotlin.services.ivschat.model.ListLoggingConfigurationsResponse
import aws.sdk.kotlin.services.ivschat.model.ListRoomsRequest
import aws.sdk.kotlin.services.ivschat.model.ListRoomsResponse
import aws.sdk.kotlin.services.ivschat.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ivschat.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ivschat.model.SendEventRequest
import aws.sdk.kotlin.services.ivschat.model.SendEventResponse
import aws.sdk.kotlin.services.ivschat.model.TagResourceRequest
import aws.sdk.kotlin.services.ivschat.model.TagResourceResponse
import aws.sdk.kotlin.services.ivschat.model.UntagResourceRequest
import aws.sdk.kotlin.services.ivschat.model.UntagResourceResponse
import aws.sdk.kotlin.services.ivschat.model.UpdateLoggingConfigurationRequest
import aws.sdk.kotlin.services.ivschat.model.UpdateLoggingConfigurationResponse
import aws.sdk.kotlin.services.ivschat.model.UpdateRoomRequest
import aws.sdk.kotlin.services.ivschat.model.UpdateRoomResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ivschat"
public const val SdkVersion: String = "1.2.38"
public const val ServiceApiVersion: String = "2020-07-14"

/**
 * **Introduction**
 *
 * The Amazon IVS Chat control-plane API enables you to create and manage Amazon IVS Chat resources. You also need to integrate with the [ Amazon IVS Chat Messaging API](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/chat-messaging-api.html), to enable users to interact with chat rooms in real time.
 *
 * The API is an AWS regional service. For a list of supported regions and Amazon IVS Chat HTTPS service endpoints, see the Amazon IVS Chat information on the [Amazon IVS page](https://docs.aws.amazon.com/general/latest/gr/ivs.html) in the *AWS General Reference*.
 *
 * **Notes on terminology:**
 * + You create service applications using the Amazon IVS Chat API. We refer to these as *applications*.
 * + You create front-end client applications (browser and Android/iOS apps) using the Amazon IVS Chat Messaging API. We refer to these as *clients*.
 *
 * **Key Concepts**
 * + **LoggingConfiguration** — A configuration that allows customers to store and record sent messages in a chat room.
 * + **Room** — The central Amazon IVS Chat resource through which clients connect to and exchange chat messages.
 *
 * **Tagging**
 *
 * A *tag* is a metadata label that you assign to an AWS resource. A tag comprises a *key* and a *value*, both set by you. For example, you might set a tag as `topic:nature` to label a particular video category. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no service-specific constraints beyond what is documented there.
 *
 * Tags can help you identify and organize your AWS resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see [Access Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
 *
 * The Amazon IVS Chat API has these tag-related endpoints: TagResource, UntagResource, and ListTagsForResource. The following resource supports tagging: Room.
 *
 * At most 50 tags can be applied to a resource.
 *
 * **API Access Security**
 *
 * Your Amazon IVS Chat applications (service applications and clients) must be authenticated and authorized to access Amazon IVS Chat resources. Note the differences between these concepts:
 * + *Authentication* is about verifying identity. Requests to the Amazon IVS Chat API must be signed to verify your identity.
 * + *Authorization* is about granting permissions. Your IAM roles need to have permissions for Amazon IVS Chat API requests.
 *
 * Users (viewers) connect to a room using secure access tokens that you create using the CreateChatToken endpoint through the AWS SDK. You call CreateChatToken for every user’s chat session, passing identity and authorization information about the user.
 *
 * **Signing API Requests**
 *
 * HTTP API requests must be signed with an AWS SigV4 signature using your AWS security credentials. The AWS Command Line Interface (CLI) and the AWS SDKs take care of signing the underlying API calls for you. However, if your application calls the Amazon IVS Chat HTTP API directly, it’s your responsibility to sign the requests.
 *
 * You generate a signature using valid AWS credentials for an IAM role that has permission to perform the requested action. For example, DeleteMessage requests must be made using an IAM role that has the `ivschat:DeleteMessage` permission.
 *
 * For more information:
 * + Authentication and generating signatures — See [Authenticating Requests (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html) in the *Amazon Web Services General Reference*.
 * + Managing Amazon IVS permissions — See [Identity and Access Management](https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html) on the Security page of the *Amazon IVS User Guide*.
 *
 * **Amazon Resource Names (ARNs)**
 *
 * ARNs uniquely identify AWS resources. An ARN is required when you need to specify a resource unambiguously across all of AWS, such as in IAM policies and API calls. For more information, see [Amazon Resource Names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
 *
 * **Messaging Endpoints**
 * + DeleteMessage — Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s `EventName` is `aws:DELETE_MESSAGE`. This replicates the [ DeleteMessage](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
 * + DisconnectUser — Disconnects all connections using a specified user ID from a room. This replicates the [ DisconnectUser](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
 * + SendEvent — Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.
 *
 * **Chat Token Endpoint**
 * + CreateChatToken — Creates an encrypted token that is used by a chat participant to establish an individual WebSocket chat connection to a room. When the token is used to connect to chat, the connection is valid for the session duration specified in the request. The token becomes invalid at the token-expiration timestamp included in the response.
 *
 * **Room Endpoints**
 * + CreateRoom — Creates a room that allows clients to connect and pass messages.
 * + DeleteRoom — Deletes the specified room.
 * + GetRoom — Gets the specified room.
 * + ListRooms — Gets summary information about all your rooms in the AWS region where the API request is processed.
 * + UpdateRoom — Updates a room’s configuration.
 *
 * **Logging Configuration Endpoints**
 * + CreateLoggingConfiguration — Creates a logging configuration that allows clients to store and record sent messages.
 * + DeleteLoggingConfiguration — Deletes the specified logging configuration.
 * + GetLoggingConfiguration — Gets the specified logging configuration.
 * + ListLoggingConfigurations — Gets summary information about all your logging configurations in the AWS region where the API request is processed.
 * + UpdateLoggingConfiguration — Updates a specified logging configuration.
 *
 * **Tags Endpoints**
 * + ListTagsForResource — Gets information about AWS tags for the specified ARN.
 * + TagResource — Adds or updates tags for the AWS resource with the specified ARN.
 * + UntagResource — Removes tags from the resource with the specified ARN.
 *
 * All the above are HTTP operations. There is a separate *messaging* API for managing Chat resources; see the [ Amazon IVS Chat Messaging API Reference](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/chat-messaging-api.html).
 */
public interface IvschatClient : SdkClient {
    /**
     * IvschatClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IvschatClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Ivschat",
                "IVSCHAT",
                "ivschat",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IvschatClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IvschatClient = DefaultIvschatClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IvschatEndpointProvider = builder.endpointProvider ?: DefaultIvschatEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IvschatAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIvschatAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ivschat"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IvschatEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IvschatAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an encrypted token that is used by a chat participant to establish an individual WebSocket chat connection to a room. When the token is used to connect to chat, the connection is valid for the session duration specified in the request. The token becomes invalid at the token-expiration timestamp included in the response.
     *
     * Use the `capabilities` field to permit an end user to send messages or moderate a room.
     *
     * The `attributes` field securely attaches structured data to the chat session; the data is included within each message sent by the end user and received by other participants in the room. Common use cases for attributes include passing end-user profile data like an icon, display name, colors, badges, and other display features.
     *
     * Encryption keys are owned by Amazon IVS Chat and never used directly by your application.
     */
    public suspend fun createChatToken(input: CreateChatTokenRequest): CreateChatTokenResponse

    /**
     * Creates a logging configuration that allows clients to store and record sent messages.
     */
    public suspend fun createLoggingConfiguration(input: CreateLoggingConfigurationRequest): CreateLoggingConfigurationResponse

    /**
     * Creates a room that allows clients to connect and pass messages.
     */
    public suspend fun createRoom(input: CreateRoomRequest = CreateRoomRequest { }): CreateRoomResponse

    /**
     * Deletes the specified logging configuration.
     */
    public suspend fun deleteLoggingConfiguration(input: DeleteLoggingConfigurationRequest): DeleteLoggingConfigurationResponse

    /**
     * Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s `EventName` is `aws:DELETE_MESSAGE`. This replicates the [ DeleteMessage](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
     */
    public suspend fun deleteMessage(input: DeleteMessageRequest): DeleteMessageResponse

    /**
     * Deletes the specified room.
     */
    public suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse

    /**
     * Disconnects all connections using a specified user ID from a room. This replicates the [ DisconnectUser](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
     */
    public suspend fun disconnectUser(input: DisconnectUserRequest): DisconnectUserResponse

    /**
     * Gets the specified logging configuration.
     */
    public suspend fun getLoggingConfiguration(input: GetLoggingConfigurationRequest): GetLoggingConfigurationResponse

    /**
     * Gets the specified room.
     */
    public suspend fun getRoom(input: GetRoomRequest): GetRoomResponse

    /**
     * Gets summary information about all your logging configurations in the AWS region where the API request is processed.
     */
    public suspend fun listLoggingConfigurations(input: ListLoggingConfigurationsRequest = ListLoggingConfigurationsRequest { }): ListLoggingConfigurationsResponse

    /**
     * Gets summary information about all your rooms in the AWS region where the API request is processed. Results are sorted in descending order of `updateTime`.
     */
    public suspend fun listRooms(input: ListRoomsRequest = ListRoomsRequest { }): ListRoomsResponse

    /**
     * Gets information about AWS tags for the specified ARN.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.
     */
    public suspend fun sendEvent(input: SendEventRequest): SendEventResponse

    /**
     * Adds or updates tags for the AWS resource with the specified ARN.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the resource with the specified ARN.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a specified logging configuration.
     */
    public suspend fun updateLoggingConfiguration(input: UpdateLoggingConfigurationRequest): UpdateLoggingConfigurationResponse

    /**
     * Updates a room’s configuration.
     */
    public suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IvschatClient.withConfig(block: IvschatClient.Config.Builder.() -> Unit): IvschatClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIvschatClient(newConfig)
}

/**
 * Creates an encrypted token that is used by a chat participant to establish an individual WebSocket chat connection to a room. When the token is used to connect to chat, the connection is valid for the session duration specified in the request. The token becomes invalid at the token-expiration timestamp included in the response.
 *
 * Use the `capabilities` field to permit an end user to send messages or moderate a room.
 *
 * The `attributes` field securely attaches structured data to the chat session; the data is included within each message sent by the end user and received by other participants in the room. Common use cases for attributes include passing end-user profile data like an icon, display name, colors, badges, and other display features.
 *
 * Encryption keys are owned by Amazon IVS Chat and never used directly by your application.
 */
public suspend inline fun IvschatClient.createChatToken(crossinline block: CreateChatTokenRequest.Builder.() -> Unit): CreateChatTokenResponse = createChatToken(CreateChatTokenRequest.Builder().apply(block).build())

/**
 * Creates a logging configuration that allows clients to store and record sent messages.
 */
public suspend inline fun IvschatClient.createLoggingConfiguration(crossinline block: CreateLoggingConfigurationRequest.Builder.() -> Unit): CreateLoggingConfigurationResponse = createLoggingConfiguration(CreateLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a room that allows clients to connect and pass messages.
 */
public suspend inline fun IvschatClient.createRoom(crossinline block: CreateRoomRequest.Builder.() -> Unit): CreateRoomResponse = createRoom(CreateRoomRequest.Builder().apply(block).build())

/**
 * Deletes the specified logging configuration.
 */
public suspend inline fun IvschatClient.deleteLoggingConfiguration(crossinline block: DeleteLoggingConfigurationRequest.Builder.() -> Unit): DeleteLoggingConfigurationResponse = deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s `EventName` is `aws:DELETE_MESSAGE`. This replicates the [ DeleteMessage](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
 */
public suspend inline fun IvschatClient.deleteMessage(crossinline block: DeleteMessageRequest.Builder.() -> Unit): DeleteMessageResponse = deleteMessage(DeleteMessageRequest.Builder().apply(block).build())

/**
 * Deletes the specified room.
 */
public suspend inline fun IvschatClient.deleteRoom(crossinline block: DeleteRoomRequest.Builder.() -> Unit): DeleteRoomResponse = deleteRoom(DeleteRoomRequest.Builder().apply(block).build())

/**
 * Disconnects all connections using a specified user ID from a room. This replicates the [ DisconnectUser](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
 */
public suspend inline fun IvschatClient.disconnectUser(crossinline block: DisconnectUserRequest.Builder.() -> Unit): DisconnectUserResponse = disconnectUser(DisconnectUserRequest.Builder().apply(block).build())

/**
 * Gets the specified logging configuration.
 */
public suspend inline fun IvschatClient.getLoggingConfiguration(crossinline block: GetLoggingConfigurationRequest.Builder.() -> Unit): GetLoggingConfigurationResponse = getLoggingConfiguration(GetLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Gets the specified room.
 */
public suspend inline fun IvschatClient.getRoom(crossinline block: GetRoomRequest.Builder.() -> Unit): GetRoomResponse = getRoom(GetRoomRequest.Builder().apply(block).build())

/**
 * Gets summary information about all your logging configurations in the AWS region where the API request is processed.
 */
public suspend inline fun IvschatClient.listLoggingConfigurations(crossinline block: ListLoggingConfigurationsRequest.Builder.() -> Unit): ListLoggingConfigurationsResponse = listLoggingConfigurations(ListLoggingConfigurationsRequest.Builder().apply(block).build())

/**
 * Gets summary information about all your rooms in the AWS region where the API request is processed. Results are sorted in descending order of `updateTime`.
 */
public suspend inline fun IvschatClient.listRooms(crossinline block: ListRoomsRequest.Builder.() -> Unit): ListRoomsResponse = listRooms(ListRoomsRequest.Builder().apply(block).build())

/**
 * Gets information about AWS tags for the specified ARN.
 */
public suspend inline fun IvschatClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.
 */
public suspend inline fun IvschatClient.sendEvent(crossinline block: SendEventRequest.Builder.() -> Unit): SendEventResponse = sendEvent(SendEventRequest.Builder().apply(block).build())

/**
 * Adds or updates tags for the AWS resource with the specified ARN.
 */
public suspend inline fun IvschatClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the resource with the specified ARN.
 */
public suspend inline fun IvschatClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a specified logging configuration.
 */
public suspend inline fun IvschatClient.updateLoggingConfiguration(crossinline block: UpdateLoggingConfigurationRequest.Builder.() -> Unit): UpdateLoggingConfigurationResponse = updateLoggingConfiguration(UpdateLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a room’s configuration.
 */
public suspend inline fun IvschatClient.updateRoom(crossinline block: UpdateRoomRequest.Builder.() -> Unit): UpdateRoomResponse = updateRoom(UpdateRoomRequest.Builder().apply(block).build())
