// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivschat.serde

import aws.sdk.kotlin.services.ivschat.model.CreateChatTokenResponse
import aws.sdk.kotlin.services.ivschat.model.IvschatException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateChatTokenOperationDeserializer: HttpDeserialize<CreateChatTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateChatTokenResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateChatTokenError(context, call)
        }
        val builder = CreateChatTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateChatTokenOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateChatTokenError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IvschatException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "PendingVerification" -> PendingVerificationDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IvschatException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateChatTokenOperationBody(builder: CreateChatTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SESSIONEXPIRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("sessionExpirationTime"))
    val TOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("token"))
    val TOKENEXPIRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("tokenExpirationTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SESSIONEXPIRATIONTIME_DESCRIPTOR)
        field(TOKEN_DESCRIPTOR)
        field(TOKENEXPIRATIONTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SESSIONEXPIRATIONTIME_DESCRIPTOR.index -> builder.sessionExpirationTime = deserializeString().let { Instant.fromIso8601(it) }
                TOKEN_DESCRIPTOR.index -> builder.token = deserializeString()
                TOKENEXPIRATIONTIME_DESCRIPTOR.index -> builder.tokenExpirationTime = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
