// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivschat.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a logging configuration.
 */
public class LoggingConfigurationSummary private constructor(builder: Builder) {
    /**
     * Logging-configuration ARN.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Time when the logging configuration was created. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * A complex type that contains a destination configuration for where chat content will be logged.
     */
    public val destinationConfiguration: aws.sdk.kotlin.services.ivschat.model.DestinationConfiguration? = builder.destinationConfiguration
    /**
     * Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Logging-configuration name. The value does not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The state of the logging configuration. When this is `ACTIVE`, the configuration is ready for logging chat content.
     */
    public val state: aws.sdk.kotlin.services.ivschat.model.LoggingConfigurationState? = builder.state
    /**
     * Tags to attach to the resource. Array of maps, each of the form `string:string (key:value)`. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no constraints on tags beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Time of the logging configuration’s last update. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivschat.model.LoggingConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfigurationSummary(")
        append("arn=$arn,")
        append("createTime=$createTime,")
        append("destinationConfiguration=$destinationConfiguration,")
        append("id=$id,")
        append("name=$name,")
        append("state=$state,")
        append("tags=$tags,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (destinationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingConfigurationSummary

        if (arn != other.arn) return false
        if (createTime != other.createTime) return false
        if (destinationConfiguration != other.destinationConfiguration) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivschat.model.LoggingConfigurationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Logging-configuration ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Time when the logging configuration was created. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A complex type that contains a destination configuration for where chat content will be logged.
         */
        public var destinationConfiguration: aws.sdk.kotlin.services.ivschat.model.DestinationConfiguration? = null
        /**
         * Logging-configuration ID, generated by the system. This is a relative identifier, the part of the ARN that uniquely identifies the room.
         */
        public var id: kotlin.String? = null
        /**
         * Logging-configuration name. The value does not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The state of the logging configuration. When this is `ACTIVE`, the configuration is ready for logging chat content.
         */
        public var state: aws.sdk.kotlin.services.ivschat.model.LoggingConfigurationState? = null
        /**
         * Tags to attach to the resource. Array of maps, each of the form `string:string (key:value)`. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS Chat has no constraints on tags beyond what is documented there.
         */
        public var tags: Map<String, String>? = null
        /**
         * Time of the logging configuration’s last update. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivschat.model.LoggingConfigurationSummary) : this() {
            this.arn = x.arn
            this.createTime = x.createTime
            this.destinationConfiguration = x.destinationConfiguration
            this.id = x.id
            this.name = x.name
            this.state = x.state
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivschat.model.LoggingConfigurationSummary = LoggingConfigurationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
