// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ivs.model.CreateStreamKeyResponse
import aws.sdk.kotlin.services.ivs.model.IvsException
import aws.sdk.kotlin.services.ivs.model.StreamKey
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateStreamKeyOperationDeserializer: HttpDeserialize<CreateStreamKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateStreamKeyResponse {
        if (!response.status.isSuccess()) {
            throwCreateStreamKeyError(context, response)
        }
        val builder = CreateStreamKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateStreamKeyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateStreamKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IvsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PendingVerification" -> PendingVerificationDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IvsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateStreamKeyOperationBody(builder: CreateStreamKeyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STREAMKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("streamKey"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STREAMKEY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STREAMKEY_DESCRIPTOR.index -> builder.streamKey = deserializeStreamKeyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
