// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ivs.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.ivs.model.*
import aws.sdk.kotlin.services.ivs.model.BatchGetChannelRequest
import aws.sdk.kotlin.services.ivs.model.BatchGetChannelResponse
import aws.sdk.kotlin.services.ivs.model.BatchGetStreamKeyRequest
import aws.sdk.kotlin.services.ivs.model.BatchGetStreamKeyResponse
import aws.sdk.kotlin.services.ivs.model.CreateChannelRequest
import aws.sdk.kotlin.services.ivs.model.CreateChannelResponse
import aws.sdk.kotlin.services.ivs.model.CreateRecordingConfigurationRequest
import aws.sdk.kotlin.services.ivs.model.CreateRecordingConfigurationResponse
import aws.sdk.kotlin.services.ivs.model.CreateStreamKeyRequest
import aws.sdk.kotlin.services.ivs.model.CreateStreamKeyResponse
import aws.sdk.kotlin.services.ivs.model.DeleteChannelRequest
import aws.sdk.kotlin.services.ivs.model.DeleteChannelResponse
import aws.sdk.kotlin.services.ivs.model.DeletePlaybackKeyPairRequest
import aws.sdk.kotlin.services.ivs.model.DeletePlaybackKeyPairResponse
import aws.sdk.kotlin.services.ivs.model.DeleteRecordingConfigurationRequest
import aws.sdk.kotlin.services.ivs.model.DeleteRecordingConfigurationResponse
import aws.sdk.kotlin.services.ivs.model.DeleteStreamKeyRequest
import aws.sdk.kotlin.services.ivs.model.DeleteStreamKeyResponse
import aws.sdk.kotlin.services.ivs.model.GetChannelRequest
import aws.sdk.kotlin.services.ivs.model.GetChannelResponse
import aws.sdk.kotlin.services.ivs.model.GetPlaybackKeyPairRequest
import aws.sdk.kotlin.services.ivs.model.GetPlaybackKeyPairResponse
import aws.sdk.kotlin.services.ivs.model.GetRecordingConfigurationRequest
import aws.sdk.kotlin.services.ivs.model.GetRecordingConfigurationResponse
import aws.sdk.kotlin.services.ivs.model.GetStreamKeyRequest
import aws.sdk.kotlin.services.ivs.model.GetStreamKeyResponse
import aws.sdk.kotlin.services.ivs.model.GetStreamRequest
import aws.sdk.kotlin.services.ivs.model.GetStreamResponse
import aws.sdk.kotlin.services.ivs.model.GetStreamSessionRequest
import aws.sdk.kotlin.services.ivs.model.GetStreamSessionResponse
import aws.sdk.kotlin.services.ivs.model.ImportPlaybackKeyPairRequest
import aws.sdk.kotlin.services.ivs.model.ImportPlaybackKeyPairResponse
import aws.sdk.kotlin.services.ivs.model.ListChannelsRequest
import aws.sdk.kotlin.services.ivs.model.ListChannelsResponse
import aws.sdk.kotlin.services.ivs.model.ListPlaybackKeyPairsRequest
import aws.sdk.kotlin.services.ivs.model.ListPlaybackKeyPairsResponse
import aws.sdk.kotlin.services.ivs.model.ListRecordingConfigurationsRequest
import aws.sdk.kotlin.services.ivs.model.ListRecordingConfigurationsResponse
import aws.sdk.kotlin.services.ivs.model.ListStreamKeysRequest
import aws.sdk.kotlin.services.ivs.model.ListStreamKeysResponse
import aws.sdk.kotlin.services.ivs.model.ListStreamSessionsRequest
import aws.sdk.kotlin.services.ivs.model.ListStreamSessionsResponse
import aws.sdk.kotlin.services.ivs.model.ListStreamsRequest
import aws.sdk.kotlin.services.ivs.model.ListStreamsResponse
import aws.sdk.kotlin.services.ivs.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ivs.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ivs.model.PutMetadataRequest
import aws.sdk.kotlin.services.ivs.model.PutMetadataResponse
import aws.sdk.kotlin.services.ivs.model.StopStreamRequest
import aws.sdk.kotlin.services.ivs.model.StopStreamResponse
import aws.sdk.kotlin.services.ivs.model.TagResourceRequest
import aws.sdk.kotlin.services.ivs.model.TagResourceResponse
import aws.sdk.kotlin.services.ivs.model.UntagResourceRequest
import aws.sdk.kotlin.services.ivs.model.UntagResourceResponse
import aws.sdk.kotlin.services.ivs.model.UpdateChannelRequest
import aws.sdk.kotlin.services.ivs.model.UpdateChannelResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * **Introduction**
 *
 * The Amazon Interactive Video Service (IVS) API is REST compatible, using a standard HTTP API and an Amazon Web Services EventBridge event stream for responses. JSON is used for both requests and responses, including errors.
 *
 * The API is an Amazon Web Services regional service. For a list of supported regions and Amazon IVS HTTPS service endpoints, see the [Amazon IVS page](https://docs.aws.amazon.com/general/latest/gr/ivs.html) in the *Amazon Web Services General Reference*.
 *
 * ***All API request parameters and URLs are case sensitive. ***
 *
 * For a summary of notable documentation changes in each release, see [ Document History](https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html).
 *
 * **Allowed Header Values**
 * + ` <b>Accept:</b> ` application/json
 * + ` <b>Accept-Encoding:</b> ` gzip, deflate
 * + ` <b>Content-Type:</b> `application/json
 *
 * **Resources**
 *
 * The following resources contain information about your IVS live stream (see [ Getting Started with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/getting-started.html)):
 * + Channel — Stores configuration data related to your live stream. You first create a channel and then use the channel’s stream key to start your live stream. See the Channel endpoints for more information.
 * + Stream key — An identifier assigned by Amazon IVS when you create a channel, which is then used to authorize streaming. See the StreamKey endpoints for more information. ***Treat the stream key like a secret, since it allows anyone to stream to the channel.***
 * + Playback key pair — Video playback may be restricted using playback-authorization tokens, which use public-key encryption. A playback key pair is the public-private pair of keys used to sign and validate the playback-authorization token. See the PlaybackKeyPair endpoints for more information.
 * + Recording configuration — Stores configuration related to recording a live stream and where to store the recorded content. Multiple channels can reference the same recording configuration. See the Recording Configuration endpoints for more information.
 *
 * **Tagging**
 *
 * A *tag* is a metadata label that you assign to an Amazon Web Services resource. A tag comprises a *key* and a *value*, both set by you. For example, you might set a tag as `topic:nature` to label a particular video category. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
 *
 * Tags can help you identify and organize your Amazon Web Services resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see [ Access Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
 *
 * The Amazon IVS API has these tag-related endpoints: TagResource, UntagResource, and ListTagsForResource. The following resources support tagging: Channels, Stream Keys, Playback Key Pairs, and Recording Configurations.
 *
 * At most 50 tags can be applied to a resource.
 *
 * **Authentication versus Authorization**
 *
 * Note the differences between these concepts:
 * + *Authentication* is about verifying identity. You need to be authenticated to sign Amazon IVS API requests.
 * + *Authorization* is about granting permissions. Your IAM roles need to have permissions for Amazon IVS API requests. In addition, authorization is needed to view [Amazon IVS private channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html). (Private channels are channels that are enabled for "playback authorization.")
 *
 * **Authentication**
 *
 * All Amazon IVS API requests must be authenticated with a signature. The Amazon Web Services Command-Line Interface (CLI) and Amazon IVS Player SDKs take care of signing the underlying API calls for you. However, if your application calls the Amazon IVS API directly, it’s your responsibility to sign the requests.
 *
 * You generate a signature using valid Amazon Web Services credentials that have permission to perform the requested action. For example, you must sign PutMetadata requests with a signature generated from an IAM user account that has the `ivs:PutMetadata` permission.
 *
 * For more information:
 * + Authentication and generating signatures — See [Authenticating Requests (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html) in the *Amazon Web Services General Reference*.
 * + Managing Amazon IVS permissions — See [Identity and Access Management](https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html) on the Security page of the *Amazon IVS User Guide*.
 *
 * **Amazon Resource Names (ARNs)**
 *
 * ARNs uniquely identify AWS resources. An ARN is required when you need to specify a resource unambiguously across all of AWS, such as in IAM policies and API calls. For more information, see [Amazon Resource Names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
 *
 * **Channel Endpoints**
 * + CreateChannel — Creates a new channel and an associated stream key to start streaming.
 * + GetChannel — Gets the channel configuration for the specified channel ARN.
 * + BatchGetChannel — Performs GetChannel on multiple ARNs simultaneously.
 * + ListChannels — Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 Conflict Exception).
 * + UpdateChannel — Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.
 * + DeleteChannel — Deletes the specified channel.
 *
 * **StreamKey Endpoints**
 * + CreateStreamKey — Creates a stream key, used to initiate a stream, for the specified channel ARN.
 * + GetStreamKey — Gets stream key information for the specified ARN.
 * + BatchGetStreamKey — Performs GetStreamKey on multiple ARNs simultaneously.
 * + ListStreamKeys — Gets summary information about stream keys for the specified channel.
 * + DeleteStreamKey — Deletes the stream key for the specified ARN, so it can no longer be used to stream.
 *
 * **Stream Endpoints**
 * + GetStream — Gets information about the active (live) stream on a specified channel.
 * + GetStreamSession — Gets metadata on a specified stream.
 * + ListStreams — Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.
 * + ListStreamSessions — Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.
 * + StopStream — Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with DeleteStreamKey to prevent further streaming to a channel.
 * + PutMetadata — Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed.
 *
 * **PlaybackKeyPair Endpoints**
 *
 * For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
 * + ImportPlaybackKeyPair — Imports the public portion of a new key pair and returns its `arn` and `fingerprint`. The `privateKey` can then be used to generate viewer authorization tokens, to grant viewers access to private channels (channels enabled for playback authorization).
 * + GetPlaybackKeyPair — Gets a specified playback authorization key pair and returns the `arn` and `fingerprint`. The `privateKey` held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels.
 * + ListPlaybackKeyPairs — Gets summary information about playback key pairs.
 * + DeletePlaybackKeyPair — Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s `privateKey`.
 *
 * **RecordingConfiguration Endpoints**
 * + CreateRecordingConfiguration — Creates a new recording configuration, used to enable recording to Amazon S3.
 * + GetRecordingConfiguration — Gets the recording-configuration metadata for the specified ARN.
 * + ListRecordingConfigurations — Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.
 * + DeleteRecordingConfiguration — Deletes the recording configuration for the specified ARN.
 *
 * **Amazon Web Services Tags Endpoints**
 * + TagResource — Adds or updates tags for the Amazon Web Services resource with the specified ARN.
 * + UntagResource — Removes tags from the resource with the specified ARN.
 * + ListTagsForResource — Gets information about Amazon Web Services tags for the specified ARN.
 */
public interface IvsClient : SdkClient {

    override val serviceName: String
        get() = "ivs"
    /**
     * IvsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): IvsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIvsClient(config)
        }

        public operator fun invoke(config: Config): IvsClient = DefaultIvsClient(config)

        /**
         * Construct a [IvsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IvsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultIvsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Performs GetChannel on multiple ARNs simultaneously.
     */
    public suspend fun batchGetChannel(input: BatchGetChannelRequest): BatchGetChannelResponse

    /**
     * Performs GetStreamKey on multiple ARNs simultaneously.
     */
    public suspend fun batchGetStreamKey(input: BatchGetStreamKeyRequest): BatchGetStreamKeyResponse

    /**
     * Creates a new channel and an associated stream key to start streaming.
     */
    public suspend fun createChannel(input: CreateChannelRequest = CreateChannelRequest {}): CreateChannelResponse

    /**
     * Creates a new recording configuration, used to enable recording to Amazon S3.
     *
     * **Known issue:** In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording configuration, it returns success even if the S3 bucket is in a different region. In this case, the `state` of the recording configuration is `CREATE_FAILED` (instead of `ACTIVE`). (In other regions, the CLI correctly returns failure if the bucket is in a different region.)
     *
     * **Workaround:** Ensure that your S3 bucket is in the same region as the recording configuration. If you create a recording configuration in a different region as your S3 bucket, delete that recording configuration and create a new one with an S3 bucket from the correct region.
     */
    public suspend fun createRecordingConfiguration(input: CreateRecordingConfigurationRequest): CreateRecordingConfigurationResponse

    /**
     * Creates a stream key, used to initiate a stream, for the specified channel ARN.
     *
     * Note that CreateChannel creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use DeleteStreamKey and then CreateStreamKey.
     */
    public suspend fun createStreamKey(input: CreateStreamKeyRequest): CreateStreamKeyResponse

    /**
     * Deletes the specified channel and its associated stream keys.
     *
     * If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is live, call StopStream, wait for the Amazon EventBridge "Stream End" event (to verify that the stream's state was changed from Live to Offline), then call DeleteChannel. (See [ Using EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).)
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s `privateKey`. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    public suspend fun deletePlaybackKeyPair(input: DeletePlaybackKeyPairRequest): DeletePlaybackKeyPairResponse

    /**
     * Deletes the recording configuration for the specified ARN.
     *
     * If you try to delete a recording configuration that is associated with a channel, you will get an error (409 ConflictException). To avoid this, for all channels that reference the recording configuration, first use UpdateChannel to set the `recordingConfigurationArn` field to an empty string, then use DeleteRecordingConfiguration.
     */
    public suspend fun deleteRecordingConfiguration(input: DeleteRecordingConfigurationRequest): DeleteRecordingConfigurationResponse

    /**
     * Deletes the stream key for the specified ARN, so it can no longer be used to stream.
     */
    public suspend fun deleteStreamKey(input: DeleteStreamKeyRequest): DeleteStreamKeyResponse

    /**
     * Gets the channel configuration for the specified channel ARN. See also BatchGetChannel.
     */
    public suspend fun getChannel(input: GetChannelRequest): GetChannelResponse

    /**
     * Gets a specified playback authorization key pair and returns the `arn` and `fingerprint`. The `privateKey` held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    public suspend fun getPlaybackKeyPair(input: GetPlaybackKeyPairRequest): GetPlaybackKeyPairResponse

    /**
     * Gets the recording configuration for the specified ARN.
     */
    public suspend fun getRecordingConfiguration(input: GetRecordingConfigurationRequest): GetRecordingConfigurationResponse

    /**
     * Gets information about the active (live) stream on a specified channel.
     */
    public suspend fun getStream(input: GetStreamRequest): GetStreamResponse

    /**
     * Gets stream-key information for a specified ARN.
     */
    public suspend fun getStreamKey(input: GetStreamKeyRequest): GetStreamKeyResponse

    /**
     * Gets metadata on a specified stream.
     */
    public suspend fun getStreamSession(input: GetStreamSessionRequest): GetStreamSessionResponse

    /**
     * Imports the public portion of a new key pair and returns its `arn` and `fingerprint`. The `privateKey` can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    public suspend fun importPlaybackKeyPair(input: ImportPlaybackKeyPairRequest): ImportPlaybackKeyPairResponse

    /**
     * Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).
     */
    public suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * Gets summary information about playback key pairs. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    public suspend fun listPlaybackKeyPairs(input: ListPlaybackKeyPairsRequest = ListPlaybackKeyPairsRequest {}): ListPlaybackKeyPairsResponse

    /**
     * Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.
     */
    public suspend fun listRecordingConfigurations(input: ListRecordingConfigurationsRequest = ListRecordingConfigurationsRequest {}): ListRecordingConfigurationsResponse

    /**
     * Gets summary information about stream keys for the specified channel.
     */
    public suspend fun listStreamKeys(input: ListStreamKeysRequest): ListStreamKeysResponse

    /**
     * Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.
     */
    public suspend fun listStreamSessions(input: ListStreamSessionsRequest): ListStreamSessionsResponse

    /**
     * Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.
     */
    public suspend fun listStreams(input: ListStreamsRequest = ListStreamsRequest {}): ListStreamsResponse

    /**
     * Gets information about Amazon Web Services tags for the specified ARN.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see [Embedding Metadata within a Video Stream](https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html) in the *Amazon IVS User Guide*.
     */
    public suspend fun putMetadata(input: PutMetadataRequest): PutMetadataResponse

    /**
     * Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with DeleteStreamKey to prevent further streaming to a channel.
     *
     * Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the `streamKey` attached to the channel.
     */
    public suspend fun stopStream(input: StopStreamRequest): StopStreamResponse

    /**
     * Adds or updates tags for the Amazon Web Services resource with the specified ARN.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the resource with the specified ARN.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse
}

/**
 * Performs GetChannel on multiple ARNs simultaneously.
 */
public suspend inline fun IvsClient.batchGetChannel(crossinline block: BatchGetChannelRequest.Builder.() -> Unit): BatchGetChannelResponse = batchGetChannel(BatchGetChannelRequest.Builder().apply(block).build())

/**
 * Performs GetStreamKey on multiple ARNs simultaneously.
 */
public suspend inline fun IvsClient.batchGetStreamKey(crossinline block: BatchGetStreamKeyRequest.Builder.() -> Unit): BatchGetStreamKeyResponse = batchGetStreamKey(BatchGetStreamKeyRequest.Builder().apply(block).build())

/**
 * Creates a new channel and an associated stream key to start streaming.
 */
public suspend inline fun IvsClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Creates a new recording configuration, used to enable recording to Amazon S3.
 *
 * **Known issue:** In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording configuration, it returns success even if the S3 bucket is in a different region. In this case, the `state` of the recording configuration is `CREATE_FAILED` (instead of `ACTIVE`). (In other regions, the CLI correctly returns failure if the bucket is in a different region.)
 *
 * **Workaround:** Ensure that your S3 bucket is in the same region as the recording configuration. If you create a recording configuration in a different region as your S3 bucket, delete that recording configuration and create a new one with an S3 bucket from the correct region.
 */
public suspend inline fun IvsClient.createRecordingConfiguration(crossinline block: CreateRecordingConfigurationRequest.Builder.() -> Unit): CreateRecordingConfigurationResponse = createRecordingConfiguration(CreateRecordingConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a stream key, used to initiate a stream, for the specified channel ARN.
 *
 * Note that CreateChannel creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use DeleteStreamKey and then CreateStreamKey.
 */
public suspend inline fun IvsClient.createStreamKey(crossinline block: CreateStreamKeyRequest.Builder.() -> Unit): CreateStreamKeyResponse = createStreamKey(CreateStreamKeyRequest.Builder().apply(block).build())

/**
 * Deletes the specified channel and its associated stream keys.
 *
 * If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is live, call StopStream, wait for the Amazon EventBridge "Stream End" event (to verify that the stream's state was changed from Live to Offline), then call DeleteChannel. (See [ Using EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).)
 */
public suspend inline fun IvsClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s `privateKey`. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
 */
public suspend inline fun IvsClient.deletePlaybackKeyPair(crossinline block: DeletePlaybackKeyPairRequest.Builder.() -> Unit): DeletePlaybackKeyPairResponse = deletePlaybackKeyPair(DeletePlaybackKeyPairRequest.Builder().apply(block).build())

/**
 * Deletes the recording configuration for the specified ARN.
 *
 * If you try to delete a recording configuration that is associated with a channel, you will get an error (409 ConflictException). To avoid this, for all channels that reference the recording configuration, first use UpdateChannel to set the `recordingConfigurationArn` field to an empty string, then use DeleteRecordingConfiguration.
 */
public suspend inline fun IvsClient.deleteRecordingConfiguration(crossinline block: DeleteRecordingConfigurationRequest.Builder.() -> Unit): DeleteRecordingConfigurationResponse = deleteRecordingConfiguration(DeleteRecordingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the stream key for the specified ARN, so it can no longer be used to stream.
 */
public suspend inline fun IvsClient.deleteStreamKey(crossinline block: DeleteStreamKeyRequest.Builder.() -> Unit): DeleteStreamKeyResponse = deleteStreamKey(DeleteStreamKeyRequest.Builder().apply(block).build())

/**
 * Gets the channel configuration for the specified channel ARN. See also BatchGetChannel.
 */
public suspend inline fun IvsClient.getChannel(crossinline block: GetChannelRequest.Builder.() -> Unit): GetChannelResponse = getChannel(GetChannelRequest.Builder().apply(block).build())

/**
 * Gets a specified playback authorization key pair and returns the `arn` and `fingerprint`. The `privateKey` held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
 */
public suspend inline fun IvsClient.getPlaybackKeyPair(crossinline block: GetPlaybackKeyPairRequest.Builder.() -> Unit): GetPlaybackKeyPairResponse = getPlaybackKeyPair(GetPlaybackKeyPairRequest.Builder().apply(block).build())

/**
 * Gets the recording configuration for the specified ARN.
 */
public suspend inline fun IvsClient.getRecordingConfiguration(crossinline block: GetRecordingConfigurationRequest.Builder.() -> Unit): GetRecordingConfigurationResponse = getRecordingConfiguration(GetRecordingConfigurationRequest.Builder().apply(block).build())

/**
 * Gets information about the active (live) stream on a specified channel.
 */
public suspend inline fun IvsClient.getStream(crossinline block: GetStreamRequest.Builder.() -> Unit): GetStreamResponse = getStream(GetStreamRequest.Builder().apply(block).build())

/**
 * Gets stream-key information for a specified ARN.
 */
public suspend inline fun IvsClient.getStreamKey(crossinline block: GetStreamKeyRequest.Builder.() -> Unit): GetStreamKeyResponse = getStreamKey(GetStreamKeyRequest.Builder().apply(block).build())

/**
 * Gets metadata on a specified stream.
 */
public suspend inline fun IvsClient.getStreamSession(crossinline block: GetStreamSessionRequest.Builder.() -> Unit): GetStreamSessionResponse = getStreamSession(GetStreamSessionRequest.Builder().apply(block).build())

/**
 * Imports the public portion of a new key pair and returns its `arn` and `fingerprint`. The `privateKey` can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
 */
public suspend inline fun IvsClient.importPlaybackKeyPair(crossinline block: ImportPlaybackKeyPairRequest.Builder.() -> Unit): ImportPlaybackKeyPairResponse = importPlaybackKeyPair(ImportPlaybackKeyPairRequest.Builder().apply(block).build())

/**
 * Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).
 */
public suspend inline fun IvsClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Gets summary information about playback key pairs. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
 */
public suspend inline fun IvsClient.listPlaybackKeyPairs(crossinline block: ListPlaybackKeyPairsRequest.Builder.() -> Unit): ListPlaybackKeyPairsResponse = listPlaybackKeyPairs(ListPlaybackKeyPairsRequest.Builder().apply(block).build())

/**
 * Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.
 */
public suspend inline fun IvsClient.listRecordingConfigurations(crossinline block: ListRecordingConfigurationsRequest.Builder.() -> Unit): ListRecordingConfigurationsResponse = listRecordingConfigurations(ListRecordingConfigurationsRequest.Builder().apply(block).build())

/**
 * Gets summary information about stream keys for the specified channel.
 */
public suspend inline fun IvsClient.listStreamKeys(crossinline block: ListStreamKeysRequest.Builder.() -> Unit): ListStreamKeysResponse = listStreamKeys(ListStreamKeysRequest.Builder().apply(block).build())

/**
 * Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.
 */
public suspend inline fun IvsClient.listStreamSessions(crossinline block: ListStreamSessionsRequest.Builder.() -> Unit): ListStreamSessionsResponse = listStreamSessions(ListStreamSessionsRequest.Builder().apply(block).build())

/**
 * Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.
 */
public suspend inline fun IvsClient.listStreams(crossinline block: ListStreamsRequest.Builder.() -> Unit): ListStreamsResponse = listStreams(ListStreamsRequest.Builder().apply(block).build())

/**
 * Gets information about Amazon Web Services tags for the specified ARN.
 */
public suspend inline fun IvsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see [Embedding Metadata within a Video Stream](https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html) in the *Amazon IVS User Guide*.
 */
public suspend inline fun IvsClient.putMetadata(crossinline block: PutMetadataRequest.Builder.() -> Unit): PutMetadataResponse = putMetadata(PutMetadataRequest.Builder().apply(block).build())

/**
 * Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with DeleteStreamKey to prevent further streaming to a channel.
 *
 * Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the `streamKey` attached to the channel.
 */
public suspend inline fun IvsClient.stopStream(crossinline block: StopStreamRequest.Builder.() -> Unit): StopStreamResponse = stopStream(StopStreamRequest.Builder().apply(block).build())

/**
 * Adds or updates tags for the Amazon Web Services resource with the specified ARN.
 */
public suspend inline fun IvsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the resource with the specified ARN.
 */
public suspend inline fun IvsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.
 */
public suspend inline fun IvsClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())
