// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Object specifying a stream’s events. For a list of events, see [Using Amazon EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
 */
public class StreamEvent private constructor(builder: Builder) {
    /**
     * Provides additional details about the stream event. There are several values; the long descriptions are provided in the IVS console but not delivered through the IVS API or EventBridge. Multitrack-related codes are used only for certain Session Ended events.
     * + `MultitrackInputNotAllowed` — The broadcast client attempted to connect with multitrack input, but multitrack input was not enabled on the channel. Check your broadcast software settings or set `MultitrackInputConfiguration.Policy` to `ALLOW` or `REQUIRE`.
     * + `MultitrackInputRequired` — The broadcast client attempted to connect with single-track video, but multitrack input is required on this channel. Enable multitrack video in your broadcast software or configure the channel’s `MultitrackInputConfiguration.Policy` to `ALLOW`.
     * + `InvalidGetClientConfigurationStreamKey` — The broadcast client attempted to connect with an invalid, expired, or corrupt stream key.
     * + `GetClientConfigurationStreamKeyRequired` — The broadcast client attempted to stream multitrack video without providing an authenticated stream key from GetClientConfiguration.
     * + `InvalidMultitrackInputTrackCount` — The multitrack input stream contained an invalid number of tracks.
     * + `InvalidMultitrackInputVideoTrackMediaProperties` — The multitrack input stream contained one or more tracks with an invalid codec, resolution, bitrate, or framerate.
     * + `StreamTakeoverMediaMismatch` — The broadcast client attempted to take over with different media properties (e.g., codec, resolution, or video track type) from the original stream.
     * + `StreamTakeoverInvalidPriority` — The broadcast client attempted a takeover with either a priority integer value equal to or lower than the original stream's value or a value outside the allowed range of 1 to 2,147,483,647.`StreamTakeoverLimitBreached` — The broadcast client reached the maximum allowed takeover attempts for this stream.
     */
    public val code: kotlin.String? = builder.code
    /**
     * Time when the event occurred. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * Name that identifies the stream event within a `type`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Logical group for certain events.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.StreamEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamEvent(")
        append("code=$code,")
        append("eventTime=$eventTime,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamEvent

        if (code != other.code) return false
        if (eventTime != other.eventTime) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.StreamEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides additional details about the stream event. There are several values; the long descriptions are provided in the IVS console but not delivered through the IVS API or EventBridge. Multitrack-related codes are used only for certain Session Ended events.
         * + `MultitrackInputNotAllowed` — The broadcast client attempted to connect with multitrack input, but multitrack input was not enabled on the channel. Check your broadcast software settings or set `MultitrackInputConfiguration.Policy` to `ALLOW` or `REQUIRE`.
         * + `MultitrackInputRequired` — The broadcast client attempted to connect with single-track video, but multitrack input is required on this channel. Enable multitrack video in your broadcast software or configure the channel’s `MultitrackInputConfiguration.Policy` to `ALLOW`.
         * + `InvalidGetClientConfigurationStreamKey` — The broadcast client attempted to connect with an invalid, expired, or corrupt stream key.
         * + `GetClientConfigurationStreamKeyRequired` — The broadcast client attempted to stream multitrack video without providing an authenticated stream key from GetClientConfiguration.
         * + `InvalidMultitrackInputTrackCount` — The multitrack input stream contained an invalid number of tracks.
         * + `InvalidMultitrackInputVideoTrackMediaProperties` — The multitrack input stream contained one or more tracks with an invalid codec, resolution, bitrate, or framerate.
         * + `StreamTakeoverMediaMismatch` — The broadcast client attempted to take over with different media properties (e.g., codec, resolution, or video track type) from the original stream.
         * + `StreamTakeoverInvalidPriority` — The broadcast client attempted a takeover with either a priority integer value equal to or lower than the original stream's value or a value outside the allowed range of 1 to 2,147,483,647.`StreamTakeoverLimitBreached` — The broadcast client reached the maximum allowed takeover attempts for this stream.
         */
        public var code: kotlin.String? = null
        /**
         * Time when the event occurred. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Name that identifies the stream event within a `type`.
         */
        public var name: kotlin.String? = null
        /**
         * Logical group for certain events.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.StreamEvent) : this() {
            this.code = x.code
            this.eventTime = x.eventTime
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.StreamEvent = StreamEvent(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
