// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Object specifying the ingest configuration set up by the broadcaster, usually in an encoder.
 *
 * **Note:** Use IngestConfigurations instead of IngestConfiguration (which is deprecated). If multitrack is not enabled, IngestConfiguration and IngestConfigurations contain the same data, namely information about track0 (the sole track). If multitrack is enabled, IngestConfiguration contains data for only the first track (track0) and IngestConfigurations contains data for all tracks.
 */
public class IngestConfigurations private constructor(builder: Builder) {
    /**
     * Encoder settings for audio.
     */
    public val audioConfigurations: List<AudioConfiguration> = requireNotNull(builder.audioConfigurations) { "A non-null value must be provided for audioConfigurations" }
    /**
     * Encoder settings for video
     */
    public val videoConfigurations: List<VideoConfiguration> = requireNotNull(builder.videoConfigurations) { "A non-null value must be provided for videoConfigurations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.IngestConfigurations = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IngestConfigurations(")
        append("audioConfigurations=$audioConfigurations,")
        append("videoConfigurations=$videoConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioConfigurations.hashCode()
        result = 31 * result + (videoConfigurations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IngestConfigurations

        if (audioConfigurations != other.audioConfigurations) return false
        if (videoConfigurations != other.videoConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.IngestConfigurations = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Encoder settings for audio.
         */
        public var audioConfigurations: List<AudioConfiguration>? = null
        /**
         * Encoder settings for video
         */
        public var videoConfigurations: List<VideoConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.IngestConfigurations) : this() {
            this.audioConfigurations = x.audioConfigurations
            this.videoConfigurations = x.videoConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.IngestConfigurations = IngestConfigurations(this)

        internal fun correctErrors(): Builder {
            if (audioConfigurations == null) audioConfigurations = emptyList()
            if (videoConfigurations == null) videoConfigurations = emptyList()
            return this
        }
    }
}
