// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Object specifying a stream’s audio configuration, as set up by the broadcaster (usually in an encoder). This is part of the IngestConfigurations object and the deprecated IngestConfiguration object. It is used for monitoring stream health.
 */
public class AudioConfiguration private constructor(builder: Builder) {
    /**
     * Number of audio channels.
     */
    public val channels: kotlin.Long = builder.channels
    /**
     * Codec used for the audio encoding.
     */
    public val codec: kotlin.String? = builder.codec
    /**
     * Number of audio samples recorded per second.
     */
    public val sampleRate: kotlin.Long = builder.sampleRate
    /**
     * The expected ingest bitrate (bits per second). This is configured in the encoder.
     */
    public val targetBitrate: kotlin.Long = builder.targetBitrate
    /**
     * Name of the audio track (if the stream has an audio track). If multitrack is not enabled, this is track0 (the sole track).
     */
    public val track: kotlin.String? = builder.track

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.AudioConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioConfiguration(")
        append("channels=$channels,")
        append("codec=$codec,")
        append("sampleRate=$sampleRate,")
        append("targetBitrate=$targetBitrate,")
        append("track=$track")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channels.hashCode()
        result = 31 * result + (codec?.hashCode() ?: 0)
        result = 31 * result + (sampleRate.hashCode())
        result = 31 * result + (targetBitrate.hashCode())
        result = 31 * result + (track?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioConfiguration

        if (channels != other.channels) return false
        if (codec != other.codec) return false
        if (sampleRate != other.sampleRate) return false
        if (targetBitrate != other.targetBitrate) return false
        if (track != other.track) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.AudioConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Number of audio channels.
         */
        public var channels: kotlin.Long = 0L
        /**
         * Codec used for the audio encoding.
         */
        public var codec: kotlin.String? = null
        /**
         * Number of audio samples recorded per second.
         */
        public var sampleRate: kotlin.Long = 0L
        /**
         * The expected ingest bitrate (bits per second). This is configured in the encoder.
         */
        public var targetBitrate: kotlin.Long = 0L
        /**
         * Name of the audio track (if the stream has an audio track). If multitrack is not enabled, this is track0 (the sole track).
         */
        public var track: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.AudioConfiguration) : this() {
            this.channels = x.channels
            this.codec = x.codec
            this.sampleRate = x.sampleRate
            this.targetBitrate = x.targetBitrate
            this.track = x.track
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.AudioConfiguration = AudioConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
