// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Summary information about a RecordingConfiguration.
 */
public class RecordingConfigurationSummary private constructor(builder: Builder) {
    /**
     * Recording-configuration ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * A complex type that contains information about where recorded video will be stored.
     */
    public val destinationConfiguration: aws.sdk.kotlin.services.ivs.model.DestinationConfiguration? = builder.destinationConfiguration
    /**
     * Recording-configuration name. The value does not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates the current state of the recording configuration. When the state is `ACTIVE`, the configuration is ready for recording a channel stream.
     */
    public val state: aws.sdk.kotlin.services.ivs.model.RecordingConfigurationState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * Tags attached to the resource. Array of 1-50 maps, each of the form `string:string (key:value)`. See [Best practices and strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html) in *Tagging Amazon Web Services Resources and Tag Editor* for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.RecordingConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecordingConfigurationSummary(")
        append("arn=$arn,")
        append("destinationConfiguration=$destinationConfiguration,")
        append("name=$name,")
        append("state=$state,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (destinationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecordingConfigurationSummary

        if (arn != other.arn) return false
        if (destinationConfiguration != other.destinationConfiguration) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.RecordingConfigurationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Recording-configuration ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * A complex type that contains information about where recorded video will be stored.
         */
        public var destinationConfiguration: aws.sdk.kotlin.services.ivs.model.DestinationConfiguration? = null
        /**
         * Recording-configuration name. The value does not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates the current state of the recording configuration. When the state is `ACTIVE`, the configuration is ready for recording a channel stream.
         */
        public var state: aws.sdk.kotlin.services.ivs.model.RecordingConfigurationState? = null
        /**
         * Tags attached to the resource. Array of 1-50 maps, each of the form `string:string (key:value)`. See [Best practices and strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html) in *Tagging Amazon Web Services Resources and Tag Editor* for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.RecordingConfigurationSummary) : this() {
            this.arn = x.arn
            this.destinationConfiguration = x.destinationConfiguration
            this.name = x.name
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.RecordingConfigurationSummary = RecordingConfigurationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.DestinationConfiguration] inside the given [block]
         */
        public fun destinationConfiguration(block: aws.sdk.kotlin.services.ivs.model.DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.destinationConfiguration = aws.sdk.kotlin.services.ivs.model.DestinationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (state == null) state = RecordingConfigurationState.SdkUnknown("no value provided")
            return this
        }
    }
}
