// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.paginators

import aws.sdk.kotlin.services.ivs.IvsClient
import aws.sdk.kotlin.services.ivs.model.ListChannelsRequest
import aws.sdk.kotlin.services.ivs.model.ListChannelsResponse
import aws.sdk.kotlin.services.ivs.model.ListPlaybackKeyPairsRequest
import aws.sdk.kotlin.services.ivs.model.ListPlaybackKeyPairsResponse
import aws.sdk.kotlin.services.ivs.model.ListPlaybackRestrictionPoliciesRequest
import aws.sdk.kotlin.services.ivs.model.ListPlaybackRestrictionPoliciesResponse
import aws.sdk.kotlin.services.ivs.model.ListRecordingConfigurationsRequest
import aws.sdk.kotlin.services.ivs.model.ListRecordingConfigurationsResponse
import aws.sdk.kotlin.services.ivs.model.ListStreamKeysRequest
import aws.sdk.kotlin.services.ivs.model.ListStreamKeysResponse
import aws.sdk.kotlin.services.ivs.model.ListStreamSessionsRequest
import aws.sdk.kotlin.services.ivs.model.ListStreamSessionsResponse
import aws.sdk.kotlin.services.ivs.model.ListStreamsRequest
import aws.sdk.kotlin.services.ivs.model.ListStreamsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun IvsClient.listChannelsPaginated(initialRequest: ListChannelsRequest = ListChannelsRequest { }): Flow<ListChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsPaginated.listChannels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun IvsClient.listChannelsPaginated(block: ListChannelsRequest.Builder.() -> Unit): Flow<ListChannelsResponse> =
    listChannelsPaginated(ListChannelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPlaybackKeyPairsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPlaybackKeyPairsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaybackKeyPairsResponse]
 */
public fun IvsClient.listPlaybackKeyPairsPaginated(initialRequest: ListPlaybackKeyPairsRequest = ListPlaybackKeyPairsRequest { }): Flow<ListPlaybackKeyPairsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPlaybackKeyPairsPaginated.listPlaybackKeyPairs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPlaybackKeyPairsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaybackKeyPairsResponse]
 */
public fun IvsClient.listPlaybackKeyPairsPaginated(block: ListPlaybackKeyPairsRequest.Builder.() -> Unit): Flow<ListPlaybackKeyPairsResponse> =
    listPlaybackKeyPairsPaginated(ListPlaybackKeyPairsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPlaybackRestrictionPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPlaybackRestrictionPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaybackRestrictionPoliciesResponse]
 */
public fun IvsClient.listPlaybackRestrictionPoliciesPaginated(initialRequest: ListPlaybackRestrictionPoliciesRequest = ListPlaybackRestrictionPoliciesRequest { }): Flow<ListPlaybackRestrictionPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPlaybackRestrictionPoliciesPaginated.listPlaybackRestrictionPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPlaybackRestrictionPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlaybackRestrictionPoliciesResponse]
 */
public fun IvsClient.listPlaybackRestrictionPoliciesPaginated(block: ListPlaybackRestrictionPoliciesRequest.Builder.() -> Unit): Flow<ListPlaybackRestrictionPoliciesResponse> =
    listPlaybackRestrictionPoliciesPaginated(ListPlaybackRestrictionPoliciesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRecordingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecordingConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecordingConfigurationsResponse]
 */
public fun IvsClient.listRecordingConfigurationsPaginated(initialRequest: ListRecordingConfigurationsRequest = ListRecordingConfigurationsRequest { }): Flow<ListRecordingConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecordingConfigurationsPaginated.listRecordingConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRecordingConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecordingConfigurationsResponse]
 */
public fun IvsClient.listRecordingConfigurationsPaginated(block: ListRecordingConfigurationsRequest.Builder.() -> Unit): Flow<ListRecordingConfigurationsResponse> =
    listRecordingConfigurationsPaginated(ListRecordingConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStreamKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStreamKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamKeysResponse]
 */
public fun IvsClient.listStreamKeysPaginated(initialRequest: ListStreamKeysRequest): Flow<ListStreamKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStreamKeysPaginated.listStreamKeys(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStreamKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamKeysResponse]
 */
public fun IvsClient.listStreamKeysPaginated(block: ListStreamKeysRequest.Builder.() -> Unit): Flow<ListStreamKeysResponse> =
    listStreamKeysPaginated(ListStreamKeysRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStreamsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamsResponse]
 */
public fun IvsClient.listStreamsPaginated(initialRequest: ListStreamsRequest = ListStreamsRequest { }): Flow<ListStreamsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStreamsPaginated.listStreams(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamsResponse]
 */
public fun IvsClient.listStreamsPaginated(block: ListStreamsRequest.Builder.() -> Unit): Flow<ListStreamsResponse> =
    listStreamsPaginated(ListStreamsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStreamSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStreamSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamSessionsResponse]
 */
public fun IvsClient.listStreamSessionsPaginated(initialRequest: ListStreamSessionsRequest): Flow<ListStreamSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStreamSessionsPaginated.listStreamSessions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStreamSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamSessionsResponse]
 */
public fun IvsClient.listStreamSessionsPaginated(block: ListStreamSessionsRequest.Builder.() -> Unit): Flow<ListStreamSessionsResponse> =
    listStreamSessionsPaginated(ListStreamSessionsRequest.Builder().apply(block).build())
