// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a stream.
 */
public class StreamSummary private constructor(builder: Builder) {
    /**
     * Channel ARN for the stream.
     */
    public val channelArn: kotlin.String? = builder.channelArn
    /**
     * The stream’s health.
     */
    public val health: aws.sdk.kotlin.services.ivs.model.StreamHealth? = builder.health
    /**
     * Time of the stream’s start. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The stream’s state. Do not rely on the `OFFLINE` state, as the API may not return it; instead, a "NotBroadcasting" error will indicate that the stream is not live.
     */
    public val state: aws.sdk.kotlin.services.ivs.model.StreamState? = builder.state
    /**
     * Unique identifier for a live or previously live stream in the specified channel.
     */
    public val streamId: kotlin.String? = builder.streamId
    /**
     * A count of concurrent views of the stream. Typically, a new view appears in `viewerCount` within 15 seconds of when video playback starts and a view is removed from `viewerCount` within 1 minute of when video playback ends. A value of -1 indicates that the request timed out; in this case, retry.
     */
    public val viewerCount: kotlin.Long = builder.viewerCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.StreamSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamSummary(")
        append("channelArn=$channelArn,")
        append("health=$health,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("streamId=$streamId,")
        append("viewerCount=$viewerCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelArn?.hashCode() ?: 0
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (viewerCount.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamSummary

        if (channelArn != other.channelArn) return false
        if (health != other.health) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (streamId != other.streamId) return false
        if (viewerCount != other.viewerCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.StreamSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Channel ARN for the stream.
         */
        public var channelArn: kotlin.String? = null
        /**
         * The stream’s health.
         */
        public var health: aws.sdk.kotlin.services.ivs.model.StreamHealth? = null
        /**
         * Time of the stream’s start. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The stream’s state. Do not rely on the `OFFLINE` state, as the API may not return it; instead, a "NotBroadcasting" error will indicate that the stream is not live.
         */
        public var state: aws.sdk.kotlin.services.ivs.model.StreamState? = null
        /**
         * Unique identifier for a live or previously live stream in the specified channel.
         */
        public var streamId: kotlin.String? = null
        /**
         * A count of concurrent views of the stream. Typically, a new view appears in `viewerCount` within 15 seconds of when video playback starts and a view is removed from `viewerCount` within 1 minute of when video playback ends. A value of -1 indicates that the request timed out; in this case, retry.
         */
        public var viewerCount: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.StreamSummary) : this() {
            this.channelArn = x.channelArn
            this.health = x.health
            this.startTime = x.startTime
            this.state = x.state
            this.streamId = x.streamId
            this.viewerCount = x.viewerCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.StreamSummary = StreamSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
