// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Object that captures the Amazon IVS configuration that the customer provisioned, the ingest configurations that the broadcaster used, and the most recent Amazon IVS stream events it encountered.
 */
public class StreamSession private constructor(builder: Builder) {
    /**
     * The properties of the channel at the time of going live.
     */
    public val channel: aws.sdk.kotlin.services.ivs.model.Channel? = builder.channel
    /**
     * Time when the channel went offline. This is an ISO 8601 timestamp; *note that this is returned as a string*. For live streams, this is `NULL`.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The properties of the incoming RTMP stream for the stream.
     */
    public val ingestConfiguration: aws.sdk.kotlin.services.ivs.model.IngestConfiguration? = builder.ingestConfiguration
    /**
     * The properties of recording the live stream.
     */
    public val recordingConfiguration: aws.sdk.kotlin.services.ivs.model.RecordingConfiguration? = builder.recordingConfiguration
    /**
     * Time when the channel went live. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Unique identifier for a live or previously live stream in the specified channel.
     */
    public val streamId: kotlin.String? = builder.streamId
    /**
     * List of Amazon IVS events that the stream encountered. The list is sorted by most recent events and contains up to 500 events. For Amazon IVS events, see [Using Amazon EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
     */
    public val truncatedEvents: List<StreamEvent>? = builder.truncatedEvents

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.StreamSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamSession(")
        append("channel=$channel,")
        append("endTime=$endTime,")
        append("ingestConfiguration=$ingestConfiguration,")
        append("recordingConfiguration=$recordingConfiguration,")
        append("startTime=$startTime,")
        append("streamId=$streamId,")
        append("truncatedEvents=$truncatedEvents")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channel?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (ingestConfiguration?.hashCode() ?: 0)
        result = 31 * result + (recordingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (truncatedEvents?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamSession

        if (channel != other.channel) return false
        if (endTime != other.endTime) return false
        if (ingestConfiguration != other.ingestConfiguration) return false
        if (recordingConfiguration != other.recordingConfiguration) return false
        if (startTime != other.startTime) return false
        if (streamId != other.streamId) return false
        if (truncatedEvents != other.truncatedEvents) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.StreamSession = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The properties of the channel at the time of going live.
         */
        public var channel: aws.sdk.kotlin.services.ivs.model.Channel? = null
        /**
         * Time when the channel went offline. This is an ISO 8601 timestamp; *note that this is returned as a string*. For live streams, this is `NULL`.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The properties of the incoming RTMP stream for the stream.
         */
        public var ingestConfiguration: aws.sdk.kotlin.services.ivs.model.IngestConfiguration? = null
        /**
         * The properties of recording the live stream.
         */
        public var recordingConfiguration: aws.sdk.kotlin.services.ivs.model.RecordingConfiguration? = null
        /**
         * Time when the channel went live. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique identifier for a live or previously live stream in the specified channel.
         */
        public var streamId: kotlin.String? = null
        /**
         * List of Amazon IVS events that the stream encountered. The list is sorted by most recent events and contains up to 500 events. For Amazon IVS events, see [Using Amazon EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
         */
        public var truncatedEvents: List<StreamEvent>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.StreamSession) : this() {
            this.channel = x.channel
            this.endTime = x.endTime
            this.ingestConfiguration = x.ingestConfiguration
            this.recordingConfiguration = x.recordingConfiguration
            this.startTime = x.startTime
            this.streamId = x.streamId
            this.truncatedEvents = x.truncatedEvents
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.StreamSession = StreamSession(this)

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.Channel] inside the given [block]
         */
        public fun channel(block: aws.sdk.kotlin.services.ivs.model.Channel.Builder.() -> kotlin.Unit) {
            this.channel = aws.sdk.kotlin.services.ivs.model.Channel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.IngestConfiguration] inside the given [block]
         */
        public fun ingestConfiguration(block: aws.sdk.kotlin.services.ivs.model.IngestConfiguration.Builder.() -> kotlin.Unit) {
            this.ingestConfiguration = aws.sdk.kotlin.services.ivs.model.IngestConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.RecordingConfiguration] inside the given [block]
         */
        public fun recordingConfiguration(block: aws.sdk.kotlin.services.ivs.model.RecordingConfiguration.Builder.() -> kotlin.Unit) {
            this.recordingConfiguration = aws.sdk.kotlin.services.ivs.model.RecordingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
