// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



public class UpdateChannelRequest private constructor(builder: Builder) {
    /**
     * ARN of the channel to be updated.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Whether the channel is private (enabled for playback authorization).
     */
    public val authorized: kotlin.Boolean = builder.authorized
    /**
     * Whether the channel allows insecure RTMP ingest. Default: `false`.
     */
    public val insecureIngest: kotlin.Boolean = builder.insecureIngest
    /**
     * Channel latency mode. Use `NORMAL` to broadcast and deliver live video up to Full HD. Use `LOW` for near-real-time interaction with viewers. (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to Ultra-low and Standard, respectively.)
     */
    public val latencyMode: aws.sdk.kotlin.services.ivs.model.ChannelLatencyMode? = builder.latencyMode
    /**
     * Channel name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Optional transcode preset for the channel. This is selectable only for `ADVANCED_HD` and `ADVANCED_SD` channel types. For those channel types, the default `preset` is `HIGHER_BANDWIDTH_DELIVERY`. For other channel types (`BASIC` and `STANDARD`), `preset` is the empty string (`""`).
     */
    public val preset: aws.sdk.kotlin.services.ivs.model.TranscodePreset? = builder.preset
    /**
     * Recording-configuration ARN. If this is set to an empty string, recording is disabled. A value other than an empty string indicates that recording is enabled
     */
    public val recordingConfigurationArn: kotlin.String? = builder.recordingConfigurationArn
    /**
     * Channel type, which determines the allowable resolution and bitrate. *If you exceed the allowable input resolution or bitrate, the stream probably will disconnect immediately.* Default: `STANDARD`. For details, see [Channel Types](https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html).
     */
    public val type: aws.sdk.kotlin.services.ivs.model.ChannelType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.UpdateChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateChannelRequest(")
        append("arn=$arn,")
        append("authorized=$authorized,")
        append("insecureIngest=$insecureIngest,")
        append("latencyMode=$latencyMode,")
        append("name=$name,")
        append("preset=$preset,")
        append("recordingConfigurationArn=$recordingConfigurationArn,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (authorized.hashCode())
        result = 31 * result + (insecureIngest.hashCode())
        result = 31 * result + (latencyMode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (preset?.hashCode() ?: 0)
        result = 31 * result + (recordingConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateChannelRequest

        if (arn != other.arn) return false
        if (authorized != other.authorized) return false
        if (insecureIngest != other.insecureIngest) return false
        if (latencyMode != other.latencyMode) return false
        if (name != other.name) return false
        if (preset != other.preset) return false
        if (recordingConfigurationArn != other.recordingConfigurationArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.UpdateChannelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ARN of the channel to be updated.
         */
        public var arn: kotlin.String? = null
        /**
         * Whether the channel is private (enabled for playback authorization).
         */
        public var authorized: kotlin.Boolean = false
        /**
         * Whether the channel allows insecure RTMP ingest. Default: `false`.
         */
        public var insecureIngest: kotlin.Boolean = false
        /**
         * Channel latency mode. Use `NORMAL` to broadcast and deliver live video up to Full HD. Use `LOW` for near-real-time interaction with viewers. (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to Ultra-low and Standard, respectively.)
         */
        public var latencyMode: aws.sdk.kotlin.services.ivs.model.ChannelLatencyMode? = null
        /**
         * Channel name.
         */
        public var name: kotlin.String? = null
        /**
         * Optional transcode preset for the channel. This is selectable only for `ADVANCED_HD` and `ADVANCED_SD` channel types. For those channel types, the default `preset` is `HIGHER_BANDWIDTH_DELIVERY`. For other channel types (`BASIC` and `STANDARD`), `preset` is the empty string (`""`).
         */
        public var preset: aws.sdk.kotlin.services.ivs.model.TranscodePreset? = null
        /**
         * Recording-configuration ARN. If this is set to an empty string, recording is disabled. A value other than an empty string indicates that recording is enabled
         */
        public var recordingConfigurationArn: kotlin.String? = null
        /**
         * Channel type, which determines the allowable resolution and bitrate. *If you exceed the allowable input resolution or bitrate, the stream probably will disconnect immediately.* Default: `STANDARD`. For details, see [Channel Types](https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html).
         */
        public var type: aws.sdk.kotlin.services.ivs.model.ChannelType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.UpdateChannelRequest) : this() {
            this.arn = x.arn
            this.authorized = x.authorized
            this.insecureIngest = x.insecureIngest
            this.latencyMode = x.latencyMode
            this.name = x.name
            this.preset = x.preset
            this.recordingConfigurationArn = x.recordingConfigurationArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.UpdateChannelRequest = UpdateChannelRequest(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            return this
        }
    }
}
