// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



/**
 * An object representing a configuration of thumbnails for recorded video.
 */
public class ThumbnailConfiguration private constructor(builder: Builder) {
    /**
     * Thumbnail recording mode. Default: `INTERVAL`.
     */
    public val recordingMode: aws.sdk.kotlin.services.ivs.model.RecordingMode? = builder.recordingMode
    /**
     * Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected resolution if the corresponding rendition is available during the stream; otherwise, they are recorded at source resolution. For more information about resolution values and their corresponding height and width dimensions, see [Auto-Record to Amazon S3](https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html). Default: Null (source resolution is returned).
     */
    public val resolution: aws.sdk.kotlin.services.ivs.model.ThumbnailConfigurationResolution? = builder.resolution
    /**
     * Indicates the format in which thumbnails are recorded. `SEQUENTIAL` records all generated thumbnails in a serial manner, to the media/thumbnails directory. `LATEST` saves the latest thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by `targetIntervalSeconds`. You can enable both `SEQUENTIAL` and `LATEST`. Default: `SEQUENTIAL`.
     */
    public val storage: List<ThumbnailConfigurationStorage>? = builder.storage
    /**
     * The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if `recordingMode` is `INTERVAL`. Default: 60.
     *
     * **Important:** For the `BASIC` channel type, setting a value for `targetIntervalSeconds` does not guarantee that thumbnails are generated at the specified interval. For thumbnails to be generated at the `targetIntervalSeconds` interval, the `IDR/Keyframe` value for the input video must be less than the `targetIntervalSeconds` value. See [ Amazon IVS Streaming Configuration](https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html) for information on setting `IDR/Keyframe` to the recommended value in video-encoder settings.
     */
    public val targetIntervalSeconds: kotlin.Long? = builder.targetIntervalSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThumbnailConfiguration(")
        append("recordingMode=$recordingMode,")
        append("resolution=$resolution,")
        append("storage=$storage,")
        append("targetIntervalSeconds=$targetIntervalSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = recordingMode?.hashCode() ?: 0
        result = 31 * result + (resolution?.hashCode() ?: 0)
        result = 31 * result + (storage?.hashCode() ?: 0)
        result = 31 * result + (targetIntervalSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThumbnailConfiguration

        if (recordingMode != other.recordingMode) return false
        if (resolution != other.resolution) return false
        if (storage != other.storage) return false
        if (targetIntervalSeconds != other.targetIntervalSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Thumbnail recording mode. Default: `INTERVAL`.
         */
        public var recordingMode: aws.sdk.kotlin.services.ivs.model.RecordingMode? = null
        /**
         * Indicates the desired resolution of recorded thumbnails. Thumbnails are recorded at the selected resolution if the corresponding rendition is available during the stream; otherwise, they are recorded at source resolution. For more information about resolution values and their corresponding height and width dimensions, see [Auto-Record to Amazon S3](https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html). Default: Null (source resolution is returned).
         */
        public var resolution: aws.sdk.kotlin.services.ivs.model.ThumbnailConfigurationResolution? = null
        /**
         * Indicates the format in which thumbnails are recorded. `SEQUENTIAL` records all generated thumbnails in a serial manner, to the media/thumbnails directory. `LATEST` saves the latest thumbnail in media/latest_thumbnail/thumb.jpg and overwrites it at the interval specified by `targetIntervalSeconds`. You can enable both `SEQUENTIAL` and `LATEST`. Default: `SEQUENTIAL`.
         */
        public var storage: List<ThumbnailConfigurationStorage>? = null
        /**
         * The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if `recordingMode` is `INTERVAL`. Default: 60.
         *
         * **Important:** For the `BASIC` channel type, setting a value for `targetIntervalSeconds` does not guarantee that thumbnails are generated at the specified interval. For thumbnails to be generated at the `targetIntervalSeconds` interval, the `IDR/Keyframe` value for the input video must be less than the `targetIntervalSeconds` value. See [ Amazon IVS Streaming Configuration](https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html) for information on setting `IDR/Keyframe` to the recommended value in video-encoder settings.
         */
        public var targetIntervalSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration) : this() {
            this.recordingMode = x.recordingMode
            this.resolution = x.resolution
            this.storage = x.storage
            this.targetIntervalSeconds = x.targetIntervalSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration = ThumbnailConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
