// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



/**
 * Object specifying a stream’s video configuration, as set up by the broadcaster (usually in an encoder). This is part of the IngestConfiguration object and used for monitoring stream health.
 */
public class VideoConfiguration private constructor(builder: Builder) {
    /**
     * Indicates the degree of required decoder performance for a profile. Normally this is set automatically by the encoder. For details, see the H.264 specification.
     */
    public val avcLevel: kotlin.String? = builder.avcLevel
    /**
     * Indicates to the decoder the requirements for decoding the stream. For definitions of the valid values, see the H.264 specification.
     */
    public val avcProfile: kotlin.String? = builder.avcProfile
    /**
     * Codec used for the video encoding.
     */
    public val codec: kotlin.String? = builder.codec
    /**
     * Software or hardware used to encode the video.
     */
    public val encoder: kotlin.String? = builder.encoder
    /**
     * The expected ingest bitrate (bits per second). This is configured in the encoder.
     */
    public val targetBitrate: kotlin.Long = builder.targetBitrate
    /**
     * The expected ingest framerate. This is configured in the encoder.
     */
    public val targetFramerate: kotlin.Long = builder.targetFramerate
    /**
     * Video-resolution height in pixels.
     */
    public val videoHeight: kotlin.Long = builder.videoHeight
    /**
     * Video-resolution width in pixels.
     */
    public val videoWidth: kotlin.Long = builder.videoWidth

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.VideoConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VideoConfiguration(")
        append("avcLevel=$avcLevel,")
        append("avcProfile=$avcProfile,")
        append("codec=$codec,")
        append("encoder=$encoder,")
        append("targetBitrate=$targetBitrate,")
        append("targetFramerate=$targetFramerate,")
        append("videoHeight=$videoHeight,")
        append("videoWidth=$videoWidth")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = avcLevel?.hashCode() ?: 0
        result = 31 * result + (avcProfile?.hashCode() ?: 0)
        result = 31 * result + (codec?.hashCode() ?: 0)
        result = 31 * result + (encoder?.hashCode() ?: 0)
        result = 31 * result + (targetBitrate.hashCode())
        result = 31 * result + (targetFramerate.hashCode())
        result = 31 * result + (videoHeight.hashCode())
        result = 31 * result + (videoWidth.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VideoConfiguration

        if (avcLevel != other.avcLevel) return false
        if (avcProfile != other.avcProfile) return false
        if (codec != other.codec) return false
        if (encoder != other.encoder) return false
        if (targetBitrate != other.targetBitrate) return false
        if (targetFramerate != other.targetFramerate) return false
        if (videoHeight != other.videoHeight) return false
        if (videoWidth != other.videoWidth) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.VideoConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the degree of required decoder performance for a profile. Normally this is set automatically by the encoder. For details, see the H.264 specification.
         */
        public var avcLevel: kotlin.String? = null
        /**
         * Indicates to the decoder the requirements for decoding the stream. For definitions of the valid values, see the H.264 specification.
         */
        public var avcProfile: kotlin.String? = null
        /**
         * Codec used for the video encoding.
         */
        public var codec: kotlin.String? = null
        /**
         * Software or hardware used to encode the video.
         */
        public var encoder: kotlin.String? = null
        /**
         * The expected ingest bitrate (bits per second). This is configured in the encoder.
         */
        public var targetBitrate: kotlin.Long = 0L
        /**
         * The expected ingest framerate. This is configured in the encoder.
         */
        public var targetFramerate: kotlin.Long = 0L
        /**
         * Video-resolution height in pixels.
         */
        public var videoHeight: kotlin.Long = 0L
        /**
         * Video-resolution width in pixels.
         */
        public var videoWidth: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.VideoConfiguration) : this() {
            this.avcLevel = x.avcLevel
            this.avcProfile = x.avcProfile
            this.codec = x.codec
            this.encoder = x.encoder
            this.targetBitrate = x.targetBitrate
            this.targetFramerate = x.targetFramerate
            this.videoHeight = x.videoHeight
            this.videoWidth = x.videoWidth
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.VideoConfiguration = VideoConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
