// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



/**
 * Object that describes which renditions should be recorded for a stream.
 */
public class RenditionConfiguration private constructor(builder: Builder) {
    /**
     * Indicates which set of renditions are recorded for a stream. For `BASIC` channels, the `CUSTOM` value has no effect. If `CUSTOM` is specified, a set of renditions must be specified in the `renditions` field. Default: `ALL`.
     */
    public val renditionSelection: aws.sdk.kotlin.services.ivs.model.RenditionConfigurationRenditionSelection? = builder.renditionSelection
    /**
     * Indicates which renditions are recorded for a stream, if `renditionSelection` is `CUSTOM`; otherwise, this field is irrelevant. The selected renditions are recorded if they are available during the stream. If a selected rendition is unavailable, the best available rendition is recorded. For details on the resolution dimensions of each rendition, see [Auto-Record to Amazon S3](https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html).
     */
    public val renditions: List<RenditionConfigurationRendition>? = builder.renditions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.RenditionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RenditionConfiguration(")
        append("renditionSelection=$renditionSelection,")
        append("renditions=$renditions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = renditionSelection?.hashCode() ?: 0
        result = 31 * result + (renditions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RenditionConfiguration

        if (renditionSelection != other.renditionSelection) return false
        if (renditions != other.renditions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.RenditionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates which set of renditions are recorded for a stream. For `BASIC` channels, the `CUSTOM` value has no effect. If `CUSTOM` is specified, a set of renditions must be specified in the `renditions` field. Default: `ALL`.
         */
        public var renditionSelection: aws.sdk.kotlin.services.ivs.model.RenditionConfigurationRenditionSelection? = null
        /**
         * Indicates which renditions are recorded for a stream, if `renditionSelection` is `CUSTOM`; otherwise, this field is irrelevant. The selected renditions are recorded if they are available during the stream. If a selected rendition is unavailable, the best available rendition is recorded. For details on the resolution dimensions of each rendition, see [Auto-Record to Amazon S3](https://docs.aws.amazon.com/ivs/latest/userguide/record-to-s3.html).
         */
        public var renditions: List<RenditionConfigurationRendition>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.RenditionConfiguration) : this() {
            this.renditionSelection = x.renditionSelection
            this.renditions = x.renditions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.RenditionConfiguration = RenditionConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
