// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



/**
 * An object representing a configuration to record a channel stream.
 */
public class RecordingConfiguration private constructor(builder: Builder) {
    /**
     * Recording-configuration ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * A complex type that contains information about where recorded video will be stored.
     */
    public val destinationConfiguration: aws.sdk.kotlin.services.ivs.model.DestinationConfiguration? = builder.destinationConfiguration
    /**
     * Recording-configuration name. The value does not need to be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together. Default: 0.
     */
    public val recordingReconnectWindowSeconds: kotlin.Int = builder.recordingReconnectWindowSeconds
    /**
     * Object that describes which renditions should be recorded for a stream.
     */
    public val renditionConfiguration: aws.sdk.kotlin.services.ivs.model.RenditionConfiguration? = builder.renditionConfiguration
    /**
     * Indicates the current state of the recording configuration. When the state is `ACTIVE`, the configuration is ready for recording a channel stream.
     */
    public val state: aws.sdk.kotlin.services.ivs.model.RecordingConfigurationState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * Tags attached to the resource. Array of 1-50 maps, each of the form `string:string (key:value)`. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.
     */
    public val thumbnailConfiguration: aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration? = builder.thumbnailConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.RecordingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecordingConfiguration(")
        append("arn=$arn,")
        append("destinationConfiguration=$destinationConfiguration,")
        append("name=$name,")
        append("recordingReconnectWindowSeconds=$recordingReconnectWindowSeconds,")
        append("renditionConfiguration=$renditionConfiguration,")
        append("state=$state,")
        append("tags=$tags,")
        append("thumbnailConfiguration=$thumbnailConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (destinationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recordingReconnectWindowSeconds)
        result = 31 * result + (renditionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (thumbnailConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecordingConfiguration

        if (arn != other.arn) return false
        if (destinationConfiguration != other.destinationConfiguration) return false
        if (name != other.name) return false
        if (recordingReconnectWindowSeconds != other.recordingReconnectWindowSeconds) return false
        if (renditionConfiguration != other.renditionConfiguration) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (thumbnailConfiguration != other.thumbnailConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.RecordingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Recording-configuration ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * A complex type that contains information about where recorded video will be stored.
         */
        public var destinationConfiguration: aws.sdk.kotlin.services.ivs.model.DestinationConfiguration? = null
        /**
         * Recording-configuration name. The value does not need to be unique.
         */
        public var name: kotlin.String? = null
        /**
         * If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together. Default: 0.
         */
        public var recordingReconnectWindowSeconds: kotlin.Int = 0
        /**
         * Object that describes which renditions should be recorded for a stream.
         */
        public var renditionConfiguration: aws.sdk.kotlin.services.ivs.model.RenditionConfiguration? = null
        /**
         * Indicates the current state of the recording configuration. When the state is `ACTIVE`, the configuration is ready for recording a channel stream.
         */
        public var state: aws.sdk.kotlin.services.ivs.model.RecordingConfigurationState? = null
        /**
         * Tags attached to the resource. Array of 1-50 maps, each of the form `string:string (key:value)`. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
         */
        public var tags: Map<String, String>? = null
        /**
         * A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the interval at which thumbnails are generated for the live session.
         */
        public var thumbnailConfiguration: aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.RecordingConfiguration) : this() {
            this.arn = x.arn
            this.destinationConfiguration = x.destinationConfiguration
            this.name = x.name
            this.recordingReconnectWindowSeconds = x.recordingReconnectWindowSeconds
            this.renditionConfiguration = x.renditionConfiguration
            this.state = x.state
            this.tags = x.tags
            this.thumbnailConfiguration = x.thumbnailConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.RecordingConfiguration = RecordingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.DestinationConfiguration] inside the given [block]
         */
        public fun destinationConfiguration(block: aws.sdk.kotlin.services.ivs.model.DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.destinationConfiguration = aws.sdk.kotlin.services.ivs.model.DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.RenditionConfiguration] inside the given [block]
         */
        public fun renditionConfiguration(block: aws.sdk.kotlin.services.ivs.model.RenditionConfiguration.Builder.() -> kotlin.Unit) {
            this.renditionConfiguration = aws.sdk.kotlin.services.ivs.model.RenditionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration] inside the given [block]
         */
        public fun thumbnailConfiguration(block: aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration.Builder.() -> kotlin.Unit) {
            this.thumbnailConfiguration = aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (state == null) state = RecordingConfigurationState.SdkUnknown("no value provided")
            return this
        }
    }
}
