// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



/**
 * Object specifying a channel.
 */
public class Channel private constructor(builder: Builder) {
    /**
     * Channel ARN.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Whether the channel is private (enabled for playback authorization). Default: `false`.
     */
    public val authorized: kotlin.Boolean = builder.authorized
    /**
     * Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
     */
    public val ingestEndpoint: kotlin.String? = builder.ingestEndpoint
    /**
     * Whether the channel allows insecure RTMP ingest. Default: `false`.
     */
    public val insecureIngest: kotlin.Boolean = builder.insecureIngest
    /**
     * Channel latency mode. Use `NORMAL` to broadcast and deliver live video up to Full HD. Use `LOW` for near-real-time interaction with viewers. Default: `LOW`. (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to Ultra-low and Standard, respectively.)
     */
    public val latencyMode: aws.sdk.kotlin.services.ivs.model.ChannelLatencyMode? = builder.latencyMode
    /**
     * Channel name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Channel playback URL.
     */
    public val playbackUrl: kotlin.String? = builder.playbackUrl
    /**
     * Optional transcode preset for the channel. This is selectable only for `ADVANCED_HD` and `ADVANCED_SD` channel types. For those channel types, the default `preset` is `HIGHER_BANDWIDTH_DELIVERY`. For other channel types (`BASIC` and `STANDARD`), `preset` is the empty string (`""`).
     */
    public val preset: aws.sdk.kotlin.services.ivs.model.TranscodePreset? = builder.preset
    /**
     * Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (empty string, recording is disabled).
     */
    public val recordingConfigurationArn: kotlin.String? = builder.recordingConfigurationArn
    /**
     * Tags attached to the resource. Array of 1-50 maps, each of the form `string:string (key:value)`. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Channel type, which determines the allowable resolution and bitrate. *If you exceed the allowable input resolution or bitrate, the stream probably will disconnect immediately.* Default: `STANDARD`. For details, see [Channel Types](https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html).
     */
    public val type: aws.sdk.kotlin.services.ivs.model.ChannelType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.Channel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Channel(")
        append("arn=$arn,")
        append("authorized=$authorized,")
        append("ingestEndpoint=$ingestEndpoint,")
        append("insecureIngest=$insecureIngest,")
        append("latencyMode=$latencyMode,")
        append("name=$name,")
        append("playbackUrl=$playbackUrl,")
        append("preset=$preset,")
        append("recordingConfigurationArn=$recordingConfigurationArn,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (authorized.hashCode())
        result = 31 * result + (ingestEndpoint?.hashCode() ?: 0)
        result = 31 * result + (insecureIngest.hashCode())
        result = 31 * result + (latencyMode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (playbackUrl?.hashCode() ?: 0)
        result = 31 * result + (preset?.hashCode() ?: 0)
        result = 31 * result + (recordingConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Channel

        if (arn != other.arn) return false
        if (authorized != other.authorized) return false
        if (ingestEndpoint != other.ingestEndpoint) return false
        if (insecureIngest != other.insecureIngest) return false
        if (latencyMode != other.latencyMode) return false
        if (name != other.name) return false
        if (playbackUrl != other.playbackUrl) return false
        if (preset != other.preset) return false
        if (recordingConfigurationArn != other.recordingConfigurationArn) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.Channel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Channel ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Whether the channel is private (enabled for playback authorization). Default: `false`.
         */
        public var authorized: kotlin.Boolean = false
        /**
         * Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
         */
        public var ingestEndpoint: kotlin.String? = null
        /**
         * Whether the channel allows insecure RTMP ingest. Default: `false`.
         */
        public var insecureIngest: kotlin.Boolean = false
        /**
         * Channel latency mode. Use `NORMAL` to broadcast and deliver live video up to Full HD. Use `LOW` for near-real-time interaction with viewers. Default: `LOW`. (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to Ultra-low and Standard, respectively.)
         */
        public var latencyMode: aws.sdk.kotlin.services.ivs.model.ChannelLatencyMode? = null
        /**
         * Channel name.
         */
        public var name: kotlin.String? = null
        /**
         * Channel playback URL.
         */
        public var playbackUrl: kotlin.String? = null
        /**
         * Optional transcode preset for the channel. This is selectable only for `ADVANCED_HD` and `ADVANCED_SD` channel types. For those channel types, the default `preset` is `HIGHER_BANDWIDTH_DELIVERY`. For other channel types (`BASIC` and `STANDARD`), `preset` is the empty string (`""`).
         */
        public var preset: aws.sdk.kotlin.services.ivs.model.TranscodePreset? = null
        /**
         * Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (empty string, recording is disabled).
         */
        public var recordingConfigurationArn: kotlin.String? = null
        /**
         * Tags attached to the resource. Array of 1-50 maps, each of the form `string:string (key:value)`. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
         */
        public var tags: Map<String, String>? = null
        /**
         * Channel type, which determines the allowable resolution and bitrate. *If you exceed the allowable input resolution or bitrate, the stream probably will disconnect immediately.* Default: `STANDARD`. For details, see [Channel Types](https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html).
         */
        public var type: aws.sdk.kotlin.services.ivs.model.ChannelType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.Channel) : this() {
            this.arn = x.arn
            this.authorized = x.authorized
            this.ingestEndpoint = x.ingestEndpoint
            this.insecureIngest = x.insecureIngest
            this.latencyMode = x.latencyMode
            this.name = x.name
            this.playbackUrl = x.playbackUrl
            this.preset = x.preset
            this.recordingConfigurationArn = x.recordingConfigurationArn
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.Channel = Channel(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
