// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



/**
 * An object representing a configuration of thumbnails for recorded video.
 */
public class ThumbnailConfiguration private constructor(builder: Builder) {
    /**
     * Thumbnail recording mode. Default: `INTERVAL`.
     */
    public val recordingMode: aws.sdk.kotlin.services.ivs.model.RecordingMode? = builder.recordingMode
    /**
     * The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if `recordingMode` is `INTERVAL`. Default: 60.
     *
     * **Important:** Setting a value for `targetIntervalSeconds` does not guarantee that thumbnails are generated at the specified interval. For thumbnails to be generated at the `targetIntervalSeconds` interval, the `IDR/Keyframe` value for the input video must be less than the `targetIntervalSeconds` value. See [ Amazon IVS Streaming Configuration](https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html) for information on setting `IDR/Keyframe` to the recommended value in video-encoder settings.
     */
    public val targetIntervalSeconds: kotlin.Long = builder.targetIntervalSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThumbnailConfiguration(")
        append("recordingMode=$recordingMode,")
        append("targetIntervalSeconds=$targetIntervalSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = recordingMode?.hashCode() ?: 0
        result = 31 * result + (targetIntervalSeconds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThumbnailConfiguration

        if (recordingMode != other.recordingMode) return false
        if (targetIntervalSeconds != other.targetIntervalSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Thumbnail recording mode. Default: `INTERVAL`.
         */
        public var recordingMode: aws.sdk.kotlin.services.ivs.model.RecordingMode? = null
        /**
         * The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if `recordingMode` is `INTERVAL`. Default: 60.
         *
         * **Important:** Setting a value for `targetIntervalSeconds` does not guarantee that thumbnails are generated at the specified interval. For thumbnails to be generated at the `targetIntervalSeconds` interval, the `IDR/Keyframe` value for the input video must be less than the `targetIntervalSeconds` value. See [ Amazon IVS Streaming Configuration](https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html) for information on setting `IDR/Keyframe` to the recommended value in video-encoder settings.
         */
        public var targetIntervalSeconds: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration) : this() {
            this.recordingMode = x.recordingMode
            this.targetIntervalSeconds = x.targetIntervalSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.ThumbnailConfiguration = ThumbnailConfiguration(this)
    }
}
