// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



public class CreateChannelRequest private constructor(builder: Builder) {
    /**
     * Whether the channel is private (enabled for playback authorization). Default: `false`.
     */
    public val authorized: kotlin.Boolean = builder.authorized
    /**
     * Channel latency mode. Use `NORMAL` to broadcast and deliver live video up to Full HD. Use `LOW` for near-real-time interaction with viewers. (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to Ultra-low and Standard, respectively.) Default: `LOW`.
     */
    public val latencyMode: aws.sdk.kotlin.services.ivs.model.ChannelLatencyMode? = builder.latencyMode
    /**
     * Channel name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Recording-configuration ARN. Default: "" (empty string, recording is disabled).
     */
    public val recordingConfigurationArn: kotlin.String? = builder.recordingConfigurationArn
    /**
     * Array of 1-50 maps, each of the form `string:string (key:value)`. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Channel type, which determines the allowable resolution and bitrate. *If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.* Default: `STANDARD`. Valid values:
     * + `STANDARD`: Video is transcoded: multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Transcoding allows higher playback quality across a range of download speeds. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through. This is the default.
     * + `BASIC`: Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be up to 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
     */
    public val type: aws.sdk.kotlin.services.ivs.model.ChannelType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.CreateChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelRequest(")
        append("authorized=$authorized,")
        append("latencyMode=$latencyMode,")
        append("name=$name,")
        append("recordingConfigurationArn=$recordingConfigurationArn,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorized.hashCode()
        result = 31 * result + (latencyMode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recordingConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateChannelRequest

        if (authorized != other.authorized) return false
        if (latencyMode != other.latencyMode) return false
        if (name != other.name) return false
        if (recordingConfigurationArn != other.recordingConfigurationArn) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.CreateChannelRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether the channel is private (enabled for playback authorization). Default: `false`.
         */
        public var authorized: kotlin.Boolean = false
        /**
         * Channel latency mode. Use `NORMAL` to broadcast and deliver live video up to Full HD. Use `LOW` for near-real-time interaction with viewers. (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to Ultra-low and Standard, respectively.) Default: `LOW`.
         */
        public var latencyMode: aws.sdk.kotlin.services.ivs.model.ChannelLatencyMode? = null
        /**
         * Channel name.
         */
        public var name: kotlin.String? = null
        /**
         * Recording-configuration ARN. Default: "" (empty string, recording is disabled).
         */
        public var recordingConfigurationArn: kotlin.String? = null
        /**
         * Array of 1-50 maps, each of the form `string:string (key:value)`. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
         */
        public var tags: Map<String, String>? = null
        /**
         * Channel type, which determines the allowable resolution and bitrate. *If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.* Default: `STANDARD`. Valid values:
         * + `STANDARD`: Video is transcoded: multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Transcoding allows higher playback quality across a range of download speeds. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through. This is the default.
         * + `BASIC`: Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be up to 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
         */
        public var type: aws.sdk.kotlin.services.ivs.model.ChannelType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.CreateChannelRequest) : this() {
            this.authorized = x.authorized
            this.latencyMode = x.latencyMode
            this.name = x.name
            this.recordingConfigurationArn = x.recordingConfigurationArn
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.CreateChannelRequest = CreateChannelRequest(this)
    }
}
