// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model



/**
 * Summary information about a channel.
 */
public class ChannelSummary private constructor(builder: Builder) {
    /**
     * Channel ARN.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Whether the channel is private (enabled for playback authorization). Default: `false`.
     */
    public val authorized: kotlin.Boolean = builder.authorized
    /**
     * Channel latency mode. Use `NORMAL` to broadcast and deliver live video up to Full HD. Use `LOW` for near-real-time interaction with viewers. Default: `LOW`. (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to Ultra-low and Standard, respectively.)
     */
    public val latencyMode: aws.sdk.kotlin.services.ivs.model.ChannelLatencyMode? = builder.latencyMode
    /**
     * Channel name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (empty string, recording is disabled).
     */
    public val recordingConfigurationArn: kotlin.String? = builder.recordingConfigurationArn
    /**
     * Array of 1-50 maps, each of the form `string:string (key:value)`. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.ChannelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelSummary(")
        append("arn=$arn,")
        append("authorized=$authorized,")
        append("latencyMode=$latencyMode,")
        append("name=$name,")
        append("recordingConfigurationArn=$recordingConfigurationArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (authorized.hashCode())
        result = 31 * result + (latencyMode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recordingConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChannelSummary

        if (arn != other.arn) return false
        if (authorized != other.authorized) return false
        if (latencyMode != other.latencyMode) return false
        if (name != other.name) return false
        if (recordingConfigurationArn != other.recordingConfigurationArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.ChannelSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Channel ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Whether the channel is private (enabled for playback authorization). Default: `false`.
         */
        public var authorized: kotlin.Boolean = false
        /**
         * Channel latency mode. Use `NORMAL` to broadcast and deliver live video up to Full HD. Use `LOW` for near-real-time interaction with viewers. Default: `LOW`. (Note: In the Amazon IVS console, `LOW` and `NORMAL` correspond to Ultra-low and Standard, respectively.)
         */
        public var latencyMode: aws.sdk.kotlin.services.ivs.model.ChannelLatencyMode? = null
        /**
         * Channel name.
         */
        public var name: kotlin.String? = null
        /**
         * Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default: "" (empty string, recording is disabled).
         */
        public var recordingConfigurationArn: kotlin.String? = null
        /**
         * Array of 1-50 maps, each of the form `string:string (key:value)`. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.ChannelSummary) : this() {
            this.arn = x.arn
            this.authorized = x.authorized
            this.latencyMode = x.latencyMode
            this.name = x.name
            this.recordingConfigurationArn = x.recordingConfigurationArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.ChannelSummary = ChannelSummary(this)
    }
}
