// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.WirelessGatewayTaskStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetWirelessGatewayTaskOperationDeserializer: HttpDeserialize<GetWirelessGatewayTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWirelessGatewayTaskResponse {
        if (!response.status.isSuccess()) {
            throwGetWirelessGatewayTaskError(context, response)
        }
        val builder = GetWirelessGatewayTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWirelessGatewayTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetWirelessGatewayTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWirelessGatewayTaskOperationBody(builder: GetWirelessGatewayTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTUPLINKRECEIVEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastUplinkReceivedAt"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TASKCREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskCreatedAt"))
    val WIRELESSGATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WirelessGatewayId"))
    val WIRELESSGATEWAYTASKDEFINITIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WirelessGatewayTaskDefinitionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTUPLINKRECEIVEDAT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TASKCREATEDAT_DESCRIPTOR)
        field(WIRELESSGATEWAYID_DESCRIPTOR)
        field(WIRELESSGATEWAYTASKDEFINITIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTUPLINKRECEIVEDAT_DESCRIPTOR.index -> builder.lastUplinkReceivedAt = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { WirelessGatewayTaskStatus.fromValue(it) }
                TASKCREATEDAT_DESCRIPTOR.index -> builder.taskCreatedAt = deserializeString()
                WIRELESSGATEWAYID_DESCRIPTOR.index -> builder.wirelessGatewayId = deserializeString()
                WIRELESSGATEWAYTASKDEFINITIONID_DESCRIPTOR.index -> builder.wirelessGatewayTaskDefinitionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
