// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotwireless.model.GetWirelessDeviceStatisticsResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.LoRaWanDeviceMetadata
import aws.sdk.kotlin.services.iotwireless.model.SidewalkDeviceMetadata
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetWirelessDeviceStatisticsOperationDeserializer: HttpDeserialize<GetWirelessDeviceStatisticsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWirelessDeviceStatisticsResponse {
        if (!response.status.isSuccess()) {
            throwGetWirelessDeviceStatisticsError(context, response)
        }
        val builder = GetWirelessDeviceStatisticsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWirelessDeviceStatisticsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetWirelessDeviceStatisticsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWirelessDeviceStatisticsOperationBody(builder: GetWirelessDeviceStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTUPLINKRECEIVEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastUplinkReceivedAt"))
    val LORAWAN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoRaWAN"))
    val SIDEWALK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Sidewalk"))
    val WIRELESSDEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WirelessDeviceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTUPLINKRECEIVEDAT_DESCRIPTOR)
        field(LORAWAN_DESCRIPTOR)
        field(SIDEWALK_DESCRIPTOR)
        field(WIRELESSDEVICEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTUPLINKRECEIVEDAT_DESCRIPTOR.index -> builder.lastUplinkReceivedAt = deserializeString()
                LORAWAN_DESCRIPTOR.index -> builder.loRaWan = deserializeLoRaWanDeviceMetadataDocument(deserializer)
                SIDEWALK_DESCRIPTOR.index -> builder.sidewalk = deserializeSidewalkDeviceMetadataDocument(deserializer)
                WIRELESSDEVICEID_DESCRIPTOR.index -> builder.wirelessDeviceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
