// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotwireless.model.ConnectionStatusEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.DeviceRegistrationStateEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.GetResourceEventConfigurationResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.JoinEventConfiguration
import aws.sdk.kotlin.services.iotwireless.model.ProximityEventConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetResourceEventConfigurationOperationDeserializer: HttpDeserialize<GetResourceEventConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetResourceEventConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwGetResourceEventConfigurationError(context, response)
        }
        val builder = GetResourceEventConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetResourceEventConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetResourceEventConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResourceEventConfigurationOperationBody(builder: GetResourceEventConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionStatus"))
    val DEVICEREGISTRATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceRegistrationState"))
    val JOIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Join"))
    val PROXIMITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Proximity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(DEVICEREGISTRATIONSTATE_DESCRIPTOR)
        field(JOIN_DESCRIPTOR)
        field(PROXIMITY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONSTATUS_DESCRIPTOR.index -> builder.connectionStatus = deserializeConnectionStatusEventConfigurationDocument(deserializer)
                DEVICEREGISTRATIONSTATE_DESCRIPTOR.index -> builder.deviceRegistrationState = deserializeDeviceRegistrationStateEventConfigurationDocument(deserializer)
                JOIN_DESCRIPTOR.index -> builder.join = deserializeJoinEventConfigurationDocument(deserializer)
                PROXIMITY_DESCRIPTOR.index -> builder.proximity = deserializeProximityEventConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
