// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotwireless.model.Accuracy
import aws.sdk.kotlin.services.iotwireless.model.GetPositionResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.PositionSolverProvider
import aws.sdk.kotlin.services.iotwireless.model.PositionSolverType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPositionOperationDeserializer: HttpDeserialize<GetPositionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPositionResponse {
        if (!response.status.isSuccess()) {
            throwGetPositionError(context, response)
        }
        val builder = GetPositionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPositionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPositionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPositionOperationBody(builder: GetPositionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCURACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Accuracy"))
    val POSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Position"))
    val SOLVERPROVIDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SolverProvider"))
    val SOLVERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SolverType"))
    val SOLVERVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SolverVersion"))
    val TIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Timestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCURACY_DESCRIPTOR)
        field(POSITION_DESCRIPTOR)
        field(SOLVERPROVIDER_DESCRIPTOR)
        field(SOLVERTYPE_DESCRIPTOR)
        field(SOLVERVERSION_DESCRIPTOR)
        field(TIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCURACY_DESCRIPTOR.index -> builder.accuracy = deserializeAccuracyDocument(deserializer)
                POSITION_DESCRIPTOR.index -> builder.position =
                    deserializer.deserializeList(POSITION_DESCRIPTOR) {
                        val col0 = mutableListOf<Float>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFloat() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SOLVERPROVIDER_DESCRIPTOR.index -> builder.solverProvider = deserializeString().let { PositionSolverProvider.fromValue(it) }
                SOLVERTYPE_DESCRIPTOR.index -> builder.solverType = deserializeString().let { PositionSolverType.fromValue(it) }
                SOLVERVERSION_DESCRIPTOR.index -> builder.solverVersion = deserializeString()
                TIMESTAMP_DESCRIPTOR.index -> builder.timestamp = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
