// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.paginators

import aws.sdk.kotlin.services.iotwireless.IotWirelessClient
import aws.sdk.kotlin.services.iotwireless.model.ListDestinationsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListDestinationsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListDeviceProfilesRequest
import aws.sdk.kotlin.services.iotwireless.model.ListDeviceProfilesResponse
import aws.sdk.kotlin.services.iotwireless.model.ListFuotaTasksRequest
import aws.sdk.kotlin.services.iotwireless.model.ListFuotaTasksResponse
import aws.sdk.kotlin.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
import aws.sdk.kotlin.services.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.ListMulticastGroupsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListMulticastGroupsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListPositionConfigurationsRequest
import aws.sdk.kotlin.services.iotwireless.model.ListPositionConfigurationsResponse
import aws.sdk.kotlin.services.iotwireless.model.ListQueuedMessagesRequest
import aws.sdk.kotlin.services.iotwireless.model.ListQueuedMessagesResponse
import aws.sdk.kotlin.services.iotwireless.model.ListServiceProfilesRequest
import aws.sdk.kotlin.services.iotwireless.model.ListServiceProfilesResponse
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessDevicesRequest
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessDevicesResponse
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessGatewaysRequest
import aws.sdk.kotlin.services.iotwireless.model.ListWirelessGatewaysResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDestinationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDestinationsResponse]
 */
public fun IotWirelessClient.listDestinationsPaginated(initialRequest: ListDestinationsRequest): Flow<ListDestinationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDestinationsPaginated.listDestinations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDestinationsResponse]
 */
public fun IotWirelessClient.listDestinationsPaginated(block: ListDestinationsRequest.Builder.() -> Unit): Flow<ListDestinationsResponse> =
    listDestinationsPaginated(ListDestinationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDeviceProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeviceProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeviceProfilesResponse]
 */
public fun IotWirelessClient.listDeviceProfilesPaginated(initialRequest: ListDeviceProfilesRequest): Flow<ListDeviceProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeviceProfilesPaginated.listDeviceProfiles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDeviceProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeviceProfilesResponse]
 */
public fun IotWirelessClient.listDeviceProfilesPaginated(block: ListDeviceProfilesRequest.Builder.() -> Unit): Flow<ListDeviceProfilesResponse> =
    listDeviceProfilesPaginated(ListDeviceProfilesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFuotaTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFuotaTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFuotaTasksResponse]
 */
public fun IotWirelessClient.listFuotaTasksPaginated(initialRequest: ListFuotaTasksRequest): Flow<ListFuotaTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFuotaTasksPaginated.listFuotaTasks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFuotaTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFuotaTasksResponse]
 */
public fun IotWirelessClient.listFuotaTasksPaginated(block: ListFuotaTasksRequest.Builder.() -> Unit): Flow<ListFuotaTasksResponse> =
    listFuotaTasksPaginated(ListFuotaTasksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMulticastGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMulticastGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMulticastGroupsResponse]
 */
public fun IotWirelessClient.listMulticastGroupsPaginated(initialRequest: ListMulticastGroupsRequest): Flow<ListMulticastGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMulticastGroupsPaginated.listMulticastGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMulticastGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMulticastGroupsResponse]
 */
public fun IotWirelessClient.listMulticastGroupsPaginated(block: ListMulticastGroupsRequest.Builder.() -> Unit): Flow<ListMulticastGroupsResponse> =
    listMulticastGroupsPaginated(ListMulticastGroupsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMulticastGroupsByFuotaTaskResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMulticastGroupsByFuotaTaskRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMulticastGroupsByFuotaTaskResponse]
 */
public fun IotWirelessClient.listMulticastGroupsByFuotaTaskPaginated(initialRequest: ListMulticastGroupsByFuotaTaskRequest): Flow<ListMulticastGroupsByFuotaTaskResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMulticastGroupsByFuotaTaskPaginated.listMulticastGroupsByFuotaTask(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMulticastGroupsByFuotaTaskResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMulticastGroupsByFuotaTaskResponse]
 */
public fun IotWirelessClient.listMulticastGroupsByFuotaTaskPaginated(block: ListMulticastGroupsByFuotaTaskRequest.Builder.() -> Unit): Flow<ListMulticastGroupsByFuotaTaskResponse> =
    listMulticastGroupsByFuotaTaskPaginated(ListMulticastGroupsByFuotaTaskRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNetworkAnalyzerConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNetworkAnalyzerConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNetworkAnalyzerConfigurationsResponse]
 */
public fun IotWirelessClient.listNetworkAnalyzerConfigurationsPaginated(initialRequest: ListNetworkAnalyzerConfigurationsRequest): Flow<ListNetworkAnalyzerConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNetworkAnalyzerConfigurationsPaginated.listNetworkAnalyzerConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNetworkAnalyzerConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNetworkAnalyzerConfigurationsResponse]
 */
public fun IotWirelessClient.listNetworkAnalyzerConfigurationsPaginated(block: ListNetworkAnalyzerConfigurationsRequest.Builder.() -> Unit): Flow<ListNetworkAnalyzerConfigurationsResponse> =
    listNetworkAnalyzerConfigurationsPaginated(ListNetworkAnalyzerConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPositionConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPositionConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPositionConfigurationsResponse]
 */
public fun IotWirelessClient.listPositionConfigurationsPaginated(initialRequest: ListPositionConfigurationsRequest): Flow<ListPositionConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPositionConfigurationsPaginated.listPositionConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPositionConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPositionConfigurationsResponse]
 */
public fun IotWirelessClient.listPositionConfigurationsPaginated(block: ListPositionConfigurationsRequest.Builder.() -> Unit): Flow<ListPositionConfigurationsResponse> =
    listPositionConfigurationsPaginated(ListPositionConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListQueuedMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueuedMessagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueuedMessagesResponse]
 */
public fun IotWirelessClient.listQueuedMessagesPaginated(initialRequest: ListQueuedMessagesRequest): Flow<ListQueuedMessagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueuedMessagesPaginated.listQueuedMessages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQueuedMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueuedMessagesResponse]
 */
public fun IotWirelessClient.listQueuedMessagesPaginated(block: ListQueuedMessagesRequest.Builder.() -> Unit): Flow<ListQueuedMessagesResponse> =
    listQueuedMessagesPaginated(ListQueuedMessagesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListServiceProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceProfilesResponse]
 */
public fun IotWirelessClient.listServiceProfilesPaginated(initialRequest: ListServiceProfilesRequest): Flow<ListServiceProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServiceProfilesPaginated.listServiceProfiles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceProfilesResponse]
 */
public fun IotWirelessClient.listServiceProfilesPaginated(block: ListServiceProfilesRequest.Builder.() -> Unit): Flow<ListServiceProfilesResponse> =
    listServiceProfilesPaginated(ListServiceProfilesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWirelessDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWirelessDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWirelessDevicesResponse]
 */
public fun IotWirelessClient.listWirelessDevicesPaginated(initialRequest: ListWirelessDevicesRequest): Flow<ListWirelessDevicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWirelessDevicesPaginated.listWirelessDevices(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWirelessDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWirelessDevicesResponse]
 */
public fun IotWirelessClient.listWirelessDevicesPaginated(block: ListWirelessDevicesRequest.Builder.() -> Unit): Flow<ListWirelessDevicesResponse> =
    listWirelessDevicesPaginated(ListWirelessDevicesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWirelessGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWirelessGatewaysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWirelessGatewaysResponse]
 */
public fun IotWirelessClient.listWirelessGatewaysPaginated(initialRequest: ListWirelessGatewaysRequest): Flow<ListWirelessGatewaysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWirelessGatewaysPaginated.listWirelessGateways(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWirelessGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWirelessGatewaysResponse]
 */
public fun IotWirelessClient.listWirelessGatewaysPaginated(block: ListWirelessGatewaysRequest.Builder.() -> Unit): Flow<ListWirelessGatewaysResponse> =
    listWirelessGatewaysPaginated(ListWirelessGatewaysRequest.Builder().apply(block).build())
