// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.serde

import aws.sdk.kotlin.services.iotwireless.model.GetWirelessGatewayTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.WirelessGatewayTaskStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetWirelessGatewayTaskOperationDeserializer: HttpDeserializer.NonStreaming<GetWirelessGatewayTaskResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetWirelessGatewayTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetWirelessGatewayTaskError(context, call, payload)
        }
        val builder = GetWirelessGatewayTaskResponse.Builder()

        if (payload != null) {
            deserializeGetWirelessGatewayTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetWirelessGatewayTaskError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWirelessGatewayTaskOperationBody(builder: GetWirelessGatewayTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTUPLINKRECEIVEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastUplinkReceivedAt"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TASKCREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskCreatedAt"))
    val WIRELESSGATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WirelessGatewayId"))
    val WIRELESSGATEWAYTASKDEFINITIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WirelessGatewayTaskDefinitionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTUPLINKRECEIVEDAT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TASKCREATEDAT_DESCRIPTOR)
        field(WIRELESSGATEWAYID_DESCRIPTOR)
        field(WIRELESSGATEWAYTASKDEFINITIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTUPLINKRECEIVEDAT_DESCRIPTOR.index -> builder.lastUplinkReceivedAt = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { WirelessGatewayTaskStatus.fromValue(it) }
                TASKCREATEDAT_DESCRIPTOR.index -> builder.taskCreatedAt = deserializeString()
                WIRELESSGATEWAYID_DESCRIPTOR.index -> builder.wirelessGatewayId = deserializeString()
                WIRELESSGATEWAYTASKDEFINITIONID_DESCRIPTOR.index -> builder.wirelessGatewayTaskDefinitionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
