// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateWirelessDeviceRequest private constructor(builder: Builder) {
    /**
     * Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see [Ensuring idempotency in Amazon EC2 API requests](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The description of the new resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the destination to assign to the new wireless device.
     */
    public val destinationName: kotlin.String? = builder.destinationName
    /**
     * The device configuration information to use to create the wireless device.
     */
    public val loRaWan: aws.sdk.kotlin.services.iotwireless.model.LoRaWanDevice? = builder.loRaWan
    /**
     * The name of the new resource.
     *
     * The following special characters aren't accepted: `<>^#~$`
     */
    public val name: kotlin.String? = builder.name
    /**
     * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
     */
    public val positioning: aws.sdk.kotlin.services.iotwireless.model.PositioningConfigStatus? = builder.positioning
    /**
     * The device configuration information to use to create the Sidewalk device.
     */
    public val sidewalk: aws.sdk.kotlin.services.iotwireless.model.SidewalkCreateWirelessDevice? = builder.sidewalk
    /**
     * The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The wireless device type.
     */
    public val type: aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.CreateWirelessDeviceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWirelessDeviceRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("destinationName=$destinationName,")
        append("loRaWan=$loRaWan,")
        append("name=$name,")
        append("positioning=$positioning,")
        append("sidewalk=$sidewalk,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationName?.hashCode() ?: 0)
        result = 31 * result + (loRaWan?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (positioning?.hashCode() ?: 0)
        result = 31 * result + (sidewalk?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWirelessDeviceRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (destinationName != other.destinationName) return false
        if (loRaWan != other.loRaWan) return false
        if (name != other.name) return false
        if (positioning != other.positioning) return false
        if (sidewalk != other.sidewalk) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.CreateWirelessDeviceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see [Ensuring idempotency in Amazon EC2 API requests](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The description of the new resource.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the destination to assign to the new wireless device.
         */
        public var destinationName: kotlin.String? = null
        /**
         * The device configuration information to use to create the wireless device.
         */
        public var loRaWan: aws.sdk.kotlin.services.iotwireless.model.LoRaWanDevice? = null
        /**
         * The name of the new resource.
         *
         * The following special characters aren't accepted: `<>^#~$`
         */
        public var name: kotlin.String? = null
        /**
         * FPort values for the GNSS, stream, and ClockSync functions of the positioning information.
         */
        public var positioning: aws.sdk.kotlin.services.iotwireless.model.PositioningConfigStatus? = null
        /**
         * The device configuration information to use to create the Sidewalk device.
         */
        public var sidewalk: aws.sdk.kotlin.services.iotwireless.model.SidewalkCreateWirelessDevice? = null
        /**
         * The tags to attach to the new wireless device. Tags are metadata that you can use to manage a resource.
         */
        public var tags: List<Tag>? = null
        /**
         * The wireless device type.
         */
        public var type: aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.CreateWirelessDeviceRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.destinationName = x.destinationName
            this.loRaWan = x.loRaWan
            this.name = x.name
            this.positioning = x.positioning
            this.sidewalk = x.sidewalk
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.CreateWirelessDeviceRequest = CreateWirelessDeviceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.LoRaWanDevice] inside the given [block]
         */
        public fun loRaWan(block: aws.sdk.kotlin.services.iotwireless.model.LoRaWanDevice.Builder.() -> kotlin.Unit) {
            this.loRaWan = aws.sdk.kotlin.services.iotwireless.model.LoRaWanDevice.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.SidewalkCreateWirelessDevice] inside the given [block]
         */
        public fun sidewalk(block: aws.sdk.kotlin.services.iotwireless.model.SidewalkCreateWirelessDevice.Builder.() -> kotlin.Unit) {
            this.sidewalk = aws.sdk.kotlin.services.iotwireless.model.SidewalkCreateWirelessDevice.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
