// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFuotaTaskRequest private constructor(builder: Builder) {
    /**
     * Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see [Ensuring idempotency in Amazon EC2 API requests](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The description of the new resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The descriptor is the metadata about the file that is transferred to the device using FUOTA, such as the software version. It is a binary field encoded in base64.
     */
    public val descriptor: kotlin.String? = builder.descriptor
    /**
     * The S3 URI points to a firmware update image that is to be used with a FUOTA task.
     */
    public val firmwareUpdateImage: kotlin.String? = builder.firmwareUpdateImage
    /**
     * The firmware update role that is to be used with a FUOTA task.
     */
    public val firmwareUpdateRole: kotlin.String? = builder.firmwareUpdateRole
    /**
     * The interval for sending fragments in milliseconds, rounded to the nearest second.
     *
     * This interval only determines the timing for when the Cloud sends down the fragments to yor device. There can be a delay for when your device will receive these fragments. This delay depends on the device's class and the communication delay with the cloud.
     */
    public val fragmentIntervalMs: kotlin.Int? = builder.fragmentIntervalMs
    /**
     * The size of each fragment in bytes. This parameter is supported only for FUOTA tasks with multicast groups.
     */
    public val fragmentSizeBytes: kotlin.Int? = builder.fragmentSizeBytes
    /**
     * The LoRaWAN information used with a FUOTA task.
     */
    public val loRaWan: aws.sdk.kotlin.services.iotwireless.model.LoRaWanFuotaTask? = builder.loRaWan
    /**
     * The name of a FUOTA task.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The percentage of the added fragments that are redundant. For example, if the size of the firmware image file is 100 bytes and the fragment size is 10 bytes, with `RedundancyPercent` set to 50(%), the final number of encoded fragments is (100 / 10) + (100 / 10 * 50%) = 15.
     */
    public val redundancyPercent: kotlin.Int? = builder.redundancyPercent
    /**
     * The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.CreateFuotaTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFuotaTaskRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("descriptor=$descriptor,")
        append("firmwareUpdateImage=$firmwareUpdateImage,")
        append("firmwareUpdateRole=$firmwareUpdateRole,")
        append("fragmentIntervalMs=$fragmentIntervalMs,")
        append("fragmentSizeBytes=$fragmentSizeBytes,")
        append("loRaWan=$loRaWan,")
        append("name=$name,")
        append("redundancyPercent=$redundancyPercent,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (descriptor?.hashCode() ?: 0)
        result = 31 * result + (firmwareUpdateImage?.hashCode() ?: 0)
        result = 31 * result + (firmwareUpdateRole?.hashCode() ?: 0)
        result = 31 * result + (fragmentIntervalMs ?: 0)
        result = 31 * result + (fragmentSizeBytes ?: 0)
        result = 31 * result + (loRaWan?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (redundancyPercent ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFuotaTaskRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (descriptor != other.descriptor) return false
        if (firmwareUpdateImage != other.firmwareUpdateImage) return false
        if (firmwareUpdateRole != other.firmwareUpdateRole) return false
        if (fragmentIntervalMs != other.fragmentIntervalMs) return false
        if (fragmentSizeBytes != other.fragmentSizeBytes) return false
        if (loRaWan != other.loRaWan) return false
        if (name != other.name) return false
        if (redundancyPercent != other.redundancyPercent) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.CreateFuotaTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see [Ensuring idempotency in Amazon EC2 API requests](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The description of the new resource.
         */
        public var description: kotlin.String? = null
        /**
         * The descriptor is the metadata about the file that is transferred to the device using FUOTA, such as the software version. It is a binary field encoded in base64.
         */
        public var descriptor: kotlin.String? = null
        /**
         * The S3 URI points to a firmware update image that is to be used with a FUOTA task.
         */
        public var firmwareUpdateImage: kotlin.String? = null
        /**
         * The firmware update role that is to be used with a FUOTA task.
         */
        public var firmwareUpdateRole: kotlin.String? = null
        /**
         * The interval for sending fragments in milliseconds, rounded to the nearest second.
         *
         * This interval only determines the timing for when the Cloud sends down the fragments to yor device. There can be a delay for when your device will receive these fragments. This delay depends on the device's class and the communication delay with the cloud.
         */
        public var fragmentIntervalMs: kotlin.Int? = null
        /**
         * The size of each fragment in bytes. This parameter is supported only for FUOTA tasks with multicast groups.
         */
        public var fragmentSizeBytes: kotlin.Int? = null
        /**
         * The LoRaWAN information used with a FUOTA task.
         */
        public var loRaWan: aws.sdk.kotlin.services.iotwireless.model.LoRaWanFuotaTask? = null
        /**
         * The name of a FUOTA task.
         */
        public var name: kotlin.String? = null
        /**
         * The percentage of the added fragments that are redundant. For example, if the size of the firmware image file is 100 bytes and the fragment size is 10 bytes, with `RedundancyPercent` set to 50(%), the final number of encoded fragments is (100 / 10) + (100 / 10 * 50%) = 15.
         */
        public var redundancyPercent: kotlin.Int? = null
        /**
         * The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.CreateFuotaTaskRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.descriptor = x.descriptor
            this.firmwareUpdateImage = x.firmwareUpdateImage
            this.firmwareUpdateRole = x.firmwareUpdateRole
            this.fragmentIntervalMs = x.fragmentIntervalMs
            this.fragmentSizeBytes = x.fragmentSizeBytes
            this.loRaWan = x.loRaWan
            this.name = x.name
            this.redundancyPercent = x.redundancyPercent
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.CreateFuotaTaskRequest = CreateFuotaTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.LoRaWanFuotaTask] inside the given [block]
         */
        public fun loRaWan(block: aws.sdk.kotlin.services.iotwireless.model.LoRaWanFuotaTask.Builder.() -> kotlin.Unit) {
            this.loRaWan = aws.sdk.kotlin.services.iotwireless.model.LoRaWanFuotaTask.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
