// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CDMA object for network measurement reports.
 */
public class CdmaNmrObj private constructor(builder: Builder) {
    /**
     * CDMA base station ID (BSID).
     */
    public val baseStationId: kotlin.Int? = builder.baseStationId
    /**
     * CDMA channel information.
     */
    public val cdmaChannel: kotlin.Int = requireNotNull(builder.cdmaChannel) { "A non-null value must be provided for cdmaChannel" }
    /**
     * Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
     */
    public val pilotPower: kotlin.Int? = builder.pilotPower
    /**
     * Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
     */
    public val pnOffset: kotlin.Int = requireNotNull(builder.pnOffset) { "A non-null value must be provided for pnOffset" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.CdmaNmrObj = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CdmaNmrObj(")
        append("baseStationId=$baseStationId,")
        append("cdmaChannel=$cdmaChannel,")
        append("pilotPower=$pilotPower,")
        append("pnOffset=$pnOffset")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseStationId ?: 0
        result = 31 * result + (cdmaChannel)
        result = 31 * result + (pilotPower ?: 0)
        result = 31 * result + (pnOffset)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CdmaNmrObj

        if (baseStationId != other.baseStationId) return false
        if (cdmaChannel != other.cdmaChannel) return false
        if (pilotPower != other.pilotPower) return false
        if (pnOffset != other.pnOffset) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.CdmaNmrObj = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * CDMA base station ID (BSID).
         */
        public var baseStationId: kotlin.Int? = null
        /**
         * CDMA channel information.
         */
        public var cdmaChannel: kotlin.Int? = null
        /**
         * Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
         */
        public var pilotPower: kotlin.Int? = null
        /**
         * Pseudo-noise offset, which is a characteristic of the signal from a cell on a radio tower.
         */
        public var pnOffset: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.CdmaNmrObj) : this() {
            this.baseStationId = x.baseStationId
            this.cdmaChannel = x.cdmaChannel
            this.pilotPower = x.pilotPower
            this.pnOffset = x.pnOffset
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.CdmaNmrObj = CdmaNmrObj(this)

        internal fun correctErrors(): Builder {
            if (cdmaChannel == null) cdmaChannel = 0
            if (pnOffset == null) pnOffset = 0
            return this
        }
    }
}
