// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.serde

import aws.sdk.kotlin.services.iotwireless.model.FuotaTaskLogOption
import aws.sdk.kotlin.services.iotwireless.model.GetLogLevelsByResourceTypesResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.LogLevel
import aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceLogOption
import aws.sdk.kotlin.services.iotwireless.model.WirelessGatewayLogOption
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetLogLevelsByResourceTypesOperationDeserializer: HttpDeserializer.NonStreaming<GetLogLevelsByResourceTypesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetLogLevelsByResourceTypesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetLogLevelsByResourceTypesError(context, call, payload)
        }
        val builder = GetLogLevelsByResourceTypesResponse.Builder()

        if (payload != null) {
            deserializeGetLogLevelsByResourceTypesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetLogLevelsByResourceTypesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLogLevelsByResourceTypesOperationBody(builder: GetLogLevelsByResourceTypesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEFAULTLOGLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DefaultLogLevel"))
    val FUOTATASKLOGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FuotaTaskLogOptions"))
    val WIRELESSDEVICELOGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessDeviceLogOptions"))
    val WIRELESSGATEWAYLOGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WirelessGatewayLogOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFAULTLOGLEVEL_DESCRIPTOR)
        field(FUOTATASKLOGOPTIONS_DESCRIPTOR)
        field(WIRELESSDEVICELOGOPTIONS_DESCRIPTOR)
        field(WIRELESSGATEWAYLOGOPTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEFAULTLOGLEVEL_DESCRIPTOR.index -> builder.defaultLogLevel = deserializeString().let { LogLevel.fromValue(it) }
                FUOTATASKLOGOPTIONS_DESCRIPTOR.index -> builder.fuotaTaskLogOptions =
                    deserializer.deserializeList(FUOTATASKLOGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<FuotaTaskLogOption>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFuotaTaskLogOptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WIRELESSDEVICELOGOPTIONS_DESCRIPTOR.index -> builder.wirelessDeviceLogOptions =
                    deserializer.deserializeList(WIRELESSDEVICELOGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<WirelessDeviceLogOption>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWirelessDeviceLogOptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WIRELESSGATEWAYLOGOPTIONS_DESCRIPTOR.index -> builder.wirelessGatewayLogOptions =
                    deserializer.deserializeList(WIRELESSGATEWAYLOGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<WirelessGatewayLogOption>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWirelessGatewayLogOptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
