// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The log options for a FUOTA task event and can be used to set log levels for a specific FUOTA task event.
 *
 * For a LoRaWAN FUOTA task, the only possible event for a log message is `Fuota`.
 */
public class FuotaTaskEventLogOption private constructor(builder: Builder) {
    /**
     * The event for a log message, if the log message is tied to a FUOTA task.
     */
    public val event: aws.sdk.kotlin.services.iotwireless.model.FuotaTaskEvent = requireNotNull(builder.event) { "A non-null value must be provided for event" }
    /**
     * The log level for a log message. The log levels can be disabled, or set to `ERROR` to display less verbose logs containing only error information, or to `INFO` for more detailed logs.
     */
    public val logLevel: aws.sdk.kotlin.services.iotwireless.model.LogLevel = requireNotNull(builder.logLevel) { "A non-null value must be provided for logLevel" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.FuotaTaskEventLogOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FuotaTaskEventLogOption(")
        append("event=$event,")
        append("logLevel=$logLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = event.hashCode()
        result = 31 * result + (logLevel.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FuotaTaskEventLogOption

        if (event != other.event) return false
        if (logLevel != other.logLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.FuotaTaskEventLogOption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The event for a log message, if the log message is tied to a FUOTA task.
         */
        public var event: aws.sdk.kotlin.services.iotwireless.model.FuotaTaskEvent? = null
        /**
         * The log level for a log message. The log levels can be disabled, or set to `ERROR` to display less verbose logs containing only error information, or to `INFO` for more detailed logs.
         */
        public var logLevel: aws.sdk.kotlin.services.iotwireless.model.LogLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.FuotaTaskEventLogOption) : this() {
            this.event = x.event
            this.logLevel = x.logLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.FuotaTaskEventLogOption = FuotaTaskEventLogOption(this)

        internal fun correctErrors(): Builder {
            if (event == null) event = FuotaTaskEvent.SdkUnknown("no value provided")
            if (logLevel == null) logLevel = LogLevel.SdkUnknown("no value provided")
            return this
        }
    }
}
