// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a wireless device's operation.
 */
public class WirelessDeviceStatistics private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name of the resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the destination to which the device is assigned.
     */
    public val destinationName: kotlin.String? = builder.destinationName
    /**
     * The status of a wireless device in a FUOTA task.
     */
    public val fuotaDeviceStatus: aws.sdk.kotlin.services.iotwireless.model.FuotaDeviceStatus? = builder.fuotaDeviceStatus
    /**
     * The ID of the wireless device reporting the data.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The date and time when the most recent uplink was received.
     *
     * Theis value is only valid for 3 months.
     */
    public val lastUplinkReceivedAt: kotlin.String? = builder.lastUplinkReceivedAt
    /**
     * LoRaWAN device info.
     */
    public val loRaWan: aws.sdk.kotlin.services.iotwireless.model.LoRaWanListDevice? = builder.loRaWan
    /**
     * Id of the multicast group.
     */
    public val mcGroupId: kotlin.Int? = builder.mcGroupId
    /**
     * The status of the wireless device in the multicast group.
     */
    public val multicastDeviceStatus: kotlin.String? = builder.multicastDeviceStatus
    /**
     * The name of the resource.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Sidewalk account credentials.
     */
    public val sidewalk: aws.sdk.kotlin.services.iotwireless.model.SidewalkListDevice? = builder.sidewalk
    /**
     * The wireless device type.
     */
    public val type: aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceStatistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WirelessDeviceStatistics(")
        append("arn=$arn,")
        append("destinationName=$destinationName,")
        append("fuotaDeviceStatus=$fuotaDeviceStatus,")
        append("id=$id,")
        append("lastUplinkReceivedAt=$lastUplinkReceivedAt,")
        append("loRaWan=$loRaWan,")
        append("mcGroupId=$mcGroupId,")
        append("multicastDeviceStatus=$multicastDeviceStatus,")
        append("name=$name,")
        append("sidewalk=$sidewalk,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (destinationName?.hashCode() ?: 0)
        result = 31 * result + (fuotaDeviceStatus?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUplinkReceivedAt?.hashCode() ?: 0)
        result = 31 * result + (loRaWan?.hashCode() ?: 0)
        result = 31 * result + (mcGroupId ?: 0)
        result = 31 * result + (multicastDeviceStatus?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sidewalk?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WirelessDeviceStatistics

        if (arn != other.arn) return false
        if (destinationName != other.destinationName) return false
        if (fuotaDeviceStatus != other.fuotaDeviceStatus) return false
        if (id != other.id) return false
        if (lastUplinkReceivedAt != other.lastUplinkReceivedAt) return false
        if (loRaWan != other.loRaWan) return false
        if (mcGroupId != other.mcGroupId) return false
        if (multicastDeviceStatus != other.multicastDeviceStatus) return false
        if (name != other.name) return false
        if (sidewalk != other.sidewalk) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceStatistics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name of the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the destination to which the device is assigned.
         */
        public var destinationName: kotlin.String? = null
        /**
         * The status of a wireless device in a FUOTA task.
         */
        public var fuotaDeviceStatus: aws.sdk.kotlin.services.iotwireless.model.FuotaDeviceStatus? = null
        /**
         * The ID of the wireless device reporting the data.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time when the most recent uplink was received.
         *
         * Theis value is only valid for 3 months.
         */
        public var lastUplinkReceivedAt: kotlin.String? = null
        /**
         * LoRaWAN device info.
         */
        public var loRaWan: aws.sdk.kotlin.services.iotwireless.model.LoRaWanListDevice? = null
        /**
         * Id of the multicast group.
         */
        public var mcGroupId: kotlin.Int? = null
        /**
         * The status of the wireless device in the multicast group.
         */
        public var multicastDeviceStatus: kotlin.String? = null
        /**
         * The name of the resource.
         */
        public var name: kotlin.String? = null
        /**
         * The Sidewalk account credentials.
         */
        public var sidewalk: aws.sdk.kotlin.services.iotwireless.model.SidewalkListDevice? = null
        /**
         * The wireless device type.
         */
        public var type: aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceStatistics) : this() {
            this.arn = x.arn
            this.destinationName = x.destinationName
            this.fuotaDeviceStatus = x.fuotaDeviceStatus
            this.id = x.id
            this.lastUplinkReceivedAt = x.lastUplinkReceivedAt
            this.loRaWan = x.loRaWan
            this.mcGroupId = x.mcGroupId
            this.multicastDeviceStatus = x.multicastDeviceStatus
            this.name = x.name
            this.sidewalk = x.sidewalk
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.WirelessDeviceStatistics = WirelessDeviceStatistics(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.LoRaWanListDevice] inside the given [block]
         */
        public fun loRaWan(block: aws.sdk.kotlin.services.iotwireless.model.LoRaWanListDevice.Builder.() -> kotlin.Unit) {
            this.loRaWan = aws.sdk.kotlin.services.iotwireless.model.LoRaWanListDevice.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.SidewalkListDevice] inside the given [block]
         */
        public fun sidewalk(block: aws.sdk.kotlin.services.iotwireless.model.SidewalkListDevice.Builder.() -> kotlin.Unit) {
            this.sidewalk = aws.sdk.kotlin.services.iotwireless.model.SidewalkListDevice.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
