// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specify the list of gateways to which you want to send the multicast downlink messages. The multicast message will be sent to each gateway in the sequence provided in the list.
 */
public class ParticipatingGatewaysMulticast private constructor(builder: Builder) {
    /**
     * The list of gateways that you want to use for sending the multicast downlink. Each downlink will be sent to all the gateways in the list with transmission interval between them. If list is empty the gateway list will be dynamically selected similar to the case of no ParticipatingGateways
     */
    public val gatewayList: List<String>? = builder.gatewayList
    /**
     * The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the multicast payload to the next gateway in the list.
     */
    public val transmissionInterval: kotlin.Int? = builder.transmissionInterval

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.ParticipatingGatewaysMulticast = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParticipatingGatewaysMulticast(")
        append("gatewayList=$gatewayList,")
        append("transmissionInterval=$transmissionInterval")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayList?.hashCode() ?: 0
        result = 31 * result + (transmissionInterval ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParticipatingGatewaysMulticast

        if (gatewayList != other.gatewayList) return false
        if (transmissionInterval != other.transmissionInterval) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.ParticipatingGatewaysMulticast = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of gateways that you want to use for sending the multicast downlink. Each downlink will be sent to all the gateways in the list with transmission interval between them. If list is empty the gateway list will be dynamically selected similar to the case of no ParticipatingGateways
         */
        public var gatewayList: List<String>? = null
        /**
         * The duration of time for which AWS IoT Core for LoRaWAN will wait before transmitting the multicast payload to the next gateway in the list.
         */
        public var transmissionInterval: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.ParticipatingGatewaysMulticast) : this() {
            this.gatewayList = x.gatewayList
            this.transmissionInterval = x.transmissionInterval
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.ParticipatingGatewaysMulticast = ParticipatingGatewaysMulticast(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
