// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The device attestation key (DAK) information.
 */
public class DakCertificateMetadata private constructor(builder: Builder) {
    /**
     * The advertised product ID (APID) that's used for pre-production and production applications.
     */
    public val apId: kotlin.String? = builder.apId
    /**
     * The certificate ID for the DAK.
     */
    public val certificateId: kotlin.String = requireNotNull(builder.certificateId) { "A non-null value must be provided for certificateId" }
    /**
     * The device type ID that's used for prototyping applications.
     */
    public val deviceTypeId: kotlin.String? = builder.deviceTypeId
    /**
     * Whether factory support has been enabled.
     */
    public val factorySupport: kotlin.Boolean? = builder.factorySupport
    /**
     * The maximum number of signatures that the DAK can sign. A value of `-1` indicates that there's no device limit.
     */
    public val maxAllowedSignature: kotlin.Int? = builder.maxAllowedSignature

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.DakCertificateMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DakCertificateMetadata(")
        append("apId=$apId,")
        append("certificateId=$certificateId,")
        append("deviceTypeId=$deviceTypeId,")
        append("factorySupport=$factorySupport,")
        append("maxAllowedSignature=$maxAllowedSignature")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apId?.hashCode() ?: 0
        result = 31 * result + (certificateId.hashCode())
        result = 31 * result + (deviceTypeId?.hashCode() ?: 0)
        result = 31 * result + (factorySupport?.hashCode() ?: 0)
        result = 31 * result + (maxAllowedSignature ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DakCertificateMetadata

        if (apId != other.apId) return false
        if (certificateId != other.certificateId) return false
        if (deviceTypeId != other.deviceTypeId) return false
        if (factorySupport != other.factorySupport) return false
        if (maxAllowedSignature != other.maxAllowedSignature) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.DakCertificateMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The advertised product ID (APID) that's used for pre-production and production applications.
         */
        public var apId: kotlin.String? = null
        /**
         * The certificate ID for the DAK.
         */
        public var certificateId: kotlin.String? = null
        /**
         * The device type ID that's used for prototyping applications.
         */
        public var deviceTypeId: kotlin.String? = null
        /**
         * Whether factory support has been enabled.
         */
        public var factorySupport: kotlin.Boolean? = null
        /**
         * The maximum number of signatures that the DAK can sign. A value of `-1` indicates that there's no device limit.
         */
        public var maxAllowedSignature: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.DakCertificateMetadata) : this() {
            this.apId = x.apId
            this.certificateId = x.certificateId
            this.deviceTypeId = x.deviceTypeId
            this.factorySupport = x.factorySupport
            this.maxAllowedSignature = x.maxAllowedSignature
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.DakCertificateMetadata = DakCertificateMetadata(this)

        internal fun correctErrors(): Builder {
            if (certificateId == null) certificateId = ""
            return this
        }
    }
}
