// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.iotwireless.auth.IotWirelessAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.iotwireless.auth.IotWirelessIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.iotwireless.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.iotwireless.model.*
import aws.sdk.kotlin.services.iotwireless.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultIotWirelessClient(override val config: IotWirelessClient.Config) : IotWirelessClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = IotWirelessIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "iotwireless")
        }
        toMap()
    }
    private val authSchemeAdapter = IotWirelessAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.iotwireless"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates a partner account with your AWS account.
     */
    override suspend fun associateAwsAccountWithPartnerAccount(input: AssociateAwsAccountWithPartnerAccountRequest): AssociateAwsAccountWithPartnerAccountResponse {
        val op = SdkHttpOperation.build<AssociateAwsAccountWithPartnerAccountRequest, AssociateAwsAccountWithPartnerAccountResponse> {
            serializeWith = AssociateAwsAccountWithPartnerAccountOperationSerializer()
            deserializeWith = AssociateAwsAccountWithPartnerAccountOperationDeserializer()
            operationName = "AssociateAwsAccountWithPartnerAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associate a multicast group with a FUOTA task.
     */
    override suspend fun associateMulticastGroupWithFuotaTask(input: AssociateMulticastGroupWithFuotaTaskRequest): AssociateMulticastGroupWithFuotaTaskResponse {
        val op = SdkHttpOperation.build<AssociateMulticastGroupWithFuotaTaskRequest, AssociateMulticastGroupWithFuotaTaskResponse> {
            serializeWith = AssociateMulticastGroupWithFuotaTaskOperationSerializer()
            deserializeWith = AssociateMulticastGroupWithFuotaTaskOperationDeserializer()
            operationName = "AssociateMulticastGroupWithFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associate a wireless device with a FUOTA task.
     */
    override suspend fun associateWirelessDeviceWithFuotaTask(input: AssociateWirelessDeviceWithFuotaTaskRequest): AssociateWirelessDeviceWithFuotaTaskResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithFuotaTaskRequest, AssociateWirelessDeviceWithFuotaTaskResponse> {
            serializeWith = AssociateWirelessDeviceWithFuotaTaskOperationSerializer()
            deserializeWith = AssociateWirelessDeviceWithFuotaTaskOperationDeserializer()
            operationName = "AssociateWirelessDeviceWithFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless device with a multicast group.
     */
    override suspend fun associateWirelessDeviceWithMulticastGroup(input: AssociateWirelessDeviceWithMulticastGroupRequest): AssociateWirelessDeviceWithMulticastGroupResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithMulticastGroupRequest, AssociateWirelessDeviceWithMulticastGroupResponse> {
            serializeWith = AssociateWirelessDeviceWithMulticastGroupOperationSerializer()
            deserializeWith = AssociateWirelessDeviceWithMulticastGroupOperationDeserializer()
            operationName = "AssociateWirelessDeviceWithMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless device with a thing.
     */
    override suspend fun associateWirelessDeviceWithThing(input: AssociateWirelessDeviceWithThingRequest): AssociateWirelessDeviceWithThingResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithThingRequest, AssociateWirelessDeviceWithThingResponse> {
            serializeWith = AssociateWirelessDeviceWithThingOperationSerializer()
            deserializeWith = AssociateWirelessDeviceWithThingOperationDeserializer()
            operationName = "AssociateWirelessDeviceWithThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless gateway with a certificate.
     */
    override suspend fun associateWirelessGatewayWithCertificate(input: AssociateWirelessGatewayWithCertificateRequest): AssociateWirelessGatewayWithCertificateResponse {
        val op = SdkHttpOperation.build<AssociateWirelessGatewayWithCertificateRequest, AssociateWirelessGatewayWithCertificateResponse> {
            serializeWith = AssociateWirelessGatewayWithCertificateOperationSerializer()
            deserializeWith = AssociateWirelessGatewayWithCertificateOperationDeserializer()
            operationName = "AssociateWirelessGatewayWithCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless gateway with a thing.
     */
    override suspend fun associateWirelessGatewayWithThing(input: AssociateWirelessGatewayWithThingRequest): AssociateWirelessGatewayWithThingResponse {
        val op = SdkHttpOperation.build<AssociateWirelessGatewayWithThingRequest, AssociateWirelessGatewayWithThingResponse> {
            serializeWith = AssociateWirelessGatewayWithThingOperationSerializer()
            deserializeWith = AssociateWirelessGatewayWithThingOperationDeserializer()
            operationName = "AssociateWirelessGatewayWithThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an existing multicast group session.
     */
    override suspend fun cancelMulticastGroupSession(input: CancelMulticastGroupSessionRequest): CancelMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<CancelMulticastGroupSessionRequest, CancelMulticastGroupSessionResponse> {
            serializeWith = CancelMulticastGroupSessionOperationSerializer()
            deserializeWith = CancelMulticastGroupSessionOperationDeserializer()
            operationName = "CancelMulticastGroupSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new destination that maps a device message to an AWS IoT rule.
     */
    override suspend fun createDestination(input: CreateDestinationRequest): CreateDestinationResponse {
        val op = SdkHttpOperation.build<CreateDestinationRequest, CreateDestinationResponse> {
            serializeWith = CreateDestinationOperationSerializer()
            deserializeWith = CreateDestinationOperationDeserializer()
            operationName = "CreateDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new device profile.
     */
    override suspend fun createDeviceProfile(input: CreateDeviceProfileRequest): CreateDeviceProfileResponse {
        val op = SdkHttpOperation.build<CreateDeviceProfileRequest, CreateDeviceProfileResponse> {
            serializeWith = CreateDeviceProfileOperationSerializer()
            deserializeWith = CreateDeviceProfileOperationDeserializer()
            operationName = "CreateDeviceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a FUOTA task.
     */
    override suspend fun createFuotaTask(input: CreateFuotaTaskRequest): CreateFuotaTaskResponse {
        val op = SdkHttpOperation.build<CreateFuotaTaskRequest, CreateFuotaTaskResponse> {
            serializeWith = CreateFuotaTaskOperationSerializer()
            deserializeWith = CreateFuotaTaskOperationDeserializer()
            operationName = "CreateFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a multicast group.
     */
    override suspend fun createMulticastGroup(input: CreateMulticastGroupRequest): CreateMulticastGroupResponse {
        val op = SdkHttpOperation.build<CreateMulticastGroupRequest, CreateMulticastGroupResponse> {
            serializeWith = CreateMulticastGroupOperationSerializer()
            deserializeWith = CreateMulticastGroupOperationDeserializer()
            operationName = "CreateMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new network analyzer configuration.
     */
    override suspend fun createNetworkAnalyzerConfiguration(input: CreateNetworkAnalyzerConfigurationRequest): CreateNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<CreateNetworkAnalyzerConfigurationRequest, CreateNetworkAnalyzerConfigurationResponse> {
            serializeWith = CreateNetworkAnalyzerConfigurationOperationSerializer()
            deserializeWith = CreateNetworkAnalyzerConfigurationOperationDeserializer()
            operationName = "CreateNetworkAnalyzerConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new service profile.
     */
    override suspend fun createServiceProfile(input: CreateServiceProfileRequest): CreateServiceProfileResponse {
        val op = SdkHttpOperation.build<CreateServiceProfileRequest, CreateServiceProfileResponse> {
            serializeWith = CreateServiceProfileOperationSerializer()
            deserializeWith = CreateServiceProfileOperationDeserializer()
            operationName = "CreateServiceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provisions a wireless device.
     */
    override suspend fun createWirelessDevice(input: CreateWirelessDeviceRequest): CreateWirelessDeviceResponse {
        val op = SdkHttpOperation.build<CreateWirelessDeviceRequest, CreateWirelessDeviceResponse> {
            serializeWith = CreateWirelessDeviceOperationSerializer()
            deserializeWith = CreateWirelessDeviceOperationDeserializer()
            operationName = "CreateWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provisions a wireless gateway.
     *
     * When provisioning a wireless gateway, you might run into duplication errors for the following reasons.
     * + If you specify a `GatewayEui` value that already exists.
     * + If you used a `ClientRequestToken` with the same parameters within the last 10 minutes.
     * To avoid this error, make sure that you use unique identifiers and parameters for each request within the specified time period.
     */
    override suspend fun createWirelessGateway(input: CreateWirelessGatewayRequest): CreateWirelessGatewayResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayRequest, CreateWirelessGatewayResponse> {
            serializeWith = CreateWirelessGatewayOperationSerializer()
            deserializeWith = CreateWirelessGatewayOperationDeserializer()
            operationName = "CreateWirelessGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a task for a wireless gateway.
     */
    override suspend fun createWirelessGatewayTask(input: CreateWirelessGatewayTaskRequest): CreateWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayTaskRequest, CreateWirelessGatewayTaskResponse> {
            serializeWith = CreateWirelessGatewayTaskOperationSerializer()
            deserializeWith = CreateWirelessGatewayTaskOperationDeserializer()
            operationName = "CreateWirelessGatewayTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a gateway task definition.
     */
    override suspend fun createWirelessGatewayTaskDefinition(input: CreateWirelessGatewayTaskDefinitionRequest): CreateWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayTaskDefinitionRequest, CreateWirelessGatewayTaskDefinitionResponse> {
            serializeWith = CreateWirelessGatewayTaskDefinitionOperationSerializer()
            deserializeWith = CreateWirelessGatewayTaskDefinitionOperationDeserializer()
            operationName = "CreateWirelessGatewayTaskDefinition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a destination.
     */
    override suspend fun deleteDestination(input: DeleteDestinationRequest): DeleteDestinationResponse {
        val op = SdkHttpOperation.build<DeleteDestinationRequest, DeleteDestinationResponse> {
            serializeWith = DeleteDestinationOperationSerializer()
            deserializeWith = DeleteDestinationOperationDeserializer()
            operationName = "DeleteDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a device profile.
     */
    override suspend fun deleteDeviceProfile(input: DeleteDeviceProfileRequest): DeleteDeviceProfileResponse {
        val op = SdkHttpOperation.build<DeleteDeviceProfileRequest, DeleteDeviceProfileResponse> {
            serializeWith = DeleteDeviceProfileOperationSerializer()
            deserializeWith = DeleteDeviceProfileOperationDeserializer()
            operationName = "DeleteDeviceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a FUOTA task.
     */
    override suspend fun deleteFuotaTask(input: DeleteFuotaTaskRequest): DeleteFuotaTaskResponse {
        val op = SdkHttpOperation.build<DeleteFuotaTaskRequest, DeleteFuotaTaskResponse> {
            serializeWith = DeleteFuotaTaskOperationSerializer()
            deserializeWith = DeleteFuotaTaskOperationDeserializer()
            operationName = "DeleteFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a multicast group if it is not in use by a fuota task.
     */
    override suspend fun deleteMulticastGroup(input: DeleteMulticastGroupRequest): DeleteMulticastGroupResponse {
        val op = SdkHttpOperation.build<DeleteMulticastGroupRequest, DeleteMulticastGroupResponse> {
            serializeWith = DeleteMulticastGroupOperationSerializer()
            deserializeWith = DeleteMulticastGroupOperationDeserializer()
            operationName = "DeleteMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a network analyzer configuration.
     */
    override suspend fun deleteNetworkAnalyzerConfiguration(input: DeleteNetworkAnalyzerConfigurationRequest): DeleteNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteNetworkAnalyzerConfigurationRequest, DeleteNetworkAnalyzerConfigurationResponse> {
            serializeWith = DeleteNetworkAnalyzerConfigurationOperationSerializer()
            deserializeWith = DeleteNetworkAnalyzerConfigurationOperationDeserializer()
            operationName = "DeleteNetworkAnalyzerConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Remove queued messages from the downlink queue.
     */
    override suspend fun deleteQueuedMessages(input: DeleteQueuedMessagesRequest): DeleteQueuedMessagesResponse {
        val op = SdkHttpOperation.build<DeleteQueuedMessagesRequest, DeleteQueuedMessagesResponse> {
            serializeWith = DeleteQueuedMessagesOperationSerializer()
            deserializeWith = DeleteQueuedMessagesOperationDeserializer()
            operationName = "DeleteQueuedMessages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a service profile.
     */
    override suspend fun deleteServiceProfile(input: DeleteServiceProfileRequest): DeleteServiceProfileResponse {
        val op = SdkHttpOperation.build<DeleteServiceProfileRequest, DeleteServiceProfileResponse> {
            serializeWith = DeleteServiceProfileOperationSerializer()
            deserializeWith = DeleteServiceProfileOperationDeserializer()
            operationName = "DeleteServiceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless device.
     */
    override suspend fun deleteWirelessDevice(input: DeleteWirelessDeviceRequest): DeleteWirelessDeviceResponse {
        val op = SdkHttpOperation.build<DeleteWirelessDeviceRequest, DeleteWirelessDeviceResponse> {
            serializeWith = DeleteWirelessDeviceOperationSerializer()
            deserializeWith = DeleteWirelessDeviceOperationDeserializer()
            operationName = "DeleteWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Delete an import task.
     */
    override suspend fun deleteWirelessDeviceImportTask(input: DeleteWirelessDeviceImportTaskRequest): DeleteWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<DeleteWirelessDeviceImportTaskRequest, DeleteWirelessDeviceImportTaskResponse> {
            serializeWith = DeleteWirelessDeviceImportTaskOperationSerializer()
            deserializeWith = DeleteWirelessDeviceImportTaskOperationDeserializer()
            operationName = "DeleteWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway.
     *
     * When deleting a wireless gateway, you might run into duplication errors for the following reasons.
     * + If you specify a `GatewayEui` value that already exists.
     * + If you used a `ClientRequestToken` with the same parameters within the last 10 minutes.
     * To avoid this error, make sure that you use unique identifiers and parameters for each request within the specified time period.
     */
    override suspend fun deleteWirelessGateway(input: DeleteWirelessGatewayRequest): DeleteWirelessGatewayResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayRequest, DeleteWirelessGatewayResponse> {
            serializeWith = DeleteWirelessGatewayOperationSerializer()
            deserializeWith = DeleteWirelessGatewayOperationDeserializer()
            operationName = "DeleteWirelessGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway task.
     */
    override suspend fun deleteWirelessGatewayTask(input: DeleteWirelessGatewayTaskRequest): DeleteWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayTaskRequest, DeleteWirelessGatewayTaskResponse> {
            serializeWith = DeleteWirelessGatewayTaskOperationSerializer()
            deserializeWith = DeleteWirelessGatewayTaskOperationDeserializer()
            operationName = "DeleteWirelessGatewayTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.
     */
    override suspend fun deleteWirelessGatewayTaskDefinition(input: DeleteWirelessGatewayTaskDefinitionRequest): DeleteWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayTaskDefinitionRequest, DeleteWirelessGatewayTaskDefinitionResponse> {
            serializeWith = DeleteWirelessGatewayTaskDefinitionOperationSerializer()
            deserializeWith = DeleteWirelessGatewayTaskDefinitionOperationDeserializer()
            operationName = "DeleteWirelessGatewayTaskDefinition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deregister a wireless device from AWS IoT Wireless.
     */
    override suspend fun deregisterWirelessDevice(input: DeregisterWirelessDeviceRequest): DeregisterWirelessDeviceResponse {
        val op = SdkHttpOperation.build<DeregisterWirelessDeviceRequest, DeregisterWirelessDeviceResponse> {
            serializeWith = DeregisterWirelessDeviceOperationSerializer()
            deserializeWith = DeregisterWirelessDeviceOperationDeserializer()
            operationName = "DeregisterWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates your AWS account from a partner account. If `PartnerAccountId` and `PartnerType` are `null`, disassociates your AWS account from all partner accounts.
     */
    override suspend fun disassociateAwsAccountFromPartnerAccount(input: DisassociateAwsAccountFromPartnerAccountRequest): DisassociateAwsAccountFromPartnerAccountResponse {
        val op = SdkHttpOperation.build<DisassociateAwsAccountFromPartnerAccountRequest, DisassociateAwsAccountFromPartnerAccountResponse> {
            serializeWith = DisassociateAwsAccountFromPartnerAccountOperationSerializer()
            deserializeWith = DisassociateAwsAccountFromPartnerAccountOperationDeserializer()
            operationName = "DisassociateAwsAccountFromPartnerAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a multicast group from a fuota task.
     */
    override suspend fun disassociateMulticastGroupFromFuotaTask(input: DisassociateMulticastGroupFromFuotaTaskRequest): DisassociateMulticastGroupFromFuotaTaskResponse {
        val op = SdkHttpOperation.build<DisassociateMulticastGroupFromFuotaTaskRequest, DisassociateMulticastGroupFromFuotaTaskResponse> {
            serializeWith = DisassociateMulticastGroupFromFuotaTaskOperationSerializer()
            deserializeWith = DisassociateMulticastGroupFromFuotaTaskOperationDeserializer()
            operationName = "DisassociateMulticastGroupFromFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from a FUOTA task.
     */
    override suspend fun disassociateWirelessDeviceFromFuotaTask(input: DisassociateWirelessDeviceFromFuotaTaskRequest): DisassociateWirelessDeviceFromFuotaTaskResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromFuotaTaskRequest, DisassociateWirelessDeviceFromFuotaTaskResponse> {
            serializeWith = DisassociateWirelessDeviceFromFuotaTaskOperationSerializer()
            deserializeWith = DisassociateWirelessDeviceFromFuotaTaskOperationDeserializer()
            operationName = "DisassociateWirelessDeviceFromFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from a multicast group.
     */
    override suspend fun disassociateWirelessDeviceFromMulticastGroup(input: DisassociateWirelessDeviceFromMulticastGroupRequest): DisassociateWirelessDeviceFromMulticastGroupResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromMulticastGroupRequest, DisassociateWirelessDeviceFromMulticastGroupResponse> {
            serializeWith = DisassociateWirelessDeviceFromMulticastGroupOperationSerializer()
            deserializeWith = DisassociateWirelessDeviceFromMulticastGroupOperationDeserializer()
            operationName = "DisassociateWirelessDeviceFromMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from its currently associated thing.
     */
    override suspend fun disassociateWirelessDeviceFromThing(input: DisassociateWirelessDeviceFromThingRequest): DisassociateWirelessDeviceFromThingResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromThingRequest, DisassociateWirelessDeviceFromThingResponse> {
            serializeWith = DisassociateWirelessDeviceFromThingOperationSerializer()
            deserializeWith = DisassociateWirelessDeviceFromThingOperationDeserializer()
            operationName = "DisassociateWirelessDeviceFromThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless gateway from its currently associated certificate.
     */
    override suspend fun disassociateWirelessGatewayFromCertificate(input: DisassociateWirelessGatewayFromCertificateRequest): DisassociateWirelessGatewayFromCertificateResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessGatewayFromCertificateRequest, DisassociateWirelessGatewayFromCertificateResponse> {
            serializeWith = DisassociateWirelessGatewayFromCertificateOperationSerializer()
            deserializeWith = DisassociateWirelessGatewayFromCertificateOperationDeserializer()
            operationName = "DisassociateWirelessGatewayFromCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless gateway from its currently associated thing.
     */
    override suspend fun disassociateWirelessGatewayFromThing(input: DisassociateWirelessGatewayFromThingRequest): DisassociateWirelessGatewayFromThingResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessGatewayFromThingRequest, DisassociateWirelessGatewayFromThingResponse> {
            serializeWith = DisassociateWirelessGatewayFromThingOperationSerializer()
            deserializeWith = DisassociateWirelessGatewayFromThingOperationDeserializer()
            operationName = "DisassociateWirelessGatewayFromThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a destination.
     */
    override suspend fun getDestination(input: GetDestinationRequest): GetDestinationResponse {
        val op = SdkHttpOperation.build<GetDestinationRequest, GetDestinationResponse> {
            serializeWith = GetDestinationOperationSerializer()
            deserializeWith = GetDestinationOperationDeserializer()
            operationName = "GetDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a device profile.
     */
    override suspend fun getDeviceProfile(input: GetDeviceProfileRequest): GetDeviceProfileResponse {
        val op = SdkHttpOperation.build<GetDeviceProfileRequest, GetDeviceProfileResponse> {
            serializeWith = GetDeviceProfileOperationSerializer()
            deserializeWith = GetDeviceProfileOperationDeserializer()
            operationName = "GetDeviceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the event configuration based on resource types.
     */
    override suspend fun getEventConfigurationByResourceTypes(input: GetEventConfigurationByResourceTypesRequest): GetEventConfigurationByResourceTypesResponse {
        val op = SdkHttpOperation.build<GetEventConfigurationByResourceTypesRequest, GetEventConfigurationByResourceTypesResponse> {
            serializeWith = GetEventConfigurationByResourceTypesOperationSerializer()
            deserializeWith = GetEventConfigurationByResourceTypesOperationDeserializer()
            operationName = "GetEventConfigurationByResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a FUOTA task.
     */
    override suspend fun getFuotaTask(input: GetFuotaTaskRequest): GetFuotaTaskResponse {
        val op = SdkHttpOperation.build<GetFuotaTaskRequest, GetFuotaTaskResponse> {
            serializeWith = GetFuotaTaskOperationSerializer()
            deserializeWith = GetFuotaTaskOperationDeserializer()
            operationName = "GetFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.
     */
    override suspend fun getLogLevelsByResourceTypes(input: GetLogLevelsByResourceTypesRequest): GetLogLevelsByResourceTypesResponse {
        val op = SdkHttpOperation.build<GetLogLevelsByResourceTypesRequest, GetLogLevelsByResourceTypesResponse> {
            serializeWith = GetLogLevelsByResourceTypesOperationSerializer()
            deserializeWith = GetLogLevelsByResourceTypesOperationDeserializer()
            operationName = "GetLogLevelsByResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the metric configuration status for this AWS account.
     */
    override suspend fun getMetricConfiguration(input: GetMetricConfigurationRequest): GetMetricConfigurationResponse {
        val op = SdkHttpOperation.build<GetMetricConfigurationRequest, GetMetricConfigurationResponse> {
            serializeWith = GetMetricConfigurationOperationSerializer()
            deserializeWith = GetMetricConfigurationOperationDeserializer()
            operationName = "GetMetricConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the summary metrics for this AWS account.
     */
    override suspend fun getMetrics(input: GetMetricsRequest): GetMetricsResponse {
        val op = SdkHttpOperation.build<GetMetricsRequest, GetMetricsResponse> {
            serializeWith = GetMetricsOperationSerializer()
            deserializeWith = GetMetricsOperationDeserializer()
            operationName = "GetMetrics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a multicast group.
     */
    override suspend fun getMulticastGroup(input: GetMulticastGroupRequest): GetMulticastGroupResponse {
        val op = SdkHttpOperation.build<GetMulticastGroupRequest, GetMulticastGroupResponse> {
            serializeWith = GetMulticastGroupOperationSerializer()
            deserializeWith = GetMulticastGroupOperationDeserializer()
            operationName = "GetMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a multicast group session.
     */
    override suspend fun getMulticastGroupSession(input: GetMulticastGroupSessionRequest): GetMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<GetMulticastGroupSessionRequest, GetMulticastGroupSessionResponse> {
            serializeWith = GetMulticastGroupSessionOperationSerializer()
            deserializeWith = GetMulticastGroupSessionOperationDeserializer()
            operationName = "GetMulticastGroupSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get network analyzer configuration.
     */
    override suspend fun getNetworkAnalyzerConfiguration(input: GetNetworkAnalyzerConfigurationRequest): GetNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<GetNetworkAnalyzerConfigurationRequest, GetNetworkAnalyzerConfigurationResponse> {
            serializeWith = GetNetworkAnalyzerConfigurationOperationSerializer()
            deserializeWith = GetNetworkAnalyzerConfigurationOperationDeserializer()
            operationName = "GetNetworkAnalyzerConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a partner account. If `PartnerAccountId` and `PartnerType` are `null`, returns all partner accounts.
     */
    override suspend fun getPartnerAccount(input: GetPartnerAccountRequest): GetPartnerAccountResponse {
        val op = SdkHttpOperation.build<GetPartnerAccountRequest, GetPartnerAccountResponse> {
            serializeWith = GetPartnerAccountOperationSerializer()
            deserializeWith = GetPartnerAccountOperationDeserializer()
            operationName = "GetPartnerAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the position information for a given resource.
     *
     * This action is no longer supported. Calls to retrieve the position information should use the [GetResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html) API operation instead.
     */
    @Deprecated("This operation is no longer supported.")
    override suspend fun getPosition(input: GetPositionRequest): GetPositionResponse {
        val op = SdkHttpOperation.build<GetPositionRequest, GetPositionResponse> {
            serializeWith = GetPositionOperationSerializer()
            deserializeWith = GetPositionOperationDeserializer()
            operationName = "GetPosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get position configuration for a given resource.
     *
     * This action is no longer supported. Calls to retrieve the position configuration should use the [GetResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html) API operation instead.
     */
    @Deprecated("This operation is no longer supported.")
    override suspend fun getPositionConfiguration(input: GetPositionConfigurationRequest): GetPositionConfigurationResponse {
        val op = SdkHttpOperation.build<GetPositionConfigurationRequest, GetPositionConfigurationResponse> {
            serializeWith = GetPositionConfigurationOperationSerializer()
            deserializeWith = GetPositionConfigurationOperationDeserializer()
            operationName = "GetPositionConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get estimated position information as a payload in GeoJSON format. The payload measurement data is resolved using solvers that are provided by third-party vendors.
     */
    override suspend fun getPositionEstimate(input: GetPositionEstimateRequest): GetPositionEstimateResponse {
        val op = SdkHttpOperation.build<GetPositionEstimateRequest, GetPositionEstimateResponse> {
            serializeWith = GetPositionEstimateOperationSerializer()
            deserializeWith = GetPositionEstimateOperationDeserializer()
            operationName = "GetPositionEstimate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the event configuration for a particular resource identifier.
     */
    override suspend fun getResourceEventConfiguration(input: GetResourceEventConfigurationRequest): GetResourceEventConfigurationResponse {
        val op = SdkHttpOperation.build<GetResourceEventConfigurationRequest, GetResourceEventConfigurationResponse> {
            serializeWith = GetResourceEventConfigurationOperationSerializer()
            deserializeWith = GetResourceEventConfigurationOperationDeserializer()
            operationName = "GetResourceEventConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device, wireless gateway or fuota task.
     */
    override suspend fun getResourceLogLevel(input: GetResourceLogLevelRequest): GetResourceLogLevelResponse {
        val op = SdkHttpOperation.build<GetResourceLogLevelRequest, GetResourceLogLevelResponse> {
            serializeWith = GetResourceLogLevelOperationSerializer()
            deserializeWith = GetResourceLogLevelOperationDeserializer()
            operationName = "GetResourceLogLevel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the position information for a given wireless device or a wireless gateway resource. The position information uses the [ World Geodetic System (WGS84)](https://gisgeography.com/wgs84-world-geodetic-system/).
     */
    override suspend fun getResourcePosition(input: GetResourcePositionRequest): GetResourcePositionResponse {
        val op = SdkHttpOperation.build<GetResourcePositionRequest, GetResourcePositionResponse> {
            serializeWith = GetResourcePositionOperationSerializer()
            deserializeWith = GetResourcePositionOperationDeserializer()
            operationName = "GetResourcePosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.
     */
    override suspend fun getServiceEndpoint(input: GetServiceEndpointRequest): GetServiceEndpointResponse {
        val op = SdkHttpOperation.build<GetServiceEndpointRequest, GetServiceEndpointResponse> {
            serializeWith = GetServiceEndpointOperationSerializer()
            deserializeWith = GetServiceEndpointOperationDeserializer()
            operationName = "GetServiceEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a service profile.
     */
    override suspend fun getServiceProfile(input: GetServiceProfileRequest): GetServiceProfileResponse {
        val op = SdkHttpOperation.build<GetServiceProfileRequest, GetServiceProfileResponse> {
            serializeWith = GetServiceProfileOperationSerializer()
            deserializeWith = GetServiceProfileOperationDeserializer()
            operationName = "GetServiceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless device.
     */
    override suspend fun getWirelessDevice(input: GetWirelessDeviceRequest): GetWirelessDeviceResponse {
        val op = SdkHttpOperation.build<GetWirelessDeviceRequest, GetWirelessDeviceResponse> {
            serializeWith = GetWirelessDeviceOperationSerializer()
            deserializeWith = GetWirelessDeviceOperationDeserializer()
            operationName = "GetWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get information about an import task and count of device onboarding summary information for the import task.
     */
    override suspend fun getWirelessDeviceImportTask(input: GetWirelessDeviceImportTaskRequest): GetWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<GetWirelessDeviceImportTaskRequest, GetWirelessDeviceImportTaskResponse> {
            serializeWith = GetWirelessDeviceImportTaskOperationSerializer()
            deserializeWith = GetWirelessDeviceImportTaskOperationDeserializer()
            operationName = "GetWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets operating information about a wireless device.
     */
    override suspend fun getWirelessDeviceStatistics(input: GetWirelessDeviceStatisticsRequest): GetWirelessDeviceStatisticsResponse {
        val op = SdkHttpOperation.build<GetWirelessDeviceStatisticsRequest, GetWirelessDeviceStatisticsResponse> {
            serializeWith = GetWirelessDeviceStatisticsOperationSerializer()
            deserializeWith = GetWirelessDeviceStatisticsOperationDeserializer()
            operationName = "GetWirelessDeviceStatistics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway.
     */
    override suspend fun getWirelessGateway(input: GetWirelessGatewayRequest): GetWirelessGatewayResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayRequest, GetWirelessGatewayResponse> {
            serializeWith = GetWirelessGatewayOperationSerializer()
            deserializeWith = GetWirelessGatewayOperationDeserializer()
            operationName = "GetWirelessGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     */
    override suspend fun getWirelessGatewayCertificate(input: GetWirelessGatewayCertificateRequest): GetWirelessGatewayCertificateResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayCertificateRequest, GetWirelessGatewayCertificateResponse> {
            serializeWith = GetWirelessGatewayCertificateOperationSerializer()
            deserializeWith = GetWirelessGatewayCertificateOperationDeserializer()
            operationName = "GetWirelessGatewayCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the firmware version and other information about a wireless gateway.
     */
    override suspend fun getWirelessGatewayFirmwareInformation(input: GetWirelessGatewayFirmwareInformationRequest): GetWirelessGatewayFirmwareInformationResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayFirmwareInformationRequest, GetWirelessGatewayFirmwareInformationResponse> {
            serializeWith = GetWirelessGatewayFirmwareInformationOperationSerializer()
            deserializeWith = GetWirelessGatewayFirmwareInformationOperationDeserializer()
            operationName = "GetWirelessGatewayFirmwareInformation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets operating information about a wireless gateway.
     */
    override suspend fun getWirelessGatewayStatistics(input: GetWirelessGatewayStatisticsRequest): GetWirelessGatewayStatisticsResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayStatisticsRequest, GetWirelessGatewayStatisticsResponse> {
            serializeWith = GetWirelessGatewayStatisticsOperationSerializer()
            deserializeWith = GetWirelessGatewayStatisticsOperationDeserializer()
            operationName = "GetWirelessGatewayStatistics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway task.
     */
    override suspend fun getWirelessGatewayTask(input: GetWirelessGatewayTaskRequest): GetWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayTaskRequest, GetWirelessGatewayTaskResponse> {
            serializeWith = GetWirelessGatewayTaskOperationSerializer()
            deserializeWith = GetWirelessGatewayTaskOperationDeserializer()
            operationName = "GetWirelessGatewayTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway task definition.
     */
    override suspend fun getWirelessGatewayTaskDefinition(input: GetWirelessGatewayTaskDefinitionRequest): GetWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayTaskDefinitionRequest, GetWirelessGatewayTaskDefinitionResponse> {
            serializeWith = GetWirelessGatewayTaskDefinitionOperationSerializer()
            deserializeWith = GetWirelessGatewayTaskDefinitionOperationDeserializer()
            operationName = "GetWirelessGatewayTaskDefinition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the destinations registered to your AWS account.
     */
    override suspend fun listDestinations(input: ListDestinationsRequest): ListDestinationsResponse {
        val op = SdkHttpOperation.build<ListDestinationsRequest, ListDestinationsResponse> {
            serializeWith = ListDestinationsOperationSerializer()
            deserializeWith = ListDestinationsOperationDeserializer()
            operationName = "ListDestinations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the device profiles registered to your AWS account.
     */
    override suspend fun listDeviceProfiles(input: ListDeviceProfilesRequest): ListDeviceProfilesResponse {
        val op = SdkHttpOperation.build<ListDeviceProfilesRequest, ListDeviceProfilesResponse> {
            serializeWith = ListDeviceProfilesOperationSerializer()
            deserializeWith = ListDeviceProfilesOperationDeserializer()
            operationName = "ListDeviceProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List the Sidewalk devices in an import task and their onboarding status.
     */
    override suspend fun listDevicesForWirelessDeviceImportTask(input: ListDevicesForWirelessDeviceImportTaskRequest): ListDevicesForWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<ListDevicesForWirelessDeviceImportTaskRequest, ListDevicesForWirelessDeviceImportTaskResponse> {
            serializeWith = ListDevicesForWirelessDeviceImportTaskOperationSerializer()
            deserializeWith = ListDevicesForWirelessDeviceImportTaskOperationDeserializer()
            operationName = "ListDevicesForWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List event configurations where at least one event topic has been enabled.
     */
    override suspend fun listEventConfigurations(input: ListEventConfigurationsRequest): ListEventConfigurationsResponse {
        val op = SdkHttpOperation.build<ListEventConfigurationsRequest, ListEventConfigurationsResponse> {
            serializeWith = ListEventConfigurationsOperationSerializer()
            deserializeWith = ListEventConfigurationsOperationDeserializer()
            operationName = "ListEventConfigurations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the FUOTA tasks registered to your AWS account.
     */
    override suspend fun listFuotaTasks(input: ListFuotaTasksRequest): ListFuotaTasksResponse {
        val op = SdkHttpOperation.build<ListFuotaTasksRequest, ListFuotaTasksResponse> {
            serializeWith = ListFuotaTasksOperationSerializer()
            deserializeWith = ListFuotaTasksOperationDeserializer()
            operationName = "ListFuotaTasks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the multicast groups registered to your AWS account.
     */
    override suspend fun listMulticastGroups(input: ListMulticastGroupsRequest): ListMulticastGroupsResponse {
        val op = SdkHttpOperation.build<ListMulticastGroupsRequest, ListMulticastGroupsResponse> {
            serializeWith = ListMulticastGroupsOperationSerializer()
            deserializeWith = ListMulticastGroupsOperationDeserializer()
            operationName = "ListMulticastGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List all multicast groups associated with a fuota task.
     */
    override suspend fun listMulticastGroupsByFuotaTask(input: ListMulticastGroupsByFuotaTaskRequest): ListMulticastGroupsByFuotaTaskResponse {
        val op = SdkHttpOperation.build<ListMulticastGroupsByFuotaTaskRequest, ListMulticastGroupsByFuotaTaskResponse> {
            serializeWith = ListMulticastGroupsByFuotaTaskOperationSerializer()
            deserializeWith = ListMulticastGroupsByFuotaTaskOperationDeserializer()
            operationName = "ListMulticastGroupsByFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the network analyzer configurations.
     */
    override suspend fun listNetworkAnalyzerConfigurations(input: ListNetworkAnalyzerConfigurationsRequest): ListNetworkAnalyzerConfigurationsResponse {
        val op = SdkHttpOperation.build<ListNetworkAnalyzerConfigurationsRequest, ListNetworkAnalyzerConfigurationsResponse> {
            serializeWith = ListNetworkAnalyzerConfigurationsOperationSerializer()
            deserializeWith = ListNetworkAnalyzerConfigurationsOperationDeserializer()
            operationName = "ListNetworkAnalyzerConfigurations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the partner accounts associated with your AWS account.
     */
    override suspend fun listPartnerAccounts(input: ListPartnerAccountsRequest): ListPartnerAccountsResponse {
        val op = SdkHttpOperation.build<ListPartnerAccountsRequest, ListPartnerAccountsResponse> {
            serializeWith = ListPartnerAccountsOperationSerializer()
            deserializeWith = ListPartnerAccountsOperationDeserializer()
            operationName = "ListPartnerAccounts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List position configurations for a given resource, such as positioning solvers.
     *
     * This action is no longer supported. Calls to retrieve position information should use the [GetResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html) API operation instead.
     */
    @Deprecated("This operation is no longer supported.")
    override suspend fun listPositionConfigurations(input: ListPositionConfigurationsRequest): ListPositionConfigurationsResponse {
        val op = SdkHttpOperation.build<ListPositionConfigurationsRequest, ListPositionConfigurationsResponse> {
            serializeWith = ListPositionConfigurationsOperationSerializer()
            deserializeWith = ListPositionConfigurationsOperationDeserializer()
            operationName = "ListPositionConfigurations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List queued messages in the downlink queue.
     */
    override suspend fun listQueuedMessages(input: ListQueuedMessagesRequest): ListQueuedMessagesResponse {
        val op = SdkHttpOperation.build<ListQueuedMessagesRequest, ListQueuedMessagesResponse> {
            serializeWith = ListQueuedMessagesOperationSerializer()
            deserializeWith = ListQueuedMessagesOperationDeserializer()
            operationName = "ListQueuedMessages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the service profiles registered to your AWS account.
     */
    override suspend fun listServiceProfiles(input: ListServiceProfilesRequest): ListServiceProfilesResponse {
        val op = SdkHttpOperation.build<ListServiceProfilesRequest, ListServiceProfilesResponse> {
            serializeWith = ListServiceProfilesOperationSerializer()
            deserializeWith = ListServiceProfilesOperationDeserializer()
            operationName = "ListServiceProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List wireless devices that have been added to an import task.
     */
    override suspend fun listWirelessDeviceImportTasks(input: ListWirelessDeviceImportTasksRequest): ListWirelessDeviceImportTasksResponse {
        val op = SdkHttpOperation.build<ListWirelessDeviceImportTasksRequest, ListWirelessDeviceImportTasksResponse> {
            serializeWith = ListWirelessDeviceImportTasksOperationSerializer()
            deserializeWith = ListWirelessDeviceImportTasksOperationDeserializer()
            operationName = "ListWirelessDeviceImportTasks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the wireless devices registered to your AWS account.
     */
    override suspend fun listWirelessDevices(input: ListWirelessDevicesRequest): ListWirelessDevicesResponse {
        val op = SdkHttpOperation.build<ListWirelessDevicesRequest, ListWirelessDevicesResponse> {
            serializeWith = ListWirelessDevicesOperationSerializer()
            deserializeWith = ListWirelessDevicesOperationDeserializer()
            operationName = "ListWirelessDevices"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List the wireless gateway tasks definitions registered to your AWS account.
     */
    override suspend fun listWirelessGatewayTaskDefinitions(input: ListWirelessGatewayTaskDefinitionsRequest): ListWirelessGatewayTaskDefinitionsResponse {
        val op = SdkHttpOperation.build<ListWirelessGatewayTaskDefinitionsRequest, ListWirelessGatewayTaskDefinitionsResponse> {
            serializeWith = ListWirelessGatewayTaskDefinitionsOperationSerializer()
            deserializeWith = ListWirelessGatewayTaskDefinitionsOperationDeserializer()
            operationName = "ListWirelessGatewayTaskDefinitions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the wireless gateways registered to your AWS account.
     */
    override suspend fun listWirelessGateways(input: ListWirelessGatewaysRequest): ListWirelessGatewaysResponse {
        val op = SdkHttpOperation.build<ListWirelessGatewaysRequest, ListWirelessGatewaysResponse> {
            serializeWith = ListWirelessGatewaysOperationSerializer()
            deserializeWith = ListWirelessGatewaysOperationDeserializer()
            operationName = "ListWirelessGateways"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Put position configuration for a given resource.
     *
     * This action is no longer supported. Calls to update the position configuration should use the [UpdateResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html) API operation instead.
     */
    @Deprecated("This operation is no longer supported.")
    override suspend fun putPositionConfiguration(input: PutPositionConfigurationRequest): PutPositionConfigurationResponse {
        val op = SdkHttpOperation.build<PutPositionConfigurationRequest, PutPositionConfigurationResponse> {
            serializeWith = PutPositionConfigurationOperationSerializer()
            deserializeWith = PutPositionConfigurationOperationDeserializer()
            operationName = "PutPositionConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.
     */
    override suspend fun putResourceLogLevel(input: PutResourceLogLevelRequest): PutResourceLogLevelResponse {
        val op = SdkHttpOperation.build<PutResourceLogLevelRequest, PutResourceLogLevelResponse> {
            serializeWith = PutResourceLogLevelOperationSerializer()
            deserializeWith = PutResourceLogLevelOperationDeserializer()
            operationName = "PutResourceLogLevel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the log-level overrides for all resources; wireless devices, wireless gateways, and fuota tasks.
     */
    override suspend fun resetAllResourceLogLevels(input: ResetAllResourceLogLevelsRequest): ResetAllResourceLogLevelsResponse {
        val op = SdkHttpOperation.build<ResetAllResourceLogLevelsRequest, ResetAllResourceLogLevelsResponse> {
            serializeWith = ResetAllResourceLogLevelsOperationSerializer()
            deserializeWith = ResetAllResourceLogLevelsOperationDeserializer()
            operationName = "ResetAllResourceLogLevels"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device, a wireless gateway, or a fuota task.
     */
    override suspend fun resetResourceLogLevel(input: ResetResourceLogLevelRequest): ResetResourceLogLevelResponse {
        val op = SdkHttpOperation.build<ResetResourceLogLevelRequest, ResetResourceLogLevelResponse> {
            serializeWith = ResetResourceLogLevelOperationSerializer()
            deserializeWith = ResetResourceLogLevelOperationDeserializer()
            operationName = "ResetResourceLogLevel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sends the specified data to a multicast group.
     */
    override suspend fun sendDataToMulticastGroup(input: SendDataToMulticastGroupRequest): SendDataToMulticastGroupResponse {
        val op = SdkHttpOperation.build<SendDataToMulticastGroupRequest, SendDataToMulticastGroupResponse> {
            serializeWith = SendDataToMulticastGroupOperationSerializer()
            deserializeWith = SendDataToMulticastGroupOperationDeserializer()
            operationName = "SendDataToMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sends a decrypted application data frame to a device.
     */
    override suspend fun sendDataToWirelessDevice(input: SendDataToWirelessDeviceRequest): SendDataToWirelessDeviceResponse {
        val op = SdkHttpOperation.build<SendDataToWirelessDeviceRequest, SendDataToWirelessDeviceResponse> {
            serializeWith = SendDataToWirelessDeviceOperationSerializer()
            deserializeWith = SendDataToWirelessDeviceOperationDeserializer()
            operationName = "SendDataToWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     */
    override suspend fun startBulkAssociateWirelessDeviceWithMulticastGroup(input: StartBulkAssociateWirelessDeviceWithMulticastGroupRequest): StartBulkAssociateWirelessDeviceWithMulticastGroupResponse {
        val op = SdkHttpOperation.build<StartBulkAssociateWirelessDeviceWithMulticastGroupRequest, StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> {
            serializeWith = StartBulkAssociateWirelessDeviceWithMulticastGroupOperationSerializer()
            deserializeWith = StartBulkAssociateWirelessDeviceWithMulticastGroupOperationDeserializer()
            operationName = "StartBulkAssociateWirelessDeviceWithMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     */
    override suspend fun startBulkDisassociateWirelessDeviceFromMulticastGroup(input: StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest): StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse {
        val op = SdkHttpOperation.build<StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest, StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> {
            serializeWith = StartBulkDisassociateWirelessDeviceFromMulticastGroupOperationSerializer()
            deserializeWith = StartBulkDisassociateWirelessDeviceFromMulticastGroupOperationDeserializer()
            operationName = "StartBulkDisassociateWirelessDeviceFromMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a FUOTA task.
     */
    override suspend fun startFuotaTask(input: StartFuotaTaskRequest): StartFuotaTaskResponse {
        val op = SdkHttpOperation.build<StartFuotaTaskRequest, StartFuotaTaskResponse> {
            serializeWith = StartFuotaTaskOperationSerializer()
            deserializeWith = StartFuotaTaskOperationDeserializer()
            operationName = "StartFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a multicast group session.
     */
    override suspend fun startMulticastGroupSession(input: StartMulticastGroupSessionRequest): StartMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<StartMulticastGroupSessionRequest, StartMulticastGroupSessionResponse> {
            serializeWith = StartMulticastGroupSessionOperationSerializer()
            deserializeWith = StartMulticastGroupSessionOperationDeserializer()
            operationName = "StartMulticastGroupSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Start import task for a single wireless device.
     */
    override suspend fun startSingleWirelessDeviceImportTask(input: StartSingleWirelessDeviceImportTaskRequest): StartSingleWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<StartSingleWirelessDeviceImportTaskRequest, StartSingleWirelessDeviceImportTaskResponse> {
            serializeWith = StartSingleWirelessDeviceImportTaskOperationSerializer()
            deserializeWith = StartSingleWirelessDeviceImportTaskOperationDeserializer()
            operationName = "StartSingleWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.
     */
    override suspend fun startWirelessDeviceImportTask(input: StartWirelessDeviceImportTaskRequest): StartWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<StartWirelessDeviceImportTaskRequest, StartWirelessDeviceImportTaskResponse> {
            serializeWith = StartWirelessDeviceImportTaskOperationSerializer()
            deserializeWith = StartWirelessDeviceImportTaskOperationDeserializer()
            operationName = "StartWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a tag to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Simulates a provisioned device by sending an uplink data payload of `Hello`.
     */
    override suspend fun testWirelessDevice(input: TestWirelessDeviceRequest): TestWirelessDeviceResponse {
        val op = SdkHttpOperation.build<TestWirelessDeviceRequest, TestWirelessDeviceResponse> {
            serializeWith = TestWirelessDeviceOperationSerializer()
            deserializeWith = TestWirelessDeviceOperationDeserializer()
            operationName = "TestWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a destination.
     */
    override suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse {
        val op = SdkHttpOperation.build<UpdateDestinationRequest, UpdateDestinationResponse> {
            serializeWith = UpdateDestinationOperationSerializer()
            deserializeWith = UpdateDestinationOperationDeserializer()
            operationName = "UpdateDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the event configuration based on resource types.
     */
    override suspend fun updateEventConfigurationByResourceTypes(input: UpdateEventConfigurationByResourceTypesRequest): UpdateEventConfigurationByResourceTypesResponse {
        val op = SdkHttpOperation.build<UpdateEventConfigurationByResourceTypesRequest, UpdateEventConfigurationByResourceTypesResponse> {
            serializeWith = UpdateEventConfigurationByResourceTypesOperationSerializer()
            deserializeWith = UpdateEventConfigurationByResourceTypesOperationDeserializer()
            operationName = "UpdateEventConfigurationByResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a FUOTA task.
     */
    override suspend fun updateFuotaTask(input: UpdateFuotaTaskRequest): UpdateFuotaTaskResponse {
        val op = SdkHttpOperation.build<UpdateFuotaTaskRequest, UpdateFuotaTaskResponse> {
            serializeWith = UpdateFuotaTaskOperationSerializer()
            deserializeWith = UpdateFuotaTaskOperationDeserializer()
            operationName = "UpdateFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     */
    override suspend fun updateLogLevelsByResourceTypes(input: UpdateLogLevelsByResourceTypesRequest): UpdateLogLevelsByResourceTypesResponse {
        val op = SdkHttpOperation.build<UpdateLogLevelsByResourceTypesRequest, UpdateLogLevelsByResourceTypesResponse> {
            serializeWith = UpdateLogLevelsByResourceTypesOperationSerializer()
            deserializeWith = UpdateLogLevelsByResourceTypesOperationDeserializer()
            operationName = "UpdateLogLevelsByResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the summary metric configuration.
     */
    override suspend fun updateMetricConfiguration(input: UpdateMetricConfigurationRequest): UpdateMetricConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateMetricConfigurationRequest, UpdateMetricConfigurationResponse> {
            serializeWith = UpdateMetricConfigurationOperationSerializer()
            deserializeWith = UpdateMetricConfigurationOperationDeserializer()
            operationName = "UpdateMetricConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a multicast group session.
     */
    override suspend fun updateMulticastGroup(input: UpdateMulticastGroupRequest): UpdateMulticastGroupResponse {
        val op = SdkHttpOperation.build<UpdateMulticastGroupRequest, UpdateMulticastGroupResponse> {
            serializeWith = UpdateMulticastGroupOperationSerializer()
            deserializeWith = UpdateMulticastGroupOperationDeserializer()
            operationName = "UpdateMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update network analyzer configuration.
     */
    override suspend fun updateNetworkAnalyzerConfiguration(input: UpdateNetworkAnalyzerConfigurationRequest): UpdateNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateNetworkAnalyzerConfigurationRequest, UpdateNetworkAnalyzerConfigurationResponse> {
            serializeWith = UpdateNetworkAnalyzerConfigurationOperationSerializer()
            deserializeWith = UpdateNetworkAnalyzerConfigurationOperationDeserializer()
            operationName = "UpdateNetworkAnalyzerConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a partner account.
     */
    override suspend fun updatePartnerAccount(input: UpdatePartnerAccountRequest): UpdatePartnerAccountResponse {
        val op = SdkHttpOperation.build<UpdatePartnerAccountRequest, UpdatePartnerAccountResponse> {
            serializeWith = UpdatePartnerAccountOperationSerializer()
            deserializeWith = UpdatePartnerAccountOperationDeserializer()
            operationName = "UpdatePartnerAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the position information of a resource.
     *
     * This action is no longer supported. Calls to update the position information should use the [UpdateResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html) API operation instead.
     */
    @Deprecated("This operation is no longer supported.")
    override suspend fun updatePosition(input: UpdatePositionRequest): UpdatePositionResponse {
        val op = SdkHttpOperation.build<UpdatePositionRequest, UpdatePositionResponse> {
            serializeWith = UpdatePositionOperationSerializer()
            deserializeWith = UpdatePositionOperationDeserializer()
            operationName = "UpdatePosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the event configuration for a particular resource identifier.
     */
    override suspend fun updateResourceEventConfiguration(input: UpdateResourceEventConfigurationRequest): UpdateResourceEventConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateResourceEventConfigurationRequest, UpdateResourceEventConfigurationResponse> {
            serializeWith = UpdateResourceEventConfigurationOperationSerializer()
            deserializeWith = UpdateResourceEventConfigurationOperationDeserializer()
            operationName = "UpdateResourceEventConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the position information of a given wireless device or a wireless gateway resource. The position coordinates are based on the [ World Geodetic System (WGS84)](https://gisgeography.com/wgs84-world-geodetic-system/).
     */
    override suspend fun updateResourcePosition(input: UpdateResourcePositionRequest): UpdateResourcePositionResponse {
        val op = SdkHttpOperation.build<UpdateResourcePositionRequest, UpdateResourcePositionResponse> {
            serializeWith = UpdateResourcePositionOperationSerializer()
            deserializeWith = UpdateResourcePositionOperationDeserializer()
            operationName = "UpdateResourcePosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a wireless device.
     */
    override suspend fun updateWirelessDevice(input: UpdateWirelessDeviceRequest): UpdateWirelessDeviceResponse {
        val op = SdkHttpOperation.build<UpdateWirelessDeviceRequest, UpdateWirelessDeviceResponse> {
            serializeWith = UpdateWirelessDeviceOperationSerializer()
            deserializeWith = UpdateWirelessDeviceOperationDeserializer()
            operationName = "UpdateWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update an import task to add more devices to the task.
     */
    override suspend fun updateWirelessDeviceImportTask(input: UpdateWirelessDeviceImportTaskRequest): UpdateWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<UpdateWirelessDeviceImportTaskRequest, UpdateWirelessDeviceImportTaskResponse> {
            serializeWith = UpdateWirelessDeviceImportTaskOperationSerializer()
            deserializeWith = UpdateWirelessDeviceImportTaskOperationDeserializer()
            operationName = "UpdateWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a wireless gateway.
     */
    override suspend fun updateWirelessGateway(input: UpdateWirelessGatewayRequest): UpdateWirelessGatewayResponse {
        val op = SdkHttpOperation.build<UpdateWirelessGatewayRequest, UpdateWirelessGatewayResponse> {
            serializeWith = UpdateWirelessGatewayOperationSerializer()
            deserializeWith = UpdateWirelessGatewayOperationDeserializer()
            operationName = "UpdateWirelessGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotwireless")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
