// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.serde

import aws.sdk.kotlin.services.iotwireless.model.Accuracy
import aws.sdk.kotlin.services.iotwireless.model.GetPositionResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.PositionSolverProvider
import aws.sdk.kotlin.services.iotwireless.model.PositionSolverType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetPositionOperationDeserializer: HttpDeserializer.NonStreaming<GetPositionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetPositionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPositionError(context, call, payload)
        }
        val builder = GetPositionResponse.Builder()

        if (payload != null) {
            deserializeGetPositionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetPositionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPositionOperationBody(builder: GetPositionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCURACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Accuracy"))
    val POSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Position"))
    val SOLVERPROVIDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SolverProvider"))
    val SOLVERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SolverType"))
    val SOLVERVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SolverVersion"))
    val TIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Timestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCURACY_DESCRIPTOR)
        field(POSITION_DESCRIPTOR)
        field(SOLVERPROVIDER_DESCRIPTOR)
        field(SOLVERTYPE_DESCRIPTOR)
        field(SOLVERVERSION_DESCRIPTOR)
        field(TIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCURACY_DESCRIPTOR.index -> builder.accuracy = deserializeAccuracyDocument(deserializer)
                POSITION_DESCRIPTOR.index -> builder.position =
                    deserializer.deserializeList(POSITION_DESCRIPTOR) {
                        val col0 = mutableListOf<Float>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFloat() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SOLVERPROVIDER_DESCRIPTOR.index -> builder.solverProvider = deserializeString().let { PositionSolverProvider.fromValue(it) }
                SOLVERTYPE_DESCRIPTOR.index -> builder.solverType = deserializeString().let { PositionSolverType.fromValue(it) }
                SOLVERVERSION_DESCRIPTOR.index -> builder.solverVersion = deserializeString()
                TIMESTAMP_DESCRIPTOR.index -> builder.timestamp = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
