// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.serde

import aws.sdk.kotlin.services.iotwireless.model.CellTowers
import aws.sdk.kotlin.services.iotwireless.model.GetPositionEstimateRequest
import aws.sdk.kotlin.services.iotwireless.model.Gnss
import aws.sdk.kotlin.services.iotwireless.model.Ip
import aws.sdk.kotlin.services.iotwireless.model.WiFiAccessPoint
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetPositionEstimateOperationSerializer: HttpSerializer.NonStreaming<GetPositionEstimateRequest> {
    override fun serialize(context: ExecutionContext, input: GetPositionEstimateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/position-estimate"
        }

        val payload = serializeGetPositionEstimateOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetPositionEstimateOperationBody(context: ExecutionContext, input: GetPositionEstimateRequest): ByteArray {
    val serializer = JsonSerializer()
    val CELLTOWERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CellTowers"))
    val GNSS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Gnss"))
    val IP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Ip"))
    val TIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("Timestamp"))
    val WIFIACCESSPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WiFiAccessPoints"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CELLTOWERS_DESCRIPTOR)
        field(GNSS_DESCRIPTOR)
        field(IP_DESCRIPTOR)
        field(TIMESTAMP_DESCRIPTOR)
        field(WIFIACCESSPOINTS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cellTowers?.let { field(CELLTOWERS_DESCRIPTOR, it, ::serializeCellTowersDocument) }
        input.gnss?.let { field(GNSS_DESCRIPTOR, it, ::serializeGnssDocument) }
        input.ip?.let { field(IP_DESCRIPTOR, it, ::serializeIpDocument) }
        input.timestamp?.let { field(TIMESTAMP_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        if (input.wiFiAccessPoints != null) {
            listField(WIFIACCESSPOINTS_DESCRIPTOR) {
                for (el0 in input.wiFiAccessPoints) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeWiFiAccessPointDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
