// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateResourcePositionRequest private constructor(builder: Builder) {
    /**
     * The position information of the resource, displayed as a JSON payload. The payload uses the GeoJSON format, which a format that's used to encode geographic data structures. For more information, see [GeoJSON](https://geojson.org/).
     */
    public val geoJsonPayload: kotlin.ByteArray? = builder.geoJsonPayload
    /**
     * The identifier of the resource for which position information is updated. It can be the wireless device ID or the wireless gateway ID, depending on the resource type.
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier
    /**
     * The type of resource for which position information is updated, which can be a wireless device or a wireless gateway.
     */
    public val resourceType: aws.sdk.kotlin.services.iotwireless.model.PositionResourceType? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.UpdateResourcePositionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateResourcePositionRequest(")
        append("geoJsonPayload=$geoJsonPayload,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = geoJsonPayload?.contentHashCode() ?: 0
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateResourcePositionRequest

        if (geoJsonPayload != null) {
            if (other.geoJsonPayload == null) return false
            if (!geoJsonPayload.contentEquals(other.geoJsonPayload)) return false
        } else if (other.geoJsonPayload != null) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.UpdateResourcePositionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The position information of the resource, displayed as a JSON payload. The payload uses the GeoJSON format, which a format that's used to encode geographic data structures. For more information, see [GeoJSON](https://geojson.org/).
         */
        public var geoJsonPayload: kotlin.ByteArray? = null
        /**
         * The identifier of the resource for which position information is updated. It can be the wireless device ID or the wireless gateway ID, depending on the resource type.
         */
        public var resourceIdentifier: kotlin.String? = null
        /**
         * The type of resource for which position information is updated, which can be a wireless device or a wireless gateway.
         */
        public var resourceType: aws.sdk.kotlin.services.iotwireless.model.PositionResourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.UpdateResourcePositionRequest) : this() {
            this.geoJsonPayload = x.geoJsonPayload
            this.resourceIdentifier = x.resourceIdentifier
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.UpdateResourcePositionRequest = UpdateResourcePositionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
