// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.serde

import aws.sdk.kotlin.services.iotwireless.model.FuotaTaskStatus
import aws.sdk.kotlin.services.iotwireless.model.GetFuotaTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.LoRaWanFuotaTaskGetInfo
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetFuotaTaskOperationDeserializer: HttpDeserializer.NonStreaming<GetFuotaTaskResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetFuotaTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFuotaTaskError(context, call, payload)
        }
        val builder = GetFuotaTaskResponse.Builder()

        if (payload != null) {
            deserializeGetFuotaTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetFuotaTaskError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFuotaTaskOperationBody(builder: GetFuotaTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FIRMWAREUPDATEIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirmwareUpdateImage"))
    val FIRMWAREUPDATEROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirmwareUpdateRole"))
    val FRAGMENTINTERVALMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FragmentIntervalMS"))
    val FRAGMENTSIZEBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FragmentSizeBytes"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val LORAWAN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoRaWAN"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val REDUNDANCYPERCENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RedundancyPercent"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FIRMWAREUPDATEIMAGE_DESCRIPTOR)
        field(FIRMWAREUPDATEROLE_DESCRIPTOR)
        field(FRAGMENTINTERVALMS_DESCRIPTOR)
        field(FRAGMENTSIZEBYTES_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LORAWAN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REDUNDANCYPERCENT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FIRMWAREUPDATEIMAGE_DESCRIPTOR.index -> builder.firmwareUpdateImage = deserializeString()
                FIRMWAREUPDATEROLE_DESCRIPTOR.index -> builder.firmwareUpdateRole = deserializeString()
                FRAGMENTINTERVALMS_DESCRIPTOR.index -> builder.fragmentIntervalMs = deserializeInt()
                FRAGMENTSIZEBYTES_DESCRIPTOR.index -> builder.fragmentSizeBytes = deserializeInt()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LORAWAN_DESCRIPTOR.index -> builder.loRaWan = deserializeLoRaWanFuotaTaskGetInfoDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REDUNDANCYPERCENT_DESCRIPTOR.index -> builder.redundancyPercent = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { FuotaTaskStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
