// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Global navigation satellite system (GNSS) object used for positioning.
 */
public class Gnss private constructor(builder: Builder) {
    /**
     * Optional assistance altitude, which is the altitude of the device at capture time, specified in meters above the WGS84 reference ellipsoid.
     */
    public val assistAltitude: kotlin.Float? = builder.assistAltitude
    /**
     * Optional assistance position information, specified using latitude and longitude values in degrees. The coordinates are inside the WGS84 reference frame.
     */
    public val assistPosition: List<Float>? = builder.assistPosition
    /**
     * Optional parameter that gives an estimate of the time when the GNSS scan information is taken, in seconds GPS time (GPST). If capture time is not specified, the local server time is used.
     */
    public val captureTime: kotlin.Float? = builder.captureTime
    /**
     * Optional value that gives the capture time estimate accuracy, in seconds. If capture time accuracy is not specified, default value of 300 is used.
     */
    public val captureTimeAccuracy: kotlin.Float? = builder.captureTimeAccuracy
    /**
     * Payload that contains the GNSS scan result, or NAV message, in hexadecimal notation.
     */
    public val payload: kotlin.String = requireNotNull(builder.payload) { "A non-null value must be provided for payload" }
    /**
     * Optional parameter that forces 2D solve, which modifies the positioning algorithm to a 2D solution problem. When this parameter is specified, the assistance altitude should have an accuracy of at least 10 meters.
     */
    public val use2DSolver: kotlin.Boolean = builder.use2DSolver

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.Gnss = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Gnss(")
        append("assistAltitude=$assistAltitude,")
        append("assistPosition=$assistPosition,")
        append("captureTime=$captureTime,")
        append("captureTimeAccuracy=$captureTimeAccuracy,")
        append("payload=$payload,")
        append("use2DSolver=$use2DSolver")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assistAltitude?.hashCode() ?: 0
        result = 31 * result + (assistPosition?.hashCode() ?: 0)
        result = 31 * result + (captureTime?.hashCode() ?: 0)
        result = 31 * result + (captureTimeAccuracy?.hashCode() ?: 0)
        result = 31 * result + (payload.hashCode())
        result = 31 * result + (use2DSolver.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Gnss

        if (!(assistAltitude?.equals(other.assistAltitude) ?: (other.assistAltitude == null))) return false
        if (assistPosition != other.assistPosition) return false
        if (!(captureTime?.equals(other.captureTime) ?: (other.captureTime == null))) return false
        if (!(captureTimeAccuracy?.equals(other.captureTimeAccuracy) ?: (other.captureTimeAccuracy == null))) return false
        if (payload != other.payload) return false
        if (use2DSolver != other.use2DSolver) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.Gnss = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Optional assistance altitude, which is the altitude of the device at capture time, specified in meters above the WGS84 reference ellipsoid.
         */
        public var assistAltitude: kotlin.Float? = null
        /**
         * Optional assistance position information, specified using latitude and longitude values in degrees. The coordinates are inside the WGS84 reference frame.
         */
        public var assistPosition: List<Float>? = null
        /**
         * Optional parameter that gives an estimate of the time when the GNSS scan information is taken, in seconds GPS time (GPST). If capture time is not specified, the local server time is used.
         */
        public var captureTime: kotlin.Float? = null
        /**
         * Optional value that gives the capture time estimate accuracy, in seconds. If capture time accuracy is not specified, default value of 300 is used.
         */
        public var captureTimeAccuracy: kotlin.Float? = null
        /**
         * Payload that contains the GNSS scan result, or NAV message, in hexadecimal notation.
         */
        public var payload: kotlin.String? = null
        /**
         * Optional parameter that forces 2D solve, which modifies the positioning algorithm to a 2D solution problem. When this parameter is specified, the assistance altitude should have an accuracy of at least 10 meters.
         */
        public var use2DSolver: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.Gnss) : this() {
            this.assistAltitude = x.assistAltitude
            this.assistPosition = x.assistPosition
            this.captureTime = x.captureTime
            this.captureTimeAccuracy = x.captureTimeAccuracy
            this.payload = x.payload
            this.use2DSolver = x.use2DSolver
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.Gnss = Gnss(this)

        internal fun correctErrors(): Builder {
            if (payload == null) payload = ""
            return this
        }
    }
}
