// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CDMA (Code-division multiple access) object.
 */
public class CdmaObj private constructor(builder: Builder) {
    /**
     * CDMA base station latitude in degrees.
     */
    public val baseLat: kotlin.Float? = builder.baseLat
    /**
     * CDMA base station longitude in degrees.
     */
    public val baseLng: kotlin.Float? = builder.baseLng
    /**
     * CDMA base station ID (BSID).
     */
    public val baseStationId: kotlin.Int = requireNotNull(builder.baseStationId) { "A non-null value must be provided for baseStationId" }
    /**
     * CDMA local identification (local ID) parameters.
     */
    public val cdmaLocalId: aws.sdk.kotlin.services.iotwireless.model.CdmaLocalId? = builder.cdmaLocalId
    /**
     * CDMA network measurement reports.
     */
    public val cdmaNmr: List<CdmaNmrObj>? = builder.cdmaNmr
    /**
     * CDMA network ID (NID).
     */
    public val networkId: kotlin.Int = requireNotNull(builder.networkId) { "A non-null value must be provided for networkId" }
    /**
     * Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
     */
    public val pilotPower: kotlin.Int? = builder.pilotPower
    /**
     * CDMA registration zone (RZ).
     */
    public val registrationZone: kotlin.Int? = builder.registrationZone
    /**
     * CDMA system ID (SID).
     */
    public val systemId: kotlin.Int = requireNotNull(builder.systemId) { "A non-null value must be provided for systemId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.CdmaObj = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CdmaObj(")
        append("baseLat=$baseLat,")
        append("baseLng=$baseLng,")
        append("baseStationId=$baseStationId,")
        append("cdmaLocalId=$cdmaLocalId,")
        append("cdmaNmr=$cdmaNmr,")
        append("networkId=$networkId,")
        append("pilotPower=$pilotPower,")
        append("registrationZone=$registrationZone,")
        append("systemId=$systemId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseLat?.hashCode() ?: 0
        result = 31 * result + (baseLng?.hashCode() ?: 0)
        result = 31 * result + (baseStationId)
        result = 31 * result + (cdmaLocalId?.hashCode() ?: 0)
        result = 31 * result + (cdmaNmr?.hashCode() ?: 0)
        result = 31 * result + (networkId)
        result = 31 * result + (pilotPower ?: 0)
        result = 31 * result + (registrationZone ?: 0)
        result = 31 * result + (systemId)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CdmaObj

        if (!(baseLat?.equals(other.baseLat) ?: (other.baseLat == null))) return false
        if (!(baseLng?.equals(other.baseLng) ?: (other.baseLng == null))) return false
        if (baseStationId != other.baseStationId) return false
        if (cdmaLocalId != other.cdmaLocalId) return false
        if (cdmaNmr != other.cdmaNmr) return false
        if (networkId != other.networkId) return false
        if (pilotPower != other.pilotPower) return false
        if (registrationZone != other.registrationZone) return false
        if (systemId != other.systemId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.CdmaObj = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * CDMA base station latitude in degrees.
         */
        public var baseLat: kotlin.Float? = null
        /**
         * CDMA base station longitude in degrees.
         */
        public var baseLng: kotlin.Float? = null
        /**
         * CDMA base station ID (BSID).
         */
        public var baseStationId: kotlin.Int? = null
        /**
         * CDMA local identification (local ID) parameters.
         */
        public var cdmaLocalId: aws.sdk.kotlin.services.iotwireless.model.CdmaLocalId? = null
        /**
         * CDMA network measurement reports.
         */
        public var cdmaNmr: List<CdmaNmrObj>? = null
        /**
         * CDMA network ID (NID).
         */
        public var networkId: kotlin.Int? = null
        /**
         * Transmit power level of the pilot signal, measured in dBm (decibel-milliwatts).
         */
        public var pilotPower: kotlin.Int? = null
        /**
         * CDMA registration zone (RZ).
         */
        public var registrationZone: kotlin.Int? = null
        /**
         * CDMA system ID (SID).
         */
        public var systemId: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.CdmaObj) : this() {
            this.baseLat = x.baseLat
            this.baseLng = x.baseLng
            this.baseStationId = x.baseStationId
            this.cdmaLocalId = x.cdmaLocalId
            this.cdmaNmr = x.cdmaNmr
            this.networkId = x.networkId
            this.pilotPower = x.pilotPower
            this.registrationZone = x.registrationZone
            this.systemId = x.systemId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.CdmaObj = CdmaObj(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.CdmaLocalId] inside the given [block]
         */
        public fun cdmaLocalId(block: aws.sdk.kotlin.services.iotwireless.model.CdmaLocalId.Builder.() -> kotlin.Unit) {
            this.cdmaLocalId = aws.sdk.kotlin.services.iotwireless.model.CdmaLocalId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (baseStationId == null) baseStationId = 0
            if (networkId == null) networkId = 0
            if (systemId == null) systemId = 0
            return this
        }
    }
}
