// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartSingleWirelessDeviceImportTaskRequest private constructor(builder: Builder) {
    /**
     * Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see [Ensuring idempotency in Amazon EC2 API requests](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the Sidewalk destination that describes the IoT rule to route messages from the device in the import task that will be onboarded to AWS IoT Wireless.
     */
    public val destinationName: kotlin.String? = builder.destinationName
    /**
     * The name of the wireless device for which an import task is being started.
     */
    public val deviceName: kotlin.String? = builder.deviceName
    /**
     * The Sidewalk-related parameters for importing a single wireless device.
     */
    public val sidewalk: aws.sdk.kotlin.services.iotwireless.model.SidewalkSingleStartImportInfo? = builder.sidewalk
    /**
     * The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSingleWirelessDeviceImportTaskRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("destinationName=$destinationName,")
        append("deviceName=$deviceName,")
        append("sidewalk=$sidewalk,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (destinationName?.hashCode() ?: 0)
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (sidewalk?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSingleWirelessDeviceImportTaskRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (destinationName != other.destinationName) return false
        if (deviceName != other.deviceName) return false
        if (sidewalk != other.sidewalk) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see [Ensuring idempotency in Amazon EC2 API requests](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of the Sidewalk destination that describes the IoT rule to route messages from the device in the import task that will be onboarded to AWS IoT Wireless.
         */
        public var destinationName: kotlin.String? = null
        /**
         * The name of the wireless device for which an import task is being started.
         */
        public var deviceName: kotlin.String? = null
        /**
         * The Sidewalk-related parameters for importing a single wireless device.
         */
        public var sidewalk: aws.sdk.kotlin.services.iotwireless.model.SidewalkSingleStartImportInfo? = null
        /**
         * The tag to attach to the specified resource. Tags are metadata that you can use to manage a resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.destinationName = x.destinationName
            this.deviceName = x.deviceName
            this.sidewalk = x.sidewalk
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.StartSingleWirelessDeviceImportTaskRequest = StartSingleWirelessDeviceImportTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.SidewalkSingleStartImportInfo] inside the given [block]
         */
        public fun sidewalk(block: aws.sdk.kotlin.services.iotwireless.model.SidewalkSingleStartImportInfo.Builder.() -> kotlin.Unit) {
            this.sidewalk = aws.sdk.kotlin.services.iotwireless.model.SidewalkSingleStartImportInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
