// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateWirelessGatewayRequest private constructor(builder: Builder) {
    /**
     * Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see [Ensuring idempotency in Amazon EC2 API requests](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The description of the new resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The gateway configuration information to use to create the wireless gateway.
     */
    public val loRaWan: aws.sdk.kotlin.services.iotwireless.model.LoRaWanGateway? = builder.loRaWan
    /**
     * The name of the new resource.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWirelessGatewayRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("loRaWan=$loRaWan,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (loRaWan?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWirelessGatewayRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (loRaWan != other.loRaWan) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Each resource must have a unique client request token. The client token is used to implement idempotency. It ensures that the request completes no more than one time. If you retry a request with the same token and the same parameters, the request will complete successfully. However, if you try to create a new resource using the same token but different parameters, an HTTP 409 conflict occurs. If you omit this value, AWS SDKs will automatically generate a unique client request. For more information about idempotency, see [Ensuring idempotency in Amazon EC2 API requests](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The description of the new resource.
         */
        public var description: kotlin.String? = null
        /**
         * The gateway configuration information to use to create the wireless gateway.
         */
        public var loRaWan: aws.sdk.kotlin.services.iotwireless.model.LoRaWanGateway? = null
        /**
         * The name of the new resource.
         */
        public var name: kotlin.String? = null
        /**
         * The tags to attach to the new wireless gateway. Tags are metadata that you can use to manage a resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.loRaWan = x.loRaWan
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.CreateWirelessGatewayRequest = CreateWirelessGatewayRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.LoRaWanGateway] inside the given [block]
         */
        public fun loRaWan(block: aws.sdk.kotlin.services.iotwireless.model.LoRaWanGateway.Builder.() -> kotlin.Unit) {
            this.loRaWan = aws.sdk.kotlin.services.iotwireless.model.LoRaWanGateway.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
