// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.model



/**
 * WCDMA.
 */
public class WcdmaObj private constructor(builder: Builder) {
    /**
     * Location Area Code.
     */
    public val lac: kotlin.Int? = builder.lac
    /**
     * Mobile Country Code.
     */
    public val mcc: kotlin.Int = requireNotNull(builder.mcc) { "A non-null value must be provided for mcc" }
    /**
     * Mobile Network Code.
     */
    public val mnc: kotlin.Int = requireNotNull(builder.mnc) { "A non-null value must be provided for mnc" }
    /**
     * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates through space.
     */
    public val pathLoss: kotlin.Int? = builder.pathLoss
    /**
     * Received Signal Code Power (signal power) (dBm).
     */
    public val rscp: kotlin.Int? = builder.rscp
    /**
     * UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
     */
    public val utranCid: kotlin.Int = requireNotNull(builder.utranCid) { "A non-null value must be provided for utranCid" }
    /**
     * WCDMA local ID information.
     */
    public val wcdmaLocalId: aws.sdk.kotlin.services.iotwireless.model.WcdmaLocalId? = builder.wcdmaLocalId
    /**
     * WCDMA object for network measurement reports.
     */
    public val wcdmaNmr: List<WcdmaNmrObj>? = builder.wcdmaNmr

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotwireless.model.WcdmaObj = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WcdmaObj(")
        append("lac=$lac,")
        append("mcc=$mcc,")
        append("mnc=$mnc,")
        append("pathLoss=$pathLoss,")
        append("rscp=$rscp,")
        append("utranCid=$utranCid,")
        append("wcdmaLocalId=$wcdmaLocalId,")
        append("wcdmaNmr=$wcdmaNmr")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lac ?: 0
        result = 31 * result + (mcc)
        result = 31 * result + (mnc)
        result = 31 * result + (pathLoss ?: 0)
        result = 31 * result + (rscp ?: 0)
        result = 31 * result + (utranCid)
        result = 31 * result + (wcdmaLocalId?.hashCode() ?: 0)
        result = 31 * result + (wcdmaNmr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WcdmaObj

        if (lac != other.lac) return false
        if (mcc != other.mcc) return false
        if (mnc != other.mnc) return false
        if (pathLoss != other.pathLoss) return false
        if (rscp != other.rscp) return false
        if (utranCid != other.utranCid) return false
        if (wcdmaLocalId != other.wcdmaLocalId) return false
        if (wcdmaNmr != other.wcdmaNmr) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotwireless.model.WcdmaObj = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Location Area Code.
         */
        public var lac: kotlin.Int? = null
        /**
         * Mobile Country Code.
         */
        public var mcc: kotlin.Int? = null
        /**
         * Mobile Network Code.
         */
        public var mnc: kotlin.Int? = null
        /**
         * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates through space.
         */
        public var pathLoss: kotlin.Int? = null
        /**
         * Received Signal Code Power (signal power) (dBm).
         */
        public var rscp: kotlin.Int? = null
        /**
         * UTRAN (UMTS Terrestrial Radio Access Network) Cell Global Identifier.
         */
        public var utranCid: kotlin.Int? = null
        /**
         * WCDMA local ID information.
         */
        public var wcdmaLocalId: aws.sdk.kotlin.services.iotwireless.model.WcdmaLocalId? = null
        /**
         * WCDMA object for network measurement reports.
         */
        public var wcdmaNmr: List<WcdmaNmrObj>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotwireless.model.WcdmaObj) : this() {
            this.lac = x.lac
            this.mcc = x.mcc
            this.mnc = x.mnc
            this.pathLoss = x.pathLoss
            this.rscp = x.rscp
            this.utranCid = x.utranCid
            this.wcdmaLocalId = x.wcdmaLocalId
            this.wcdmaNmr = x.wcdmaNmr
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotwireless.model.WcdmaObj = WcdmaObj(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotwireless.model.WcdmaLocalId] inside the given [block]
         */
        public fun wcdmaLocalId(block: aws.sdk.kotlin.services.iotwireless.model.WcdmaLocalId.Builder.() -> kotlin.Unit) {
            this.wcdmaLocalId = aws.sdk.kotlin.services.iotwireless.model.WcdmaLocalId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (mcc == null) mcc = 0
            if (mnc == null) mnc = 0
            if (utranCid == null) utranCid = 0
            return this
        }
    }
}
