// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.iotwireless.auth.IotWirelessAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.iotwireless.auth.IotWirelessIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.iotwireless.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.iotwireless.model.*
import aws.sdk.kotlin.services.iotwireless.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultIotWirelessClient(override val config: IotWirelessClient.Config) : IotWirelessClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = IotWirelessIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "iotwireless")
        }
        toMap()
    }
    private val authSchemeAdapter = IotWirelessAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.iotwireless"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates a partner account with your AWS account.
     */
    override suspend fun associateAwsAccountWithPartnerAccount(input: AssociateAwsAccountWithPartnerAccountRequest): AssociateAwsAccountWithPartnerAccountResponse {
        val op = SdkHttpOperation.build<AssociateAwsAccountWithPartnerAccountRequest, AssociateAwsAccountWithPartnerAccountResponse> {
            serializer = AssociateAwsAccountWithPartnerAccountOperationSerializer()
            deserializer = AssociateAwsAccountWithPartnerAccountOperationDeserializer()
            operationName = "AssociateAwsAccountWithPartnerAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associate a multicast group with a FUOTA task.
     */
    override suspend fun associateMulticastGroupWithFuotaTask(input: AssociateMulticastGroupWithFuotaTaskRequest): AssociateMulticastGroupWithFuotaTaskResponse {
        val op = SdkHttpOperation.build<AssociateMulticastGroupWithFuotaTaskRequest, AssociateMulticastGroupWithFuotaTaskResponse> {
            serializer = AssociateMulticastGroupWithFuotaTaskOperationSerializer()
            deserializer = AssociateMulticastGroupWithFuotaTaskOperationDeserializer()
            operationName = "AssociateMulticastGroupWithFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associate a wireless device with a FUOTA task.
     */
    override suspend fun associateWirelessDeviceWithFuotaTask(input: AssociateWirelessDeviceWithFuotaTaskRequest): AssociateWirelessDeviceWithFuotaTaskResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithFuotaTaskRequest, AssociateWirelessDeviceWithFuotaTaskResponse> {
            serializer = AssociateWirelessDeviceWithFuotaTaskOperationSerializer()
            deserializer = AssociateWirelessDeviceWithFuotaTaskOperationDeserializer()
            operationName = "AssociateWirelessDeviceWithFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless device with a multicast group.
     */
    override suspend fun associateWirelessDeviceWithMulticastGroup(input: AssociateWirelessDeviceWithMulticastGroupRequest): AssociateWirelessDeviceWithMulticastGroupResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithMulticastGroupRequest, AssociateWirelessDeviceWithMulticastGroupResponse> {
            serializer = AssociateWirelessDeviceWithMulticastGroupOperationSerializer()
            deserializer = AssociateWirelessDeviceWithMulticastGroupOperationDeserializer()
            operationName = "AssociateWirelessDeviceWithMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless device with a thing.
     */
    override suspend fun associateWirelessDeviceWithThing(input: AssociateWirelessDeviceWithThingRequest): AssociateWirelessDeviceWithThingResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithThingRequest, AssociateWirelessDeviceWithThingResponse> {
            serializer = AssociateWirelessDeviceWithThingOperationSerializer()
            deserializer = AssociateWirelessDeviceWithThingOperationDeserializer()
            operationName = "AssociateWirelessDeviceWithThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless gateway with a certificate.
     */
    override suspend fun associateWirelessGatewayWithCertificate(input: AssociateWirelessGatewayWithCertificateRequest): AssociateWirelessGatewayWithCertificateResponse {
        val op = SdkHttpOperation.build<AssociateWirelessGatewayWithCertificateRequest, AssociateWirelessGatewayWithCertificateResponse> {
            serializer = AssociateWirelessGatewayWithCertificateOperationSerializer()
            deserializer = AssociateWirelessGatewayWithCertificateOperationDeserializer()
            operationName = "AssociateWirelessGatewayWithCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless gateway with a thing.
     */
    override suspend fun associateWirelessGatewayWithThing(input: AssociateWirelessGatewayWithThingRequest): AssociateWirelessGatewayWithThingResponse {
        val op = SdkHttpOperation.build<AssociateWirelessGatewayWithThingRequest, AssociateWirelessGatewayWithThingResponse> {
            serializer = AssociateWirelessGatewayWithThingOperationSerializer()
            deserializer = AssociateWirelessGatewayWithThingOperationDeserializer()
            operationName = "AssociateWirelessGatewayWithThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an existing multicast group session.
     */
    override suspend fun cancelMulticastGroupSession(input: CancelMulticastGroupSessionRequest): CancelMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<CancelMulticastGroupSessionRequest, CancelMulticastGroupSessionResponse> {
            serializer = CancelMulticastGroupSessionOperationSerializer()
            deserializer = CancelMulticastGroupSessionOperationDeserializer()
            operationName = "CancelMulticastGroupSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new destination that maps a device message to an AWS IoT rule.
     */
    override suspend fun createDestination(input: CreateDestinationRequest): CreateDestinationResponse {
        val op = SdkHttpOperation.build<CreateDestinationRequest, CreateDestinationResponse> {
            serializer = CreateDestinationOperationSerializer()
            deserializer = CreateDestinationOperationDeserializer()
            operationName = "CreateDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new device profile.
     */
    override suspend fun createDeviceProfile(input: CreateDeviceProfileRequest): CreateDeviceProfileResponse {
        val op = SdkHttpOperation.build<CreateDeviceProfileRequest, CreateDeviceProfileResponse> {
            serializer = CreateDeviceProfileOperationSerializer()
            deserializer = CreateDeviceProfileOperationDeserializer()
            operationName = "CreateDeviceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a FUOTA task.
     */
    override suspend fun createFuotaTask(input: CreateFuotaTaskRequest): CreateFuotaTaskResponse {
        val op = SdkHttpOperation.build<CreateFuotaTaskRequest, CreateFuotaTaskResponse> {
            serializer = CreateFuotaTaskOperationSerializer()
            deserializer = CreateFuotaTaskOperationDeserializer()
            operationName = "CreateFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a multicast group.
     */
    override suspend fun createMulticastGroup(input: CreateMulticastGroupRequest): CreateMulticastGroupResponse {
        val op = SdkHttpOperation.build<CreateMulticastGroupRequest, CreateMulticastGroupResponse> {
            serializer = CreateMulticastGroupOperationSerializer()
            deserializer = CreateMulticastGroupOperationDeserializer()
            operationName = "CreateMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new network analyzer configuration.
     */
    override suspend fun createNetworkAnalyzerConfiguration(input: CreateNetworkAnalyzerConfigurationRequest): CreateNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<CreateNetworkAnalyzerConfigurationRequest, CreateNetworkAnalyzerConfigurationResponse> {
            serializer = CreateNetworkAnalyzerConfigurationOperationSerializer()
            deserializer = CreateNetworkAnalyzerConfigurationOperationDeserializer()
            operationName = "CreateNetworkAnalyzerConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new service profile.
     */
    override suspend fun createServiceProfile(input: CreateServiceProfileRequest): CreateServiceProfileResponse {
        val op = SdkHttpOperation.build<CreateServiceProfileRequest, CreateServiceProfileResponse> {
            serializer = CreateServiceProfileOperationSerializer()
            deserializer = CreateServiceProfileOperationDeserializer()
            operationName = "CreateServiceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provisions a wireless device.
     */
    override suspend fun createWirelessDevice(input: CreateWirelessDeviceRequest): CreateWirelessDeviceResponse {
        val op = SdkHttpOperation.build<CreateWirelessDeviceRequest, CreateWirelessDeviceResponse> {
            serializer = CreateWirelessDeviceOperationSerializer()
            deserializer = CreateWirelessDeviceOperationDeserializer()
            operationName = "CreateWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provisions a wireless gateway.
     */
    override suspend fun createWirelessGateway(input: CreateWirelessGatewayRequest): CreateWirelessGatewayResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayRequest, CreateWirelessGatewayResponse> {
            serializer = CreateWirelessGatewayOperationSerializer()
            deserializer = CreateWirelessGatewayOperationDeserializer()
            operationName = "CreateWirelessGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a task for a wireless gateway.
     */
    override suspend fun createWirelessGatewayTask(input: CreateWirelessGatewayTaskRequest): CreateWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayTaskRequest, CreateWirelessGatewayTaskResponse> {
            serializer = CreateWirelessGatewayTaskOperationSerializer()
            deserializer = CreateWirelessGatewayTaskOperationDeserializer()
            operationName = "CreateWirelessGatewayTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a gateway task definition.
     */
    override suspend fun createWirelessGatewayTaskDefinition(input: CreateWirelessGatewayTaskDefinitionRequest): CreateWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayTaskDefinitionRequest, CreateWirelessGatewayTaskDefinitionResponse> {
            serializer = CreateWirelessGatewayTaskDefinitionOperationSerializer()
            deserializer = CreateWirelessGatewayTaskDefinitionOperationDeserializer()
            operationName = "CreateWirelessGatewayTaskDefinition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a destination.
     */
    override suspend fun deleteDestination(input: DeleteDestinationRequest): DeleteDestinationResponse {
        val op = SdkHttpOperation.build<DeleteDestinationRequest, DeleteDestinationResponse> {
            serializer = DeleteDestinationOperationSerializer()
            deserializer = DeleteDestinationOperationDeserializer()
            operationName = "DeleteDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a device profile.
     */
    override suspend fun deleteDeviceProfile(input: DeleteDeviceProfileRequest): DeleteDeviceProfileResponse {
        val op = SdkHttpOperation.build<DeleteDeviceProfileRequest, DeleteDeviceProfileResponse> {
            serializer = DeleteDeviceProfileOperationSerializer()
            deserializer = DeleteDeviceProfileOperationDeserializer()
            operationName = "DeleteDeviceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a FUOTA task.
     */
    override suspend fun deleteFuotaTask(input: DeleteFuotaTaskRequest): DeleteFuotaTaskResponse {
        val op = SdkHttpOperation.build<DeleteFuotaTaskRequest, DeleteFuotaTaskResponse> {
            serializer = DeleteFuotaTaskOperationSerializer()
            deserializer = DeleteFuotaTaskOperationDeserializer()
            operationName = "DeleteFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a multicast group if it is not in use by a fuota task.
     */
    override suspend fun deleteMulticastGroup(input: DeleteMulticastGroupRequest): DeleteMulticastGroupResponse {
        val op = SdkHttpOperation.build<DeleteMulticastGroupRequest, DeleteMulticastGroupResponse> {
            serializer = DeleteMulticastGroupOperationSerializer()
            deserializer = DeleteMulticastGroupOperationDeserializer()
            operationName = "DeleteMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a network analyzer configuration.
     */
    override suspend fun deleteNetworkAnalyzerConfiguration(input: DeleteNetworkAnalyzerConfigurationRequest): DeleteNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteNetworkAnalyzerConfigurationRequest, DeleteNetworkAnalyzerConfigurationResponse> {
            serializer = DeleteNetworkAnalyzerConfigurationOperationSerializer()
            deserializer = DeleteNetworkAnalyzerConfigurationOperationDeserializer()
            operationName = "DeleteNetworkAnalyzerConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Remove queued messages from the downlink queue.
     */
    override suspend fun deleteQueuedMessages(input: DeleteQueuedMessagesRequest): DeleteQueuedMessagesResponse {
        val op = SdkHttpOperation.build<DeleteQueuedMessagesRequest, DeleteQueuedMessagesResponse> {
            serializer = DeleteQueuedMessagesOperationSerializer()
            deserializer = DeleteQueuedMessagesOperationDeserializer()
            operationName = "DeleteQueuedMessages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a service profile.
     */
    override suspend fun deleteServiceProfile(input: DeleteServiceProfileRequest): DeleteServiceProfileResponse {
        val op = SdkHttpOperation.build<DeleteServiceProfileRequest, DeleteServiceProfileResponse> {
            serializer = DeleteServiceProfileOperationSerializer()
            deserializer = DeleteServiceProfileOperationDeserializer()
            operationName = "DeleteServiceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless device.
     */
    override suspend fun deleteWirelessDevice(input: DeleteWirelessDeviceRequest): DeleteWirelessDeviceResponse {
        val op = SdkHttpOperation.build<DeleteWirelessDeviceRequest, DeleteWirelessDeviceResponse> {
            serializer = DeleteWirelessDeviceOperationSerializer()
            deserializer = DeleteWirelessDeviceOperationDeserializer()
            operationName = "DeleteWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Delete an import task.
     */
    override suspend fun deleteWirelessDeviceImportTask(input: DeleteWirelessDeviceImportTaskRequest): DeleteWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<DeleteWirelessDeviceImportTaskRequest, DeleteWirelessDeviceImportTaskResponse> {
            serializer = DeleteWirelessDeviceImportTaskOperationSerializer()
            deserializer = DeleteWirelessDeviceImportTaskOperationDeserializer()
            operationName = "DeleteWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway.
     */
    override suspend fun deleteWirelessGateway(input: DeleteWirelessGatewayRequest): DeleteWirelessGatewayResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayRequest, DeleteWirelessGatewayResponse> {
            serializer = DeleteWirelessGatewayOperationSerializer()
            deserializer = DeleteWirelessGatewayOperationDeserializer()
            operationName = "DeleteWirelessGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway task.
     */
    override suspend fun deleteWirelessGatewayTask(input: DeleteWirelessGatewayTaskRequest): DeleteWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayTaskRequest, DeleteWirelessGatewayTaskResponse> {
            serializer = DeleteWirelessGatewayTaskOperationSerializer()
            deserializer = DeleteWirelessGatewayTaskOperationDeserializer()
            operationName = "DeleteWirelessGatewayTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.
     */
    override suspend fun deleteWirelessGatewayTaskDefinition(input: DeleteWirelessGatewayTaskDefinitionRequest): DeleteWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayTaskDefinitionRequest, DeleteWirelessGatewayTaskDefinitionResponse> {
            serializer = DeleteWirelessGatewayTaskDefinitionOperationSerializer()
            deserializer = DeleteWirelessGatewayTaskDefinitionOperationDeserializer()
            operationName = "DeleteWirelessGatewayTaskDefinition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deregister a wireless device from AWS IoT Wireless.
     */
    override suspend fun deregisterWirelessDevice(input: DeregisterWirelessDeviceRequest): DeregisterWirelessDeviceResponse {
        val op = SdkHttpOperation.build<DeregisterWirelessDeviceRequest, DeregisterWirelessDeviceResponse> {
            serializer = DeregisterWirelessDeviceOperationSerializer()
            deserializer = DeregisterWirelessDeviceOperationDeserializer()
            operationName = "DeregisterWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates your AWS account from a partner account. If `PartnerAccountId` and `PartnerType` are `null`, disassociates your AWS account from all partner accounts.
     */
    override suspend fun disassociateAwsAccountFromPartnerAccount(input: DisassociateAwsAccountFromPartnerAccountRequest): DisassociateAwsAccountFromPartnerAccountResponse {
        val op = SdkHttpOperation.build<DisassociateAwsAccountFromPartnerAccountRequest, DisassociateAwsAccountFromPartnerAccountResponse> {
            serializer = DisassociateAwsAccountFromPartnerAccountOperationSerializer()
            deserializer = DisassociateAwsAccountFromPartnerAccountOperationDeserializer()
            operationName = "DisassociateAwsAccountFromPartnerAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a multicast group from a fuota task.
     */
    override suspend fun disassociateMulticastGroupFromFuotaTask(input: DisassociateMulticastGroupFromFuotaTaskRequest): DisassociateMulticastGroupFromFuotaTaskResponse {
        val op = SdkHttpOperation.build<DisassociateMulticastGroupFromFuotaTaskRequest, DisassociateMulticastGroupFromFuotaTaskResponse> {
            serializer = DisassociateMulticastGroupFromFuotaTaskOperationSerializer()
            deserializer = DisassociateMulticastGroupFromFuotaTaskOperationDeserializer()
            operationName = "DisassociateMulticastGroupFromFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from a FUOTA task.
     */
    override suspend fun disassociateWirelessDeviceFromFuotaTask(input: DisassociateWirelessDeviceFromFuotaTaskRequest): DisassociateWirelessDeviceFromFuotaTaskResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromFuotaTaskRequest, DisassociateWirelessDeviceFromFuotaTaskResponse> {
            serializer = DisassociateWirelessDeviceFromFuotaTaskOperationSerializer()
            deserializer = DisassociateWirelessDeviceFromFuotaTaskOperationDeserializer()
            operationName = "DisassociateWirelessDeviceFromFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from a multicast group.
     */
    override suspend fun disassociateWirelessDeviceFromMulticastGroup(input: DisassociateWirelessDeviceFromMulticastGroupRequest): DisassociateWirelessDeviceFromMulticastGroupResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromMulticastGroupRequest, DisassociateWirelessDeviceFromMulticastGroupResponse> {
            serializer = DisassociateWirelessDeviceFromMulticastGroupOperationSerializer()
            deserializer = DisassociateWirelessDeviceFromMulticastGroupOperationDeserializer()
            operationName = "DisassociateWirelessDeviceFromMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from its currently associated thing.
     */
    override suspend fun disassociateWirelessDeviceFromThing(input: DisassociateWirelessDeviceFromThingRequest): DisassociateWirelessDeviceFromThingResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromThingRequest, DisassociateWirelessDeviceFromThingResponse> {
            serializer = DisassociateWirelessDeviceFromThingOperationSerializer()
            deserializer = DisassociateWirelessDeviceFromThingOperationDeserializer()
            operationName = "DisassociateWirelessDeviceFromThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless gateway from its currently associated certificate.
     */
    override suspend fun disassociateWirelessGatewayFromCertificate(input: DisassociateWirelessGatewayFromCertificateRequest): DisassociateWirelessGatewayFromCertificateResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessGatewayFromCertificateRequest, DisassociateWirelessGatewayFromCertificateResponse> {
            serializer = DisassociateWirelessGatewayFromCertificateOperationSerializer()
            deserializer = DisassociateWirelessGatewayFromCertificateOperationDeserializer()
            operationName = "DisassociateWirelessGatewayFromCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless gateway from its currently associated thing.
     */
    override suspend fun disassociateWirelessGatewayFromThing(input: DisassociateWirelessGatewayFromThingRequest): DisassociateWirelessGatewayFromThingResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessGatewayFromThingRequest, DisassociateWirelessGatewayFromThingResponse> {
            serializer = DisassociateWirelessGatewayFromThingOperationSerializer()
            deserializer = DisassociateWirelessGatewayFromThingOperationDeserializer()
            operationName = "DisassociateWirelessGatewayFromThing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a destination.
     */
    override suspend fun getDestination(input: GetDestinationRequest): GetDestinationResponse {
        val op = SdkHttpOperation.build<GetDestinationRequest, GetDestinationResponse> {
            serializer = GetDestinationOperationSerializer()
            deserializer = GetDestinationOperationDeserializer()
            operationName = "GetDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a device profile.
     */
    override suspend fun getDeviceProfile(input: GetDeviceProfileRequest): GetDeviceProfileResponse {
        val op = SdkHttpOperation.build<GetDeviceProfileRequest, GetDeviceProfileResponse> {
            serializer = GetDeviceProfileOperationSerializer()
            deserializer = GetDeviceProfileOperationDeserializer()
            operationName = "GetDeviceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the event configuration based on resource types.
     */
    override suspend fun getEventConfigurationByResourceTypes(input: GetEventConfigurationByResourceTypesRequest): GetEventConfigurationByResourceTypesResponse {
        val op = SdkHttpOperation.build<GetEventConfigurationByResourceTypesRequest, GetEventConfigurationByResourceTypesResponse> {
            serializer = GetEventConfigurationByResourceTypesOperationSerializer()
            deserializer = GetEventConfigurationByResourceTypesOperationDeserializer()
            operationName = "GetEventConfigurationByResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a FUOTA task.
     */
    override suspend fun getFuotaTask(input: GetFuotaTaskRequest): GetFuotaTaskResponse {
        val op = SdkHttpOperation.build<GetFuotaTaskRequest, GetFuotaTaskResponse> {
            serializer = GetFuotaTaskOperationSerializer()
            deserializer = GetFuotaTaskOperationDeserializer()
            operationName = "GetFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.
     */
    override suspend fun getLogLevelsByResourceTypes(input: GetLogLevelsByResourceTypesRequest): GetLogLevelsByResourceTypesResponse {
        val op = SdkHttpOperation.build<GetLogLevelsByResourceTypesRequest, GetLogLevelsByResourceTypesResponse> {
            serializer = GetLogLevelsByResourceTypesOperationSerializer()
            deserializer = GetLogLevelsByResourceTypesOperationDeserializer()
            operationName = "GetLogLevelsByResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a multicast group.
     */
    override suspend fun getMulticastGroup(input: GetMulticastGroupRequest): GetMulticastGroupResponse {
        val op = SdkHttpOperation.build<GetMulticastGroupRequest, GetMulticastGroupResponse> {
            serializer = GetMulticastGroupOperationSerializer()
            deserializer = GetMulticastGroupOperationDeserializer()
            operationName = "GetMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a multicast group session.
     */
    override suspend fun getMulticastGroupSession(input: GetMulticastGroupSessionRequest): GetMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<GetMulticastGroupSessionRequest, GetMulticastGroupSessionResponse> {
            serializer = GetMulticastGroupSessionOperationSerializer()
            deserializer = GetMulticastGroupSessionOperationDeserializer()
            operationName = "GetMulticastGroupSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get network analyzer configuration.
     */
    override suspend fun getNetworkAnalyzerConfiguration(input: GetNetworkAnalyzerConfigurationRequest): GetNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<GetNetworkAnalyzerConfigurationRequest, GetNetworkAnalyzerConfigurationResponse> {
            serializer = GetNetworkAnalyzerConfigurationOperationSerializer()
            deserializer = GetNetworkAnalyzerConfigurationOperationDeserializer()
            operationName = "GetNetworkAnalyzerConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a partner account. If `PartnerAccountId` and `PartnerType` are `null`, returns all partner accounts.
     */
    override suspend fun getPartnerAccount(input: GetPartnerAccountRequest): GetPartnerAccountResponse {
        val op = SdkHttpOperation.build<GetPartnerAccountRequest, GetPartnerAccountResponse> {
            serializer = GetPartnerAccountOperationSerializer()
            deserializer = GetPartnerAccountOperationDeserializer()
            operationName = "GetPartnerAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the position information for a given resource.
     *
     * This action is no longer supported. Calls to retrieve the position information should use the [GetResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html) API operation instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getPosition(input: GetPositionRequest): GetPositionResponse {
        val op = SdkHttpOperation.build<GetPositionRequest, GetPositionResponse> {
            serializer = GetPositionOperationSerializer()
            deserializer = GetPositionOperationDeserializer()
            operationName = "GetPosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get position configuration for a given resource.
     *
     * This action is no longer supported. Calls to retrieve the position configuration should use the [GetResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html) API operation instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getPositionConfiguration(input: GetPositionConfigurationRequest): GetPositionConfigurationResponse {
        val op = SdkHttpOperation.build<GetPositionConfigurationRequest, GetPositionConfigurationResponse> {
            serializer = GetPositionConfigurationOperationSerializer()
            deserializer = GetPositionConfigurationOperationDeserializer()
            operationName = "GetPositionConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get estimated position information as a payload in GeoJSON format. The payload measurement data is resolved using solvers that are provided by third-party vendors.
     */
    override suspend fun getPositionEstimate(input: GetPositionEstimateRequest): GetPositionEstimateResponse {
        val op = SdkHttpOperation.build<GetPositionEstimateRequest, GetPositionEstimateResponse> {
            serializer = GetPositionEstimateOperationSerializer()
            deserializer = GetPositionEstimateOperationDeserializer()
            operationName = "GetPositionEstimate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the event configuration for a particular resource identifier.
     */
    override suspend fun getResourceEventConfiguration(input: GetResourceEventConfigurationRequest): GetResourceEventConfigurationResponse {
        val op = SdkHttpOperation.build<GetResourceEventConfigurationRequest, GetResourceEventConfigurationResponse> {
            serializer = GetResourceEventConfigurationOperationSerializer()
            deserializer = GetResourceEventConfigurationOperationDeserializer()
            operationName = "GetResourceEventConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    override suspend fun getResourceLogLevel(input: GetResourceLogLevelRequest): GetResourceLogLevelResponse {
        val op = SdkHttpOperation.build<GetResourceLogLevelRequest, GetResourceLogLevelResponse> {
            serializer = GetResourceLogLevelOperationSerializer()
            deserializer = GetResourceLogLevelOperationDeserializer()
            operationName = "GetResourceLogLevel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the position information for a given wireless device or a wireless gateway resource. The position information uses the [ World Geodetic System (WGS84)](https://gisgeography.com/wgs84-world-geodetic-system/).
     */
    override suspend fun getResourcePosition(input: GetResourcePositionRequest): GetResourcePositionResponse {
        val op = SdkHttpOperation.build<GetResourcePositionRequest, GetResourcePositionResponse> {
            serializer = GetResourcePositionOperationSerializer()
            deserializer = GetResourcePositionOperationDeserializer()
            operationName = "GetResourcePosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.
     */
    override suspend fun getServiceEndpoint(input: GetServiceEndpointRequest): GetServiceEndpointResponse {
        val op = SdkHttpOperation.build<GetServiceEndpointRequest, GetServiceEndpointResponse> {
            serializer = GetServiceEndpointOperationSerializer()
            deserializer = GetServiceEndpointOperationDeserializer()
            operationName = "GetServiceEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a service profile.
     */
    override suspend fun getServiceProfile(input: GetServiceProfileRequest): GetServiceProfileResponse {
        val op = SdkHttpOperation.build<GetServiceProfileRequest, GetServiceProfileResponse> {
            serializer = GetServiceProfileOperationSerializer()
            deserializer = GetServiceProfileOperationDeserializer()
            operationName = "GetServiceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless device.
     */
    override suspend fun getWirelessDevice(input: GetWirelessDeviceRequest): GetWirelessDeviceResponse {
        val op = SdkHttpOperation.build<GetWirelessDeviceRequest, GetWirelessDeviceResponse> {
            serializer = GetWirelessDeviceOperationSerializer()
            deserializer = GetWirelessDeviceOperationDeserializer()
            operationName = "GetWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get information about an import task and count of device onboarding summary information for the import task.
     */
    override suspend fun getWirelessDeviceImportTask(input: GetWirelessDeviceImportTaskRequest): GetWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<GetWirelessDeviceImportTaskRequest, GetWirelessDeviceImportTaskResponse> {
            serializer = GetWirelessDeviceImportTaskOperationSerializer()
            deserializer = GetWirelessDeviceImportTaskOperationDeserializer()
            operationName = "GetWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets operating information about a wireless device.
     */
    override suspend fun getWirelessDeviceStatistics(input: GetWirelessDeviceStatisticsRequest): GetWirelessDeviceStatisticsResponse {
        val op = SdkHttpOperation.build<GetWirelessDeviceStatisticsRequest, GetWirelessDeviceStatisticsResponse> {
            serializer = GetWirelessDeviceStatisticsOperationSerializer()
            deserializer = GetWirelessDeviceStatisticsOperationDeserializer()
            operationName = "GetWirelessDeviceStatistics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway.
     */
    override suspend fun getWirelessGateway(input: GetWirelessGatewayRequest): GetWirelessGatewayResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayRequest, GetWirelessGatewayResponse> {
            serializer = GetWirelessGatewayOperationSerializer()
            deserializer = GetWirelessGatewayOperationDeserializer()
            operationName = "GetWirelessGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     */
    override suspend fun getWirelessGatewayCertificate(input: GetWirelessGatewayCertificateRequest): GetWirelessGatewayCertificateResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayCertificateRequest, GetWirelessGatewayCertificateResponse> {
            serializer = GetWirelessGatewayCertificateOperationSerializer()
            deserializer = GetWirelessGatewayCertificateOperationDeserializer()
            operationName = "GetWirelessGatewayCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the firmware version and other information about a wireless gateway.
     */
    override suspend fun getWirelessGatewayFirmwareInformation(input: GetWirelessGatewayFirmwareInformationRequest): GetWirelessGatewayFirmwareInformationResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayFirmwareInformationRequest, GetWirelessGatewayFirmwareInformationResponse> {
            serializer = GetWirelessGatewayFirmwareInformationOperationSerializer()
            deserializer = GetWirelessGatewayFirmwareInformationOperationDeserializer()
            operationName = "GetWirelessGatewayFirmwareInformation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets operating information about a wireless gateway.
     */
    override suspend fun getWirelessGatewayStatistics(input: GetWirelessGatewayStatisticsRequest): GetWirelessGatewayStatisticsResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayStatisticsRequest, GetWirelessGatewayStatisticsResponse> {
            serializer = GetWirelessGatewayStatisticsOperationSerializer()
            deserializer = GetWirelessGatewayStatisticsOperationDeserializer()
            operationName = "GetWirelessGatewayStatistics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway task.
     */
    override suspend fun getWirelessGatewayTask(input: GetWirelessGatewayTaskRequest): GetWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayTaskRequest, GetWirelessGatewayTaskResponse> {
            serializer = GetWirelessGatewayTaskOperationSerializer()
            deserializer = GetWirelessGatewayTaskOperationDeserializer()
            operationName = "GetWirelessGatewayTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway task definition.
     */
    override suspend fun getWirelessGatewayTaskDefinition(input: GetWirelessGatewayTaskDefinitionRequest): GetWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayTaskDefinitionRequest, GetWirelessGatewayTaskDefinitionResponse> {
            serializer = GetWirelessGatewayTaskDefinitionOperationSerializer()
            deserializer = GetWirelessGatewayTaskDefinitionOperationDeserializer()
            operationName = "GetWirelessGatewayTaskDefinition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the destinations registered to your AWS account.
     */
    override suspend fun listDestinations(input: ListDestinationsRequest): ListDestinationsResponse {
        val op = SdkHttpOperation.build<ListDestinationsRequest, ListDestinationsResponse> {
            serializer = ListDestinationsOperationSerializer()
            deserializer = ListDestinationsOperationDeserializer()
            operationName = "ListDestinations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the device profiles registered to your AWS account.
     */
    override suspend fun listDeviceProfiles(input: ListDeviceProfilesRequest): ListDeviceProfilesResponse {
        val op = SdkHttpOperation.build<ListDeviceProfilesRequest, ListDeviceProfilesResponse> {
            serializer = ListDeviceProfilesOperationSerializer()
            deserializer = ListDeviceProfilesOperationDeserializer()
            operationName = "ListDeviceProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List the Sidewalk devices in an import task and their onboarding status.
     */
    override suspend fun listDevicesForWirelessDeviceImportTask(input: ListDevicesForWirelessDeviceImportTaskRequest): ListDevicesForWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<ListDevicesForWirelessDeviceImportTaskRequest, ListDevicesForWirelessDeviceImportTaskResponse> {
            serializer = ListDevicesForWirelessDeviceImportTaskOperationSerializer()
            deserializer = ListDevicesForWirelessDeviceImportTaskOperationDeserializer()
            operationName = "ListDevicesForWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List event configurations where at least one event topic has been enabled.
     */
    override suspend fun listEventConfigurations(input: ListEventConfigurationsRequest): ListEventConfigurationsResponse {
        val op = SdkHttpOperation.build<ListEventConfigurationsRequest, ListEventConfigurationsResponse> {
            serializer = ListEventConfigurationsOperationSerializer()
            deserializer = ListEventConfigurationsOperationDeserializer()
            operationName = "ListEventConfigurations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the FUOTA tasks registered to your AWS account.
     */
    override suspend fun listFuotaTasks(input: ListFuotaTasksRequest): ListFuotaTasksResponse {
        val op = SdkHttpOperation.build<ListFuotaTasksRequest, ListFuotaTasksResponse> {
            serializer = ListFuotaTasksOperationSerializer()
            deserializer = ListFuotaTasksOperationDeserializer()
            operationName = "ListFuotaTasks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the multicast groups registered to your AWS account.
     */
    override suspend fun listMulticastGroups(input: ListMulticastGroupsRequest): ListMulticastGroupsResponse {
        val op = SdkHttpOperation.build<ListMulticastGroupsRequest, ListMulticastGroupsResponse> {
            serializer = ListMulticastGroupsOperationSerializer()
            deserializer = ListMulticastGroupsOperationDeserializer()
            operationName = "ListMulticastGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List all multicast groups associated with a fuota task.
     */
    override suspend fun listMulticastGroupsByFuotaTask(input: ListMulticastGroupsByFuotaTaskRequest): ListMulticastGroupsByFuotaTaskResponse {
        val op = SdkHttpOperation.build<ListMulticastGroupsByFuotaTaskRequest, ListMulticastGroupsByFuotaTaskResponse> {
            serializer = ListMulticastGroupsByFuotaTaskOperationSerializer()
            deserializer = ListMulticastGroupsByFuotaTaskOperationDeserializer()
            operationName = "ListMulticastGroupsByFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the network analyzer configurations.
     */
    override suspend fun listNetworkAnalyzerConfigurations(input: ListNetworkAnalyzerConfigurationsRequest): ListNetworkAnalyzerConfigurationsResponse {
        val op = SdkHttpOperation.build<ListNetworkAnalyzerConfigurationsRequest, ListNetworkAnalyzerConfigurationsResponse> {
            serializer = ListNetworkAnalyzerConfigurationsOperationSerializer()
            deserializer = ListNetworkAnalyzerConfigurationsOperationDeserializer()
            operationName = "ListNetworkAnalyzerConfigurations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the partner accounts associated with your AWS account.
     */
    override suspend fun listPartnerAccounts(input: ListPartnerAccountsRequest): ListPartnerAccountsResponse {
        val op = SdkHttpOperation.build<ListPartnerAccountsRequest, ListPartnerAccountsResponse> {
            serializer = ListPartnerAccountsOperationSerializer()
            deserializer = ListPartnerAccountsOperationDeserializer()
            operationName = "ListPartnerAccounts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List position configurations for a given resource, such as positioning solvers.
     *
     * This action is no longer supported. Calls to retrieve position information should use the [GetResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourcePosition.html) API operation instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listPositionConfigurations(input: ListPositionConfigurationsRequest): ListPositionConfigurationsResponse {
        val op = SdkHttpOperation.build<ListPositionConfigurationsRequest, ListPositionConfigurationsResponse> {
            serializer = ListPositionConfigurationsOperationSerializer()
            deserializer = ListPositionConfigurationsOperationDeserializer()
            operationName = "ListPositionConfigurations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List queued messages in the downlink queue.
     */
    override suspend fun listQueuedMessages(input: ListQueuedMessagesRequest): ListQueuedMessagesResponse {
        val op = SdkHttpOperation.build<ListQueuedMessagesRequest, ListQueuedMessagesResponse> {
            serializer = ListQueuedMessagesOperationSerializer()
            deserializer = ListQueuedMessagesOperationDeserializer()
            operationName = "ListQueuedMessages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the service profiles registered to your AWS account.
     */
    override suspend fun listServiceProfiles(input: ListServiceProfilesRequest): ListServiceProfilesResponse {
        val op = SdkHttpOperation.build<ListServiceProfilesRequest, ListServiceProfilesResponse> {
            serializer = ListServiceProfilesOperationSerializer()
            deserializer = ListServiceProfilesOperationDeserializer()
            operationName = "ListServiceProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List wireless devices that have been added to an import task.
     */
    override suspend fun listWirelessDeviceImportTasks(input: ListWirelessDeviceImportTasksRequest): ListWirelessDeviceImportTasksResponse {
        val op = SdkHttpOperation.build<ListWirelessDeviceImportTasksRequest, ListWirelessDeviceImportTasksResponse> {
            serializer = ListWirelessDeviceImportTasksOperationSerializer()
            deserializer = ListWirelessDeviceImportTasksOperationDeserializer()
            operationName = "ListWirelessDeviceImportTasks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the wireless devices registered to your AWS account.
     */
    override suspend fun listWirelessDevices(input: ListWirelessDevicesRequest): ListWirelessDevicesResponse {
        val op = SdkHttpOperation.build<ListWirelessDevicesRequest, ListWirelessDevicesResponse> {
            serializer = ListWirelessDevicesOperationSerializer()
            deserializer = ListWirelessDevicesOperationDeserializer()
            operationName = "ListWirelessDevices"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List the wireless gateway tasks definitions registered to your AWS account.
     */
    override suspend fun listWirelessGatewayTaskDefinitions(input: ListWirelessGatewayTaskDefinitionsRequest): ListWirelessGatewayTaskDefinitionsResponse {
        val op = SdkHttpOperation.build<ListWirelessGatewayTaskDefinitionsRequest, ListWirelessGatewayTaskDefinitionsResponse> {
            serializer = ListWirelessGatewayTaskDefinitionsOperationSerializer()
            deserializer = ListWirelessGatewayTaskDefinitionsOperationDeserializer()
            operationName = "ListWirelessGatewayTaskDefinitions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the wireless gateways registered to your AWS account.
     */
    override suspend fun listWirelessGateways(input: ListWirelessGatewaysRequest): ListWirelessGatewaysResponse {
        val op = SdkHttpOperation.build<ListWirelessGatewaysRequest, ListWirelessGatewaysResponse> {
            serializer = ListWirelessGatewaysOperationSerializer()
            deserializer = ListWirelessGatewaysOperationDeserializer()
            operationName = "ListWirelessGateways"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Put position configuration for a given resource.
     *
     * This action is no longer supported. Calls to update the position configuration should use the [UpdateResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html) API operation instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun putPositionConfiguration(input: PutPositionConfigurationRequest): PutPositionConfigurationResponse {
        val op = SdkHttpOperation.build<PutPositionConfigurationRequest, PutPositionConfigurationResponse> {
            serializer = PutPositionConfigurationOperationSerializer()
            deserializer = PutPositionConfigurationOperationDeserializer()
            operationName = "PutPositionConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.
     */
    override suspend fun putResourceLogLevel(input: PutResourceLogLevelRequest): PutResourceLogLevelResponse {
        val op = SdkHttpOperation.build<PutResourceLogLevelRequest, PutResourceLogLevelResponse> {
            serializer = PutResourceLogLevelOperationSerializer()
            deserializer = PutResourceLogLevelOperationDeserializer()
            operationName = "PutResourceLogLevel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     */
    override suspend fun resetAllResourceLogLevels(input: ResetAllResourceLogLevelsRequest): ResetAllResourceLogLevelsResponse {
        val op = SdkHttpOperation.build<ResetAllResourceLogLevelsRequest, ResetAllResourceLogLevelsResponse> {
            serializer = ResetAllResourceLogLevelsOperationSerializer()
            deserializer = ResetAllResourceLogLevelsOperationDeserializer()
            operationName = "ResetAllResourceLogLevels"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    override suspend fun resetResourceLogLevel(input: ResetResourceLogLevelRequest): ResetResourceLogLevelResponse {
        val op = SdkHttpOperation.build<ResetResourceLogLevelRequest, ResetResourceLogLevelResponse> {
            serializer = ResetResourceLogLevelOperationSerializer()
            deserializer = ResetResourceLogLevelOperationDeserializer()
            operationName = "ResetResourceLogLevel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sends the specified data to a multicast group.
     */
    override suspend fun sendDataToMulticastGroup(input: SendDataToMulticastGroupRequest): SendDataToMulticastGroupResponse {
        val op = SdkHttpOperation.build<SendDataToMulticastGroupRequest, SendDataToMulticastGroupResponse> {
            serializer = SendDataToMulticastGroupOperationSerializer()
            deserializer = SendDataToMulticastGroupOperationDeserializer()
            operationName = "SendDataToMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sends a decrypted application data frame to a device.
     */
    override suspend fun sendDataToWirelessDevice(input: SendDataToWirelessDeviceRequest): SendDataToWirelessDeviceResponse {
        val op = SdkHttpOperation.build<SendDataToWirelessDeviceRequest, SendDataToWirelessDeviceResponse> {
            serializer = SendDataToWirelessDeviceOperationSerializer()
            deserializer = SendDataToWirelessDeviceOperationDeserializer()
            operationName = "SendDataToWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     */
    override suspend fun startBulkAssociateWirelessDeviceWithMulticastGroup(input: StartBulkAssociateWirelessDeviceWithMulticastGroupRequest): StartBulkAssociateWirelessDeviceWithMulticastGroupResponse {
        val op = SdkHttpOperation.build<StartBulkAssociateWirelessDeviceWithMulticastGroupRequest, StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> {
            serializer = StartBulkAssociateWirelessDeviceWithMulticastGroupOperationSerializer()
            deserializer = StartBulkAssociateWirelessDeviceWithMulticastGroupOperationDeserializer()
            operationName = "StartBulkAssociateWirelessDeviceWithMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     */
    override suspend fun startBulkDisassociateWirelessDeviceFromMulticastGroup(input: StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest): StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse {
        val op = SdkHttpOperation.build<StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest, StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> {
            serializer = StartBulkDisassociateWirelessDeviceFromMulticastGroupOperationSerializer()
            deserializer = StartBulkDisassociateWirelessDeviceFromMulticastGroupOperationDeserializer()
            operationName = "StartBulkDisassociateWirelessDeviceFromMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a FUOTA task.
     */
    override suspend fun startFuotaTask(input: StartFuotaTaskRequest): StartFuotaTaskResponse {
        val op = SdkHttpOperation.build<StartFuotaTaskRequest, StartFuotaTaskResponse> {
            serializer = StartFuotaTaskOperationSerializer()
            deserializer = StartFuotaTaskOperationDeserializer()
            operationName = "StartFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a multicast group session.
     */
    override suspend fun startMulticastGroupSession(input: StartMulticastGroupSessionRequest): StartMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<StartMulticastGroupSessionRequest, StartMulticastGroupSessionResponse> {
            serializer = StartMulticastGroupSessionOperationSerializer()
            deserializer = StartMulticastGroupSessionOperationDeserializer()
            operationName = "StartMulticastGroupSession"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Start import task for a single wireless device.
     */
    override suspend fun startSingleWirelessDeviceImportTask(input: StartSingleWirelessDeviceImportTaskRequest): StartSingleWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<StartSingleWirelessDeviceImportTaskRequest, StartSingleWirelessDeviceImportTaskResponse> {
            serializer = StartSingleWirelessDeviceImportTaskOperationSerializer()
            deserializer = StartSingleWirelessDeviceImportTaskOperationDeserializer()
            operationName = "StartSingleWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Start import task for provisioning Sidewalk devices in bulk using an S3 CSV file.
     */
    override suspend fun startWirelessDeviceImportTask(input: StartWirelessDeviceImportTaskRequest): StartWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<StartWirelessDeviceImportTaskRequest, StartWirelessDeviceImportTaskResponse> {
            serializer = StartWirelessDeviceImportTaskOperationSerializer()
            deserializer = StartWirelessDeviceImportTaskOperationDeserializer()
            operationName = "StartWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a tag to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Simulates a provisioned device by sending an uplink data payload of `Hello`.
     */
    override suspend fun testWirelessDevice(input: TestWirelessDeviceRequest): TestWirelessDeviceResponse {
        val op = SdkHttpOperation.build<TestWirelessDeviceRequest, TestWirelessDeviceResponse> {
            serializer = TestWirelessDeviceOperationSerializer()
            deserializer = TestWirelessDeviceOperationDeserializer()
            operationName = "TestWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a destination.
     */
    override suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse {
        val op = SdkHttpOperation.build<UpdateDestinationRequest, UpdateDestinationResponse> {
            serializer = UpdateDestinationOperationSerializer()
            deserializer = UpdateDestinationOperationDeserializer()
            operationName = "UpdateDestination"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the event configuration based on resource types.
     */
    override suspend fun updateEventConfigurationByResourceTypes(input: UpdateEventConfigurationByResourceTypesRequest): UpdateEventConfigurationByResourceTypesResponse {
        val op = SdkHttpOperation.build<UpdateEventConfigurationByResourceTypesRequest, UpdateEventConfigurationByResourceTypesResponse> {
            serializer = UpdateEventConfigurationByResourceTypesOperationSerializer()
            deserializer = UpdateEventConfigurationByResourceTypesOperationDeserializer()
            operationName = "UpdateEventConfigurationByResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a FUOTA task.
     */
    override suspend fun updateFuotaTask(input: UpdateFuotaTaskRequest): UpdateFuotaTaskResponse {
        val op = SdkHttpOperation.build<UpdateFuotaTaskRequest, UpdateFuotaTaskResponse> {
            serializer = UpdateFuotaTaskOperationSerializer()
            deserializer = UpdateFuotaTaskOperationDeserializer()
            operationName = "UpdateFuotaTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     */
    override suspend fun updateLogLevelsByResourceTypes(input: UpdateLogLevelsByResourceTypesRequest): UpdateLogLevelsByResourceTypesResponse {
        val op = SdkHttpOperation.build<UpdateLogLevelsByResourceTypesRequest, UpdateLogLevelsByResourceTypesResponse> {
            serializer = UpdateLogLevelsByResourceTypesOperationSerializer()
            deserializer = UpdateLogLevelsByResourceTypesOperationDeserializer()
            operationName = "UpdateLogLevelsByResourceTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a multicast group session.
     */
    override suspend fun updateMulticastGroup(input: UpdateMulticastGroupRequest): UpdateMulticastGroupResponse {
        val op = SdkHttpOperation.build<UpdateMulticastGroupRequest, UpdateMulticastGroupResponse> {
            serializer = UpdateMulticastGroupOperationSerializer()
            deserializer = UpdateMulticastGroupOperationDeserializer()
            operationName = "UpdateMulticastGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update network analyzer configuration.
     */
    override suspend fun updateNetworkAnalyzerConfiguration(input: UpdateNetworkAnalyzerConfigurationRequest): UpdateNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateNetworkAnalyzerConfigurationRequest, UpdateNetworkAnalyzerConfigurationResponse> {
            serializer = UpdateNetworkAnalyzerConfigurationOperationSerializer()
            deserializer = UpdateNetworkAnalyzerConfigurationOperationDeserializer()
            operationName = "UpdateNetworkAnalyzerConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a partner account.
     */
    override suspend fun updatePartnerAccount(input: UpdatePartnerAccountRequest): UpdatePartnerAccountResponse {
        val op = SdkHttpOperation.build<UpdatePartnerAccountRequest, UpdatePartnerAccountResponse> {
            serializer = UpdatePartnerAccountOperationSerializer()
            deserializer = UpdatePartnerAccountOperationDeserializer()
            operationName = "UpdatePartnerAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the position information of a resource.
     *
     * This action is no longer supported. Calls to update the position information should use the [UpdateResourcePosition](https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourcePosition.html) API operation instead.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun updatePosition(input: UpdatePositionRequest): UpdatePositionResponse {
        val op = SdkHttpOperation.build<UpdatePositionRequest, UpdatePositionResponse> {
            serializer = UpdatePositionOperationSerializer()
            deserializer = UpdatePositionOperationDeserializer()
            operationName = "UpdatePosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the event configuration for a particular resource identifier.
     */
    override suspend fun updateResourceEventConfiguration(input: UpdateResourceEventConfigurationRequest): UpdateResourceEventConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateResourceEventConfigurationRequest, UpdateResourceEventConfigurationResponse> {
            serializer = UpdateResourceEventConfigurationOperationSerializer()
            deserializer = UpdateResourceEventConfigurationOperationDeserializer()
            operationName = "UpdateResourceEventConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the position information of a given wireless device or a wireless gateway resource. The position coordinates are based on the [ World Geodetic System (WGS84)](https://gisgeography.com/wgs84-world-geodetic-system/).
     */
    override suspend fun updateResourcePosition(input: UpdateResourcePositionRequest): UpdateResourcePositionResponse {
        val op = SdkHttpOperation.build<UpdateResourcePositionRequest, UpdateResourcePositionResponse> {
            serializer = UpdateResourcePositionOperationSerializer()
            deserializer = UpdateResourcePositionOperationDeserializer()
            operationName = "UpdateResourcePosition"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a wireless device.
     */
    override suspend fun updateWirelessDevice(input: UpdateWirelessDeviceRequest): UpdateWirelessDeviceResponse {
        val op = SdkHttpOperation.build<UpdateWirelessDeviceRequest, UpdateWirelessDeviceResponse> {
            serializer = UpdateWirelessDeviceOperationSerializer()
            deserializer = UpdateWirelessDeviceOperationDeserializer()
            operationName = "UpdateWirelessDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update an import task to add more devices to the task.
     */
    override suspend fun updateWirelessDeviceImportTask(input: UpdateWirelessDeviceImportTaskRequest): UpdateWirelessDeviceImportTaskResponse {
        val op = SdkHttpOperation.build<UpdateWirelessDeviceImportTaskRequest, UpdateWirelessDeviceImportTaskResponse> {
            serializer = UpdateWirelessDeviceImportTaskOperationSerializer()
            deserializer = UpdateWirelessDeviceImportTaskOperationDeserializer()
            operationName = "UpdateWirelessDeviceImportTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a wireless gateway.
     */
    override suspend fun updateWirelessGateway(input: UpdateWirelessGatewayRequest): UpdateWirelessGatewayResponse {
        val op = SdkHttpOperation.build<UpdateWirelessGatewayRequest, UpdateWirelessGatewayResponse> {
            serializer = UpdateWirelessGatewayOperationSerializer()
            deserializer = UpdateWirelessGatewayOperationDeserializer()
            operationName = "UpdateWirelessGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotwireless")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
