// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless.serde

import aws.sdk.kotlin.services.iotwireless.model.GetWirelessDeviceImportTaskResponse
import aws.sdk.kotlin.services.iotwireless.model.ImportTaskStatus
import aws.sdk.kotlin.services.iotwireless.model.IotWirelessException
import aws.sdk.kotlin.services.iotwireless.model.SidewalkGetStartImportInfo
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetWirelessDeviceImportTaskOperationDeserializer: HttpDeserialize<GetWirelessDeviceImportTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetWirelessDeviceImportTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetWirelessDeviceImportTaskError(context, call)
        }
        val builder = GetWirelessDeviceImportTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWirelessDeviceImportTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetWirelessDeviceImportTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotWirelessException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotWirelessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWirelessDeviceImportTaskOperationBody(builder: GetWirelessDeviceImportTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESTINATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DestinationName"))
    val FAILEDIMPORTEDDEVICECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FailedImportedDeviceCount"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val INITIALIZEDIMPORTEDDEVICECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("InitializedImportedDeviceCount"))
    val ONBOARDEDIMPORTEDDEVICECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("OnboardedImportedDeviceCount"))
    val PENDINGIMPORTEDDEVICECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("PendingImportedDeviceCount"))
    val SIDEWALK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Sidewalk"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESTINATIONNAME_DESCRIPTOR)
        field(FAILEDIMPORTEDDEVICECOUNT_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INITIALIZEDIMPORTEDDEVICECOUNT_DESCRIPTOR)
        field(ONBOARDEDIMPORTEDDEVICECOUNT_DESCRIPTOR)
        field(PENDINGIMPORTEDDEVICECOUNT_DESCRIPTOR)
        field(SIDEWALK_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromIso8601(it) }
                DESTINATIONNAME_DESCRIPTOR.index -> builder.destinationName = deserializeString()
                FAILEDIMPORTEDDEVICECOUNT_DESCRIPTOR.index -> builder.failedImportedDeviceCount = deserializeLong()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INITIALIZEDIMPORTEDDEVICECOUNT_DESCRIPTOR.index -> builder.initializedImportedDeviceCount = deserializeLong()
                ONBOARDEDIMPORTEDDEVICECOUNT_DESCRIPTOR.index -> builder.onboardedImportedDeviceCount = deserializeLong()
                PENDINGIMPORTEDDEVICECOUNT_DESCRIPTOR.index -> builder.pendingImportedDeviceCount = deserializeLong()
                SIDEWALK_DESCRIPTOR.index -> builder.sidewalk = deserializeSidewalkGetStartImportInfoDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ImportTaskStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
